/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LamsToolService
implements ILamsToolService {
    private static Logger log = Logger.getLogger(LamsToolService.class);
    public IToolDAO toolDAO;
    public IToolSessionDAO toolSessionDAO;

    @Override
    public Set<User> getAllPotentialLearners(long toolSessionId) throws LamsToolServiceException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        if (session != null) {
            return session.getLearners();
        }
        log.error((Object)("No tool session found for " + toolSessionId + ". No potential learners being returned."));
        return new HashSet<User>();
    }

    @Override
    public IToolVO getToolBySignature(String toolSignature) {
        Tool tool = this.toolDAO.getToolBySignature(toolSignature);
        return tool.createBasicToolVO();
    }

    @Override
    public long getToolDefaultContentIdBySignature(String toolSignature) {
        return this.toolDAO.getToolDefaultContentIdBySignature(toolSignature);
    }

    public IToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public IToolSessionDAO getToolSessionDAO() {
        return this.toolSessionDAO;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }
}

