/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.wddx;

import java.io.IOException;
import java.io.Serializable;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class FlashMessage
implements Serializable {
    public static final int ERROR = 1;
    public static final int CRITICAL_ERROR = 2;
    public static final int OBJECT_MESSAGE = 3;
    private String messageKey;
    private Object messageValue;
    private int messageType;

    public FlashMessage(String messageKey, Object messageValue) {
        this.messageKey = messageKey;
        this.messageValue = messageValue;
        this.messageType = 3;
    }

    public FlashMessage(String messageKey, Object messageValue, int messageType) {
        this.messageKey = messageKey;
        this.messageValue = messageValue;
        this.messageType = messageType;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Object getMessageValue() {
        return this.messageValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append("messageKey='" + this.getMessageKey() + "'; ");
        sb.append("messageType='" + this.getMessageType() + "';");
        sb.append("messageValue='" + this.getMessageValue() + "'; ");
        return sb.toString();
    }

    public String serializeMessage() throws IOException {
        String wddxPacket = null;
        try {
            wddxPacket = WDDXProcessor.serialize(this);
        }
        catch (IOException ie) {
            throw new IOException("IOException occured while serializing " + ie.getMessage());
        }
        return wddxPacket;
    }

    public static FlashMessage getNoSuchUserExists(String methodName, Integer userID) {
        return new FlashMessage(methodName, "No such User with a user_id of :" + userID + " exists", 1);
    }

    public static FlashMessage getNoSuchOrganisationExists(String methodName, Integer organisationID) {
        return new FlashMessage(methodName, "No such Organisation with a organisationID of :" + organisationID + " exists", 1);
    }

    public static FlashMessage getUserNotAuthorized(String methodName, Integer userID) {
        return new FlashMessage(methodName, "User with user_id of:" + userID + " is not authorized to perfom this action:", 1);
    }

    public static FlashMessage getNoSuchWorkspaceFolderExsists(String methodName, Integer folderID) {
        return new FlashMessage(methodName, "No such WorkspaceFolder with a workspace_folder_id of " + folderID + " exists", 1);
    }

    public static FlashMessage getNoSuchLearningDesignExists(String methodName, Long learningDesignID) {
        return new FlashMessage(methodName, "No such LearningDesign with a learning_design_id of " + learningDesignID + " exists", 1);
    }

    public static FlashMessage getNoSuchActivityExists(String methodName, Long activityID) {
        return new FlashMessage(methodName, "No such Activity with an activity_id of " + activityID + " exists", 1);
    }

    public static FlashMessage getNoSuchWorkspaceFolderContentExsists(String methodName, Long folderContentID) {
        return new FlashMessage(methodName, "No such WorkspaceFolderContent with a folder_content_id of " + folderContentID + " exists", 1);
    }

    public static FlashMessage getNoSuchTheme(String methodName, Long themeID) {
        return new FlashMessage(methodName, "No such theme with a theme id of " + themeID + " exists", 1);
    }

    public static FlashMessage getWDDXPacketGetReceived(String urlCall) {
        return new FlashMessage(urlCall, "Invalid call. Expected WDDX packet in POST but received a GET", 1);
    }

    public static FlashMessage getExceptionOccured(String methodName, String message) {
        return new FlashMessage(methodName, "Unable to store due to an internal error. Contact support for help. Exception message was " + message, 1);
    }

    public static FlashMessage getNoSuchTool(String methodName, Long toolID) {
        return new FlashMessage(methodName, "No such Tool with tool id of " + toolID + " exists", 1);
    }

    public static FlashMessage getDataMissing(String methodName, String[] dataNames) {
        String str = "Request can not be completed as data is missing. ";
        if (dataNames != null && dataNames.length > 0) {
            str = str + " Fields:";
            for (int i = 0; i < dataNames.length; ++i) {
                str = str + (i != 0 ? ", " : "") + dataNames[i];
            }
        }
        return new FlashMessage(methodName, str, 1);
    }
}

