/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReadWriteLockTest
extends TestCase {
    ReadWriteLock lock;
    Exception ex = null;
    static /* synthetic */ Class class$org$jboss$cache$tests$ReadWriteLockTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.ex = null;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.lock = null;
        if (this.ex != null) {
            throw this.ex;
        }
    }

    public void testMoreWriteReleasesThanAcquisitions() throws InterruptedException {
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.lock.writeLock().acquire();
        this.lock.writeLock().release();
        this.lock.writeLock().release();
    }

    public void testMoreReadReleasesThanAcquisitions() throws InterruptedException {
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.lock.readLock().acquire();
        this.lock.readLock().release();
        try {
            this.lock.readLock().release();
            ReadWriteLockTest.fail((String)"read locks cannot be released more than acquired");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSimple() throws InterruptedException {
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.lock.readLock().acquire();
        this.lock.readLock().acquire();
        this.lock.writeLock().acquire();
        this.lock.writeLock().acquire();
    }

    public void testOneWriterMultipleReaders() throws InterruptedException {
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        Writer writer = new Writer("writer");
        Reader reader1 = new Reader("reader1");
        Reader reader2 = new Reader("reader2");
        writer.start();
        reader1.start();
        reader2.start();
        writer.join();
        reader1.join();
        reader2.join();
    }

    static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void log(String msg) {
        System.out.println(Thread.currentThread().getName() + ": " + msg);
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$ReadWriteLockTest == null ? (class$org$jboss$cache$tests$ReadWriteLockTest = ReadWriteLockTest.class$("org.jboss.cache.tests.ReadWriteLockTest")) : class$org$jboss$cache$tests$ReadWriteLockTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReadWriteLockTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Reader
    extends Thread {
        public Reader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReadWriteLockTest.log("acquiring RL");
                ReadWriteLockTest.this.lock.readLock().acquire();
                ReadWriteLockTest.log("acquired RL successfully");
                Reader.sleep(500L);
            }
            catch (InterruptedException e) {
                ReadWriteLockTest.this.ex = e;
            }
            finally {
                ReadWriteLockTest.log("releasing RL");
                ReadWriteLockTest.this.lock.readLock().release();
            }
        }
    }

    class Writer
    extends Thread {
        public Writer(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReadWriteLockTest.log("acquiring WL");
                ReadWriteLockTest.this.lock.writeLock().acquire();
                ReadWriteLockTest.log("acquired WL successfully");
                Writer.sleep(1000L);
            }
            catch (InterruptedException e) {
                ReadWriteLockTest.this.ex = e;
            }
            finally {
                ReadWriteLockTest.log("releasing WL");
                ReadWriteLockTest.this.lock.writeLock().release();
            }
        }
    }
}

