/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring;

import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ContributionTypes;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;
import org.lamsfoundation.lams.monitoring.ContributeActivityDTO;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.util.WebUtil;

public class ContributeDTOFactory {
    public static ContributeActivityDTO getContributeActivityDTO(Long lessonID, SimpleActivity activity, ILamsCoreToolService toolService) throws LamsToolServiceException {
        Integer[] contributionType;
        ContributeActivityDTO dto = null;
        SimpleActivityStrategy strategy = activity.getSimpleActivityStrategy();
        if (strategy != null && (contributionType = activity.getSimpleActivityStrategy().getContributionType()).length > 0) {
            dto = new ContributeActivityDTO((Activity)activity);
            for (int i = 0; i < contributionType.length; ++i) {
                Integer contributionTypeEntry = contributionType[i];
                String url = ContributeDTOFactory.getURL(lessonID, activity, contributionTypeEntry, toolService);
                dto.addContribution(contributionTypeEntry, url);
            }
        }
        return dto;
    }

    private static String getURL(Long lessonID, SimpleActivity activity, Integer contributionTypeEntry, ILamsCoreToolService toolService) throws LamsToolServiceException {
        String url = null;
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            if (contributionTypeEntry.equals(ContributionTypes.MODERATION)) {
                url = toolService.getToolModerateURL(toolActivity);
            } else if (contributionTypeEntry.equals(ContributionTypes.DEFINE_LATER)) {
                url = toolService.getToolDefineLaterURL(toolActivity);
            }
        }
        if (url == null) {
            url = toolService.getToolContributionURL(lessonID, (Activity)activity);
        }
        return url != null ? WebUtil.convertToFullURL(url) : null;
    }

    public static ContributeActivityDTO getContributeActivityDTO(ComplexActivity activity) {
        return new ContributeActivityDTO((Activity)activity);
    }
}

