/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class GateAction
extends LamsDispatchAction {
    private IMonitoringService monitoringService;
    private ICoreLearnerService learnerService;
    private static final String VIEW_SYNCH_GATE = "viewSynchGate";
    private static final String VIEW_PERMISSION_GATE = "viewPermissionGate";
    private static final String VIEW_SCHEDULE_GATE = "viewScheduleGate";
    private static final String ACTIVITY_FORM_FIELD = "activityId";
    private static final String TOTAL_LEARNERS_FORM_FIELD = "totalLearners";
    public static final String READ_ONLY = "readOnly";
    public static final String LOCAL_FILES = "localFiles";

    public ActionForward viewGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynaActionForm gateForm = (DynaActionForm)form;
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Long gateIdLong = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID", (boolean)true);
        if (gateIdLong == null) {
            gateIdLong = (Long)gateForm.get(ACTIVITY_FORM_FIELD);
        }
        long gateId = gateIdLong != null ? gateIdLong : -1L;
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        this.learnerService = MonitoringServiceProxy.getLearnerService(this.getServlet().getServletContext());
        Activity gate = this.monitoringService.getActivityById(gateId);
        int totalLearners = this.learnerService.getActiveLearnersByLesson(lessonId).size();
        gateForm.set(TOTAL_LEARNERS_FORM_FIELD, (Object)new Integer(totalLearners));
        gateForm.set(ACTIVITY_FORM_FIELD, (Object)gateIdLong);
        gateForm.set(LOCAL_FILES, (Object)Boolean.FALSE);
        return this.findViewByGateType(mapping, gateForm, gate);
    }

    public ActionForward openGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        DynaActionForm gateForm = (DynaActionForm)form;
        GateActivity gate = this.monitoringService.openGate((Long)gateForm.get(ACTIVITY_FORM_FIELD));
        return this.findViewByGateType(mapping, gateForm, (Activity)gate);
    }

    public ActionForward exportPortfolio(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynaActionForm gateForm = (DynaActionForm)form;
        ActionForward forward = this.viewGate(mapping, form, request, response);
        gateForm.set(READ_ONLY, (Object)Boolean.TRUE);
        gateForm.set(LOCAL_FILES, (Object)Boolean.TRUE);
        return forward;
    }

    private ActionForward findViewByGateType(ActionMapping mapping, DynaActionForm gateForm, Activity gate) {
        if (gate != null) {
            if (gate.isSynchGate()) {
                return this.viewSynchGate(mapping, gateForm, (SynchGateActivity)gate);
            }
            if (gate.isScheduleGate()) {
                return this.viewScheduleGate(mapping, gateForm, (ScheduleGateActivity)gate);
            }
            if (gate.isPermissionGate()) {
                return this.viewPermissionGate(mapping, gateForm, (PermissionGateActivity)gate);
            }
            throw new MonitoringServiceException("Invalid gate activity. gate id [" + gate.getActivityId() + "] - the type [" + gate.getActivityTypeId() + "] is not a gate type");
        }
        throw new MonitoringServiceException("Gate activity missing. ");
    }

    private ActionForward viewPermissionGate(ActionMapping mapping, DynaActionForm gateForm, PermissionGateActivity permissionGate) {
        gateForm.set("gate", (Object)permissionGate);
        gateForm.set("waitingLearners", (Object)new Integer(permissionGate.getWaitingLearners().size()));
        return mapping.findForward(VIEW_PERMISSION_GATE);
    }

    private ActionForward viewScheduleGate(ActionMapping mapping, DynaActionForm gateForm, ScheduleGateActivity scheduleGate) {
        gateForm.set("gate", (Object)scheduleGate);
        gateForm.set("waitingLearners", (Object)new Integer(scheduleGate.getWaitingLearners().size()));
        gateForm.set("startingTime", (Object)scheduleGate.getGateStartDateTime());
        gateForm.set("endingTime", (Object)scheduleGate.getGateEndDateTime());
        return mapping.findForward(VIEW_SCHEDULE_GATE);
    }

    private ActionForward viewSynchGate(ActionMapping mapping, DynaActionForm gateForm, SynchGateActivity synchgate) {
        gateForm.set("gate", (Object)synchgate);
        gateForm.set("waitingLearners", (Object)new Integer(synchgate.getWaitingLearners().size()));
        return mapping.findForward(VIEW_SYNCH_GATE);
    }
}

