/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingAJAXAction
extends LamsDispatchAction {
    private static final String CHOSEN_GROUPING_SCREEN = "chosenGrouping";
    private static final String VIEW_GROUPS_SCREEN = "viewGroups";
    private static final String PARAM_ACTIVITY_TITLE = "title";
    private static final String PARAM_ACTIVITY_DESCRIPTION = "description";
    public static final String PARAM_MAX_NUM_GROUPS = "maxNumberOfGroups";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_GROUPS = "groups";
    public static final String PARAM_MEMBERS = "members";
    public static final String PARAM_MAY_DELETE = "mayDelete";

    private Integer getUserId(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private void writeAJAXResponse(HttpServletResponse response, String output) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        if (output.length() > 0) {
            writer.println(output);
        }
    }

    private void writeAJAXOKResponse(HttpServletResponse response) throws IOException {
        this.writeAJAXResponse(response, "OK");
    }

    private Grouping getGrouping(GroupingActivity activity) {
        Grouping grouping = activity.getCreateGrouping();
        if (grouping == null) {
            String error = "Grouping activity missing grouping. Activity was " + activity + " Grouping was " + grouping;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        return grouping;
    }

    public ActionForward startGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        GroupingActivity activity = monitoringService.getGroupingActivityById(activityID);
        Grouping grouping = activity.getCreateGrouping();
        if (grouping == null) {
            String error = "Grouping activity missing grouping. Activity was " + activity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        request.setAttribute("activityID", (Object)activityID);
        request.setAttribute("lessonID", (Object)lessonId);
        request.setAttribute(PARAM_ACTIVITY_TITLE, (Object)activity.getTitle());
        request.setAttribute(PARAM_ACTIVITY_DESCRIPTION, (Object)activity.getDescription());
        if (grouping.isChosenGrouping()) {
            request.setAttribute(PARAM_MAX_NUM_GROUPS, (Object)grouping.getMaxNumberOfGroups());
            Set groups = grouping.getGroups();
            Iterator iter = groups.iterator();
            boolean mayDelete = true;
            while (mayDelete && iter.hasNext()) {
                Group group = (Group)iter.next();
                mayDelete = group.mayBeDeleted();
            }
            request.setAttribute(PARAM_MAY_DELETE, (Object)mayDelete);
            return mapping.findForward(CHOSEN_GROUPING_SCREEN);
        }
        TreeSet groups = new TreeSet(new GroupComparator());
        groups.addAll(grouping.getGroups());
        request.setAttribute(PARAM_GROUPS, groups);
        return mapping.findForward(VIEW_GROUPS_SCREEN);
    }

    public ActionForward getGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        GroupingActivity activity = monitoringService.getGroupingActivityById(activityID);
        Grouping grouping = this.getGrouping(activity);
        TreeSet sortedGroups = new TreeSet(new GroupComparator());
        sortedGroups.addAll(grouping.getGroups());
        String groupOutput = "";
        boolean first = true;
        for (Group group : sortedGroups) {
            Long groupId = group.getGroupId();
            String name = group.getGroupName();
            Integer numberOfMembers = group.getUsers().size();
            if (!first) {
                groupOutput = groupOutput + ";";
            } else {
                first = false;
            }
            groupOutput = groupOutput + groupId + "," + name + "," + numberOfMembers;
        }
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    public ActionForward getClassMembersNotGrouped(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SortedSet<User> users = monitoringService.getClassMembersNotGrouped(lessonID, activityID);
        String groupOutput = this.buildUserString(users);
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    public ActionForward getGroupMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        GroupingActivity activity = monitoringService.getGroupingActivityById(activityID);
        Grouping grouping = this.getGrouping(activity);
        Set groups = grouping.getGroups();
        Iterator iter = groups.iterator();
        Group group = null;
        while (group == null && iter.hasNext()) {
            Group candidateGroup = (Group)iter.next();
            if (!groupID.equals(candidateGroup.getGroupId())) continue;
            group = candidateGroup;
        }
        if (group == null) {
            String error = "Group cannot be found. Activity was " + activity + " Grouping was " + grouping + " Grouping ID was " + groupID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Set users = group.getUsers();
        TreeSet<User> sortedUsers = new TreeSet<User>((Comparator<User>)new LastNameAlphabeticComparator());
        sortedUsers.addAll(users);
        String userOutput = this.buildUserString(sortedUsers);
        this.writeAJAXResponse(response, userOutput);
        return null;
    }

    private String buildUserString(SortedSet<User> sortedUsers) {
        String userOutput = "";
        boolean first = true;
        for (User user : sortedUsers) {
            Integer userID = user.getUserId();
            String lastName = user.getLastName();
            String firstName = user.getFirstName();
            if (!first) {
                userOutput = userOutput + ";";
            } else {
                first = false;
            }
            userOutput = userOutput + userID + "," + lastName + "," + firstName;
        }
        return userOutput;
    }

    public ActionForward addGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_NAME);
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        monitoringService.addGroup(activityID, name);
        this.writeAJAXResponse(response, "");
        return null;
    }

    public ActionForward removeGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        monitoringService.removeGroup(activityID, groupID);
        this.writeAJAXOKResponse(response);
        return null;
    }

    public ActionForward addMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        String members = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        if (members != null) {
            String[] membersSplit = members.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.addUsersToGroup(activityID, groupID, membersSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }

    public ActionForward removeMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long groupID = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupID");
        String members = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        if (members != null) {
            String[] membersSplit = members.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.removeUsersFromGroup(activityID, groupID, membersSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }
}

