/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.mc.dao.IMcContentDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McContentDAO
extends HibernateDaoSupport
implements IMcContentDAO {
    static Logger logger = Logger.getLogger((String)McContentDAO.class.getName());
    private static final String FIND_MC_CONTENT = "from " + McContent.class.getName() + " as mc where content_id=?";
    private static final String LOAD_MC_BY_SESSION = "select mc from McContent mc left join fetch mc.mcSessions session where session.mcSessionId=:sessionId";

    public McContent getMcContentByUID(Long uid) {
        return (McContent)this.getHibernateTemplate().get(McContent.class, (Serializable)uid);
    }

    public McContent findMcContentById(Long mcContentId) {
        logger.debug((Object)("doing findMcContentById" + mcContentId));
        String query = "from McContent as mc where mc.mcContentId = ?";
        logger.debug((Object)("query: " + query));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(FIND_MC_CONTENT).setLong(0, mcContentId.longValue()).list();
        logger.debug((Object)("list: " + list));
        if (list != null && list.size() > 0) {
            McContent mc = (McContent)list.get(0);
            return mc;
        }
        return null;
    }

    public McContent getMcContentBySession(final Long mcSessionId) {
        return (McContent)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(McContentDAO.LOAD_MC_BY_SESSION).setLong("sessionId", mcSessionId.longValue()).uniqueResult();
            }
        });
    }

    public void saveMcContent(McContent mcContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        logger.debug((Object)"before saveOrUpdate");
        this.getHibernateTemplate().saveOrUpdate((Object)mcContent);
        logger.debug((Object)"after saveOrUpdate");
    }

    public void updateMcContent(McContent mcContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)mcContent);
    }

    public void saveOrUpdateMc(McContent mc) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        logger.debug((Object)("before saveOrUpdateMc: " + mc));
        this.getHibernateTemplate().saveOrUpdate((Object)mc);
    }

    public void removeMcById(Long mcContentId) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcContentId != null && (list = this.getSession().createQuery(FIND_MC_CONTENT).setLong(0, mcContentId.longValue()).list()) != null && list.size() > 0) {
            McContent mc = (McContent)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)mc);
            templ.flush();
        }
    }

    public void removeMc(McContent mcContent) {
        this.getHibernateTemplate().delete((Object)mcContent);
    }

    public void removeMcSessions(McContent mcContent) {
        this.getHibernateTemplate().deleteAll((Collection)mcContent.getMcSessions());
    }

    public void addMcSession(Long mcContentId, McSession mcSession) {
        McContent content = this.findMcContentById(mcContentId);
        mcSession.setMcContent(content);
        content.getMcSessions().add(mcSession);
        this.getHibernateTemplate().saveOrUpdate((Object)mcSession);
        this.getHibernateTemplate().saveOrUpdate((Object)content);
    }

    public List findAll(Class objClass) {
        String query = "from obj in class " + objClass.getName();
        return this.getHibernateTemplate().find(query);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }
}

