/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.mc.dao.IMcSessionDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McSessionDAO
extends HibernateDaoSupport
implements IMcSessionDAO {
    private static final String FIND_MC_SESSION_CONTENT = "from " + McSession.class.getName() + " as mcs where mc_session_id=?";
    private static final String LOAD_MCSESSION_BY_USER = "select ms from McSession ms left join fetch ms.mcQueUsers user where user.queUsrId=:userId";
    private static final String GET_SESSIONS_FROM_CONTENT = "select ms.mcSessionId from McSession ms where ms.mcContent=:mcContent";
    private static final String COUNT_SESSION_COMPLETE = "from mcSession in class McSession where mcSession.sessionStatus='COMPLETED'";
    private static final String COUNT_SESSION_INCOMPLETE = "from mcSession in class McSession where mcSession.sessionStatus='INCOMPLETE'";
    private static final String GET_SESSIONNAMES_FROM_CONTENT = "select mcs.session_name from McSession mcs where mcs.mcContent=:mcContent order by mcs.mcSessionId";

    public McSession getMcSessionByUID(Long uid) {
        return (McSession)this.getHibernateTemplate().get(McSession.class, (Serializable)uid);
    }

    public McSession findMcSessionById(Long mcSessionId) {
        String query = "from McSession mcs where mcs.mcSessionId=?";
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(query).setLong(0, mcSessionId.longValue()).list();
        if (list != null && list.size() > 0) {
            McSession mcs = (McSession)list.get(0);
            return mcs;
        }
        return null;
    }

    public int countSessionComplete() {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(COUNT_SESSION_COMPLETE).list();
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public int countSessionComplete(McContent mcContent) {
        this.logger.debug((Object)("starting countSessionComplete: " + mcContent));
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(COUNT_SESSION_COMPLETE).list();
        int sessionCount = 0;
        if (list != null && list.size() > 0) {
            McSession mcSession = (McSession)list.get(0);
            this.logger.debug((Object)("mcSession: " + mcSession));
            this.logger.debug((Object)("local session's content uid versus incoming content uid: " + mcSession.getMcContent().getUid().intValue() + " versus " + mcContent.getUid().intValue()));
            if (mcSession.getMcContent().getUid().intValue() == mcContent.getUid().intValue()) {
                ++sessionCount;
            }
        }
        this.logger.debug((Object)("sessionCount: " + sessionCount));
        return sessionCount;
    }

    public int countSessionIncomplete() {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(COUNT_SESSION_INCOMPLETE).list();
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public void saveMcSession(McSession mcSession) {
        this.getHibernateTemplate().save((Object)mcSession);
    }

    public void updateMcSession(McSession mcSession) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)mcSession);
    }

    public void removeMcSessionByUID(Long uid) {
        McSession ms = (McSession)this.getHibernateTemplate().get(McSession.class, (Serializable)uid);
        this.getHibernateTemplate().delete((Object)ms);
    }

    public void removeMcSessionById(Long mcSessionId) {
        List list;
        String query = "from McSession as mcs where mcs.mcSessionId =";
        HibernateTemplate templ = this.getHibernateTemplate();
        if (mcSessionId != null && (list = this.getSession().createQuery(FIND_MC_SESSION_CONTENT).setLong(0, mcSessionId.longValue()).list()) != null && list.size() > 0) {
            McSession mcs = (McSession)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)mcs);
            templ.flush();
        }
    }

    public void removeMcSession(McSession mcSession) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mcSession);
    }

    public McSession getMcSessionByUser(final Long userId) {
        return (McSession)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(McSessionDAO.LOAD_MCSESSION_BY_USER).setLong("userId", userId.longValue()).uniqueResult();
            }
        });
    }

    public void removeMcUsers(McSession mcSession) {
        this.getHibernateTemplate().deleteAll((Collection)mcSession.getMcQueUsers());
    }

    public void addMcUsers(Long mcSessionId, McQueUsr user) {
        McSession session = this.findMcSessionById(mcSessionId);
        user.setMcSession(session);
        session.getMcQueUsers().add(user);
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        this.getHibernateTemplate().saveOrUpdate((Object)session);
    }

    public List getSessionsFromContent(McContent mcContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_SESSIONS_FROM_CONTENT, "mcContent", (Object)mcContent);
    }

    public List getSessionNamesFromContent(McContent mcContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_SESSIONNAMES_FROM_CONTENT, "mcContent", (Object)mcContent);
    }
}

