/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.mc.dao.IMcUploadedFileDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McUploadedFile;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McUploadedFileDAO
extends HibernateDaoSupport
implements IMcUploadedFileDAO {
    static Logger logger = Logger.getLogger((String)McUploadedFileDAO.class.getName());
    private static final String GET_UPLOADED_FILES = "from McUploadedFile mcUploadedFile where mcUploadedFile.mcContent.mcContentId = :contentId";
    private static final String DELETE_FILES_META_DATA = "from mcUploadedFile in class McUploadedFile";

    public McUploadedFile getUploadedFileById(long submissionId) {
        return (McUploadedFile)this.getHibernateTemplate().load(McUploadedFile.class, (Serializable)new Long(submissionId));
    }

    public McUploadedFile loadUploadedFileById(long submissionId) {
        return (McUploadedFile)this.getHibernateTemplate().get(McUploadedFile.class, (Serializable)new Long(submissionId));
    }

    public void updateUploadFile(McUploadedFile mcUploadedFile) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)mcUploadedFile);
    }

    public void saveUploadFile(McUploadedFile mcUploadedFile) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().save((Object)mcUploadedFile);
    }

    public void createUploadFile(McUploadedFile mcUploadedFile) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().save((Object)mcUploadedFile);
    }

    public void UpdateUploadFile(McUploadedFile mcUploadedFile) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)mcUploadedFile);
    }

    public void cleanUploadedFilesMetaData() {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(DELETE_FILES_META_DATA).list();
        if (list != null && list.size() > 0) {
            for (McUploadedFile mcFile : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                templ.delete((Object)mcFile);
                templ.flush();
            }
        }
    }

    public void removeUploadFile(Long submissionId) {
        if (submissionId != null) {
            String query = "from uploadedFile in class org.lamsfoundation.lams.tool.mc.pojos.McUploadedFile where uploadedFile.submissionId = ?";
            Object obj = this.getSession().createQuery(query).setLong(0, submissionId.longValue()).uniqueResult();
            if (obj != null) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                this.getHibernateTemplate().delete(obj);
            }
        }
    }

    public List retrieveMcUploadedFiles(McContent mc) {
        List listFilenames = null;
        listFilenames = this.getHibernateTemplate().findByNamedParam(GET_UPLOADED_FILES, "contentId", (Object)mc.getMcContentId());
        return listFilenames;
    }

    public void deleteUploadFile(McUploadedFile mcUploadedFile) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mcUploadedFile);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }
}

