/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.mc.dao.IMcUserDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class McUserDAO
extends HibernateDaoSupport
implements IMcUserDAO {
    private static final String FIND_MC_USR_CONTENT = "from " + McQueUsr.class.getName() + " as mcu where que_usr_id=?";
    private static final String COUNT_USERS_IN_SESSION = "select mu.queUsrId from McQueUsr mu where mu.mcSession= :mcSession";
    private static final String COUNT_USERS = "select mu.queUsrId from McQueUsr";
    private static final String LOAD_USER_FOR_SESSION = "from mcQueUsr in class McQueUsr where  mcQueUsr.mcSessionId= :mcSessionId";

    public McQueUsr getMcUserByUID(Long uid) {
        return (McQueUsr)this.getHibernateTemplate().get(McQueUsr.class, (Serializable)uid);
    }

    public McQueUsr findMcUserById(Long userId) {
        String query = "from McQueUsr user where user.queUsrId=?";
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(query).setLong(0, userId.longValue()).list();
        if (list != null && list.size() > 0) {
            McQueUsr mcu = (McQueUsr)list.get(0);
            return mcu;
        }
        return null;
    }

    public List getMcUserBySessionOnly(McSession mcSession) {
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(LOAD_USER_FOR_SESSION).setLong("mcSessionId", mcSession.getUid().longValue()).list();
        return list;
    }

    public McQueUsr getMcUserBySession(Long queUsrId, Long mcSessionId) {
        String strGetUser = "from mcQueUsr in class McQueUsr where mcQueUsr.queUsrId=:queUsrId and mcQueUsr.mcSessionId=:mcSessionId";
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(strGetUser).setLong("queUsrId", queUsrId.longValue()).setLong("mcSessionId", mcSessionId.longValue()).list();
        if (list != null && list.size() > 0) {
            McQueUsr usr = (McQueUsr)list.get(0);
            return usr;
        }
        return null;
    }

    public void saveMcUser(McQueUsr mcUser) {
        this.getHibernateTemplate().save((Object)mcUser);
    }

    public void updateMcUser(McQueUsr mcUser) {
        this.getHibernateTemplate().update((Object)mcUser);
    }

    public void removeMcUserById(Long userId) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (userId != null && (list = this.getSession().createQuery(FIND_MC_USR_CONTENT).setLong(0, userId.longValue()).list()) != null && list.size() > 0) {
            McQueUsr mcu = (McQueUsr)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)mcu);
            templ.flush();
        }
    }

    public void removeMcUser(McQueUsr mcUser) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)mcUser);
    }

    public int getNumberOfUsers(McSession mcSession) {
        return this.getHibernateTemplate().findByNamedParam(COUNT_USERS_IN_SESSION, "mcSession", (Object)mcSession).size();
    }

    public int getTotalNumberOfUsers() {
        String query = "from obj in class McQueUsr";
        return this.getHibernateTemplate().find(query).size();
    }

    public int getTotalNumberOfUsers(McContent mcContent) {
        this.logger.debug((Object)("starting getTotalNumberOfUsers: " + mcContent));
        String strGetUser = "from mcQueUsr in class McQueUsr";
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(strGetUser).list();
        this.logger.debug((Object)("strGetUser: " + strGetUser));
        this.logger.debug((Object)("list: " + list));
        int totalUserCount = 0;
        if (list != null && list.size() > 0) {
            for (McQueUsr usr : list) {
                this.logger.debug((Object)("usr: " + usr));
                this.logger.debug((Object)("local usr content uid versus incoming content uid: " + usr.getMcSession().getMcContent().getUid().intValue() + " versus " + mcContent.getUid().intValue()));
                if (usr.getMcSession().getMcContent().getUid().intValue() != mcContent.getUid().intValue()) continue;
                this.logger.debug((Object)"increasing user count");
                ++totalUserCount;
            }
        }
        this.logger.debug((Object)("final totalUserCount: " + totalUserCount));
        return totalUserCount;
    }

    public int countUserComplete(McContent mcContent) {
        this.logger.debug((Object)("starting countUserComplete: " + mcContent));
        String strGetUser = "from mcQueUsr in class McQueUsr";
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(strGetUser).list();
        this.logger.debug((Object)("strGetUser: " + strGetUser));
        this.logger.debug((Object)("list: " + list));
        int totalUserCount = 0;
        if (list != null && list.size() > 0) {
            for (McQueUsr usr : list) {
                this.logger.debug((Object)("usr: " + usr));
                this.logger.debug((Object)("local usr content uid versus incoming content uid: " + usr.getMcSession().getMcContent().getUid().intValue() + " versus " + mcContent.getUid().intValue()));
                if (usr.getMcSession().getMcContent().getUid().intValue() != mcContent.getUid().intValue() || !usr.getMcSession().getSessionStatus().equals("COMPLETED")) continue;
                this.logger.debug((Object)"this user's session is COMPLETED,  increasing user count");
                ++totalUserCount;
            }
        }
        this.logger.debug((Object)("final totalUserCount: " + totalUserCount));
        return totalUserCount;
    }
}

