/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.pojos;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McUploadedFile;

public class McContent
implements Serializable {
    static Logger logger = Logger.getLogger((String)McContent.class.getName());
    private Long uid;
    private Long mcContentId;
    private String content;
    private String title;
    private String instructions;
    private boolean defineLater;
    private boolean runOffline;
    private boolean reflect;
    private Date creationDate;
    private Date updateDate;
    private boolean questionsSequenced;
    private long createdBy;
    private boolean contentInUse;
    private String offlineInstructions;
    private String onlineInstructions;
    private boolean retries;
    private boolean showReport;
    private boolean randomize;
    private boolean showMarks;
    private Integer passMark;
    private String reflectionSubject;
    private Set mcQueContents;
    private Set mcSessions;
    private Set mcAttachments;

    public McContent(Long mcContentId, String content, String title, String instructions, boolean defineLater, boolean runOffline, Date creationDate, Date updateDate, boolean questionsSequenced, long createdBy, boolean contentInUse, String offlineInstructions, String onlineInstructions, Integer passMark, boolean showReport, boolean randomize, boolean showMarks, boolean retries, boolean reflect, String reflectionSubject, Set mcQueContents, Set mcSessions, Set mcAttachments) {
        logger.debug((Object)"copying properties");
        this.mcContentId = mcContentId;
        this.content = content;
        this.title = title;
        this.instructions = instructions;
        this.defineLater = defineLater;
        this.runOffline = runOffline;
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.questionsSequenced = questionsSequenced;
        this.createdBy = createdBy;
        this.contentInUse = contentInUse;
        this.offlineInstructions = offlineInstructions;
        this.onlineInstructions = onlineInstructions;
        this.retries = retries;
        this.reflectionSubject = reflectionSubject;
        this.reflect = reflect;
        this.passMark = passMark;
        this.showReport = showReport;
        this.randomize = randomize;
        this.showMarks = showMarks;
        this.mcQueContents = mcQueContents;
        this.mcSessions = mcSessions;
        this.mcAttachments = mcAttachments;
    }

    public McContent() {
    }

    public McContent(Long mcContentId, Set mcQueContents, Set mcSessions) {
        this.mcContentId = mcContentId;
        this.mcQueContents = mcQueContents;
        this.mcSessions = mcSessions;
    }

    public static McContent newInstance(IToolContentHandler toolContentHandler, McContent mc, Long newContentId) throws ItemNotFoundException, RepositoryCheckedException {
        McContent newContent = new McContent(newContentId, mc.getContent(), mc.getTitle(), mc.getInstructions(), mc.isDefineLater(), mc.isRunOffline(), mc.getCreationDate(), mc.getUpdateDate(), mc.isQuestionsSequenced(), mc.getCreatedBy(), mc.isContentInUse(), mc.getOfflineInstructions(), mc.getOnlineInstructions(), mc.getPassMark(), mc.isShowReport(), mc.isRandomize(), mc.isShowMarks(), mc.isRetries(), mc.isReflect(), mc.getReflectionSubject(), new TreeSet(), new TreeSet(), new TreeSet());
        newContent.setMcQueContents(mc.deepCopyMcQueContent(newContent));
        newContent.setMcAttachments(mc.deepCopyMcAttachments(toolContentHandler, newContent));
        return newContent;
    }

    public Set deepCopyMcQueContent(McContent newMcContent) {
        TreeSet<McQueContent> newMcQueContent = new TreeSet<McQueContent>();
        for (McQueContent queContent : this.getMcQueContents()) {
            if (queContent.getMcContent() == null) continue;
            McQueContent mcQueContent = McQueContent.newInstance(queContent, newMcContent);
            newMcQueContent.add(mcQueContent);
        }
        return newMcQueContent;
    }

    public Set deepCopyMcAttachments(IToolContentHandler toolContentHandler, McContent newMcContent) throws ItemNotFoundException, RepositoryCheckedException {
        TreeSet<McUploadedFile> newMcQueContent = new TreeSet<McUploadedFile>();
        for (McUploadedFile mcUploadedFile : this.getMcAttachments()) {
            if (mcUploadedFile.getMcContent() == null) continue;
            McUploadedFile newMcUploadedFile = McUploadedFile.newInstance(toolContentHandler, mcUploadedFile, newMcContent);
            newMcQueContent.add(newMcUploadedFile);
        }
        return newMcQueContent;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Long getMcContentId() {
        return this.mcContentId;
    }

    public void setMcContentId(Long mcContentId) {
        this.mcContentId = mcContentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean runOffline) {
        this.runOffline = runOffline;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public boolean isQuestionsSequenced() {
        return this.questionsSequenced;
    }

    public void setQuestionsSequenced(boolean questionsSequenced) {
        this.questionsSequenced = questionsSequenced;
    }

    public long getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(long createdBy) {
        this.createdBy = createdBy;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public Integer getPassMark() {
        return this.passMark;
    }

    public void setPassMark(Integer passMark) {
        this.passMark = passMark;
    }

    public Set getMcQueContents() {
        if (this.mcQueContents == null) {
            this.setMcQueContents(new HashSet());
        }
        return this.mcQueContents;
    }

    public void setMcQueContents(Set mcQueContents) {
        this.mcQueContents = mcQueContents;
    }

    public Set getMcSessions() {
        if (this.mcSessions == null) {
            this.setMcSessions(new HashSet());
        }
        return this.mcSessions;
    }

    public void setMcSessions(Set mcSessions) {
        this.mcSessions = mcSessions;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uid", (Object)this.getUid()).toString();
    }

    public boolean isRetries() {
        return this.retries;
    }

    public void setRetries(boolean retries) {
        this.retries = retries;
    }

    public boolean isShowReport() {
        return this.showReport;
    }

    public void setShowReport(boolean showReport) {
        this.showReport = showReport;
    }

    public Set getMcAttachments() {
        if (this.mcAttachments == null) {
            this.mcAttachments = new TreeSet();
        }
        return this.mcAttachments;
    }

    public void setMcAttachments(Set mcAttachments) {
        this.mcAttachments = mcAttachments;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isReflect() {
        return this.reflect;
    }

    public void setReflect(boolean reflect) {
        this.reflect = reflect;
    }

    public String getReflectionSubject() {
        return this.reflectionSubject;
    }

    public void setReflectionSubject(String reflectionSubject) {
        this.reflectionSubject = reflectionSubject;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        McContent.logger = logger;
    }

    public boolean isShowMarks() {
        return this.showMarks;
    }

    public void setShowMarks(boolean showMarks) {
        this.showMarks = showMarks;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }
}

