/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.service;

import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McApplicationException;
import org.lamsfoundation.lams.tool.mc.dao.IMcContentDAO;
import org.lamsfoundation.lams.tool.mc.dao.IMcOptionsContentDAO;
import org.lamsfoundation.lams.tool.mc.dao.IMcQueContentDAO;
import org.lamsfoundation.lams.tool.mc.dao.IMcSessionDAO;
import org.lamsfoundation.lams.tool.mc.dao.IMcUploadedFileDAO;
import org.lamsfoundation.lams.tool.mc.dao.IMcUserDAO;
import org.lamsfoundation.lams.tool.mc.dao.IMcUsrAttemptDAO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McOptsContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.pojos.McUploadedFile;
import org.lamsfoundation.lams.tool.mc.pojos.McUsrAttempt;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McImportContentVersionFilter;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.springframework.dao.DataAccessException;

public class McServicePOJO
implements IMcService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager,
McAppConstants {
    static Logger logger = Logger.getLogger((String)McServicePOJO.class.getName());
    private final String repositoryUser = "lamc11";
    private final char[] repositoryId = new char[]{'l', 'a', 'm', 'c', '_', '1', '1'};
    private final String repositoryWorkspace = "lamc11";
    private IRepositoryService repositoryService;
    private ICredentials cred;
    private IMcContentDAO mcContentDAO;
    private IMcQueContentDAO mcQueContentDAO;
    private IMcOptionsContentDAO mcOptionsContentDAO;
    private IMcSessionDAO mcSessionDAO;
    private IMcUserDAO mcUserDAO;
    private IMcUsrAttemptDAO mcUsrAttemptDAO;
    private IMcUploadedFileDAO mcUploadedFileDAO;
    private IAuditService auditService;
    private IUserManagementService userManagementService;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private IToolContentHandler mcToolContentHandler = null;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;

    public void configureContentRepository() throws McApplicationException {
        logger.debug((Object)("retrieved repService: " + this.repositoryService));
        this.cred = new SimpleCredentials("lamc11", this.repositoryId);
        logger.debug((Object)("retrieved cred: " + this.cred));
        try {
            this.repositoryService.createCredentials(this.cred);
            logger.debug((Object)"created credentails.");
            this.repositoryService.addWorkspace(this.cred, "lamc11");
            logger.debug((Object)"created workspace.");
        }
        catch (ItemExistsException ie) {
            logger.warn((Object)"Tried to configure repository but it  appears to be already configured. Exception thrown by repository being ignored. ", (Throwable)ie);
        }
        catch (RepositoryCheckedException e) {
            String error = "Error occured while trying to configure repository. Unable to recover from error: " + e.getMessage();
            logger.error((Object)error, (Throwable)e);
            throw new McApplicationException(error, e);
        }
    }

    public void createMc(McContent mcContent) throws McApplicationException {
        try {
            logger.debug((Object)("using mcContent defineLater:" + mcContent.isDefineLater()));
            this.mcContentDAO.saveMcContent(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is creating mc content: " + e.getMessage(), e);
        }
    }

    public McContent retrieveMc(Long toolContentId) throws McApplicationException {
        try {
            return this.mcContentDAO.findMcContentById(toolContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is loading mc content: " + e.getMessage(), e);
        }
    }

    public void updateMcContent(McContent mcContent) throws McApplicationException {
        try {
            this.mcContentDAO.updateMcContent(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating mc content: " + e.getMessage(), e);
        }
    }

    public void createMcQue(McQueContent mcQueContent) throws McApplicationException {
        try {
            this.mcQueContentDAO.saveMcQueContent(mcQueContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is creating mc que content: " + e.getMessage(), e);
        }
    }

    public void updateMcQueContent(McQueContent mcQueContent) throws McApplicationException {
        try {
            this.mcQueContentDAO.updateMcQueContent(mcQueContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating mc que content: " + e.getMessage(), e);
        }
    }

    public List retrieveMcQueContentsByToolContentId(long mcContentId) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getMcQueContentsByContentId(mcContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is loading mc que usr: " + e.getMessage(), e);
        }
    }

    public McQueContent getQuestionContentByDisplayOrder(Long displayOrder, Long mcContentUid) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getQuestionContentByDisplayOrder(displayOrder, mcContentUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting mc que content by display order: " + e.getMessage(), e);
        }
    }

    public McQueContent getMcQueContentByUID(Long uid) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getMcQueContentByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting mc que content by uid: " + e.getMessage(), e);
        }
    }

    public List getAllQuestionEntriesSorted(long mcContentId) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getAllQuestionEntriesSorted(mcContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting all question entries: " + e.getMessage(), e);
        }
    }

    public void saveOrUpdateMcQueContent(McQueContent mcQueContent) throws McApplicationException {
        try {
            this.mcQueContentDAO.saveOrUpdateMcQueContent(mcQueContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating mc que content: " + e.getMessage(), e);
        }
    }

    public void removeQuestionContentByMcUid(Long mcContentUid) throws McApplicationException {
        try {
            this.mcQueContentDAO.removeQuestionContentByMcUid(mcContentUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing mc que content by mc content id: " + e.getMessage(), e);
        }
    }

    public void resetAllQuestions(Long mcContentUid) throws McApplicationException {
        try {
            this.mcQueContentDAO.resetAllQuestions(mcContentUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is resetting all questions: " + e.getMessage(), e);
        }
    }

    public void cleanAllQuestions(Long mcContentUid) throws McApplicationException {
        try {
            this.mcQueContentDAO.cleanAllQuestions(mcContentUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is cleaning all questions: " + e.getMessage(), e);
        }
    }

    public List getNextAvailableDisplayOrder(long mcContentId) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getNextAvailableDisplayOrder(mcContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the next available display order: " + e.getMessage(), e);
        }
    }

    public void createMcSession(McSession mcSession) throws McApplicationException {
        try {
            this.mcSessionDAO.saveMcSession(mcSession);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is creating mc session: " + e.getMessage(), e);
        }
    }

    public McSession getMcSessionByUID(Long uid) throws McApplicationException {
        try {
            return this.mcSessionDAO.getMcSessionByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting mcSession my uid: " + e.getMessage(), e);
        }
    }

    public void createMcQueUsr(McQueUsr mcQueUsr) throws McApplicationException {
        try {
            this.mcUserDAO.saveMcUser(mcQueUsr);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is creating mc QueUsr: " + e.getMessage(), e);
        }
    }

    public void updateMcQueUsr(McQueUsr mcQueUsr) throws McApplicationException {
        try {
            this.mcUserDAO.updateMcUser(mcQueUsr);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating mc QueUsr: " + e.getMessage(), e);
        }
    }

    public McQueUsr getMcUserBySession(Long queUsrId, Long mcSessionId) throws McApplicationException {
        try {
            return this.mcUserDAO.getMcUserBySession(queUsrId, mcSessionId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting mc QueUsr: " + e.getMessage(), e);
        }
    }

    public McQueUsr getMcUserByUID(Long uid) throws McApplicationException {
        try {
            return this.mcUserDAO.getMcUserByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the mc QueUsr by uid." + e.getMessage(), e);
        }
    }

    public McQueUsr retrieveMcQueUsr(Long userId) throws McApplicationException {
        try {
            McQueUsr mcQueUsr = this.mcUserDAO.findMcUserById(userId);
            return mcQueUsr;
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving McQueUsr: " + e.getMessage(), e);
        }
    }

    public void createMcUsrAttempt(McUsrAttempt mcUsrAttempt) throws McApplicationException {
        try {
            this.mcUsrAttemptDAO.saveMcUsrAttempt(mcUsrAttempt);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is creating mc UsrAttempt: " + e.getMessage(), e);
        }
    }

    public List getAttemptsForUserAndQuestionContent(Long queUsrId, Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptsForUserAndQuestionContent(queUsrId, mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting mc UsrAttempt by user id and que content id: " + e.getMessage(), e);
        }
    }

    public void updateMcUsrAttempt(McUsrAttempt mcUsrAttempt) throws McApplicationException {
        try {
            this.mcUsrAttemptDAO.updateMcUsrAttempt(mcUsrAttempt);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating mc UsrAttempt: " + e.getMessage(), e);
        }
    }

    public List getHighestMark(Long queUsrId) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getHighestMark(queUsrId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the learner's highest mark: " + e.getMessage(), e);
        }
    }

    public List getHighestAttemptOrder(Long queUsrId) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getHighestAttemptOrder(queUsrId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the learner's highest attempt order: " + e.getMessage(), e);
        }
    }

    public List getAttemptsForUser(Long queUsrId) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptsForUser(queUsrId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the attempts by user id: " + e.getMessage(), e);
        }
    }

    public List getAttemptForQueContent(Long queUsrId, Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptForQueContent(queUsrId, mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the learner's attempts by user id and que content id: " + e.getMessage(), e);
        }
    }

    public List getAttemptByAttemptOrder(Long queUsrId, Long mcQueContentId, Integer attemptOrder) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptByAttemptOrder(queUsrId, mcQueContentId, attemptOrder);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the learner's attempts by user id and que content id and attempt order: " + e.getMessage(), e);
        }
    }

    public McQueContent retrieveMcQueContentByUID(Long uid) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getMcQueContentByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving by uid  mc question content: " + e.getMessage(), e);
        }
    }

    public void cleanAllQuestionsSimple(Long mcContentId) throws McApplicationException {
        try {
            this.mcQueContentDAO.cleanAllQuestionsSimple(mcContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is cleaning mc question content by mcContentId : " + e.getMessage(), e);
        }
    }

    public List getAllQuestionEntries(Long uid) throws McApplicationException {
        try {
            return this.mcQueContentDAO.getAllQuestionEntries(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting by uid  mc question content: " + e.getMessage(), e);
        }
    }

    public void removeMcQueContentByUID(Long uid) throws McApplicationException {
        try {
            this.mcQueContentDAO.removeMcQueContentByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing by uid  mc question content: " + e.getMessage(), e);
        }
    }

    public List refreshQuestionContent(Long mcContentId) throws McApplicationException {
        try {
            return this.mcQueContentDAO.refreshQuestionContent(mcContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is refreshing  mc question content: " + e.getMessage(), e);
        }
    }

    public void removeMcQueContent(McQueContent mcQueContent) throws McApplicationException {
        try {
            this.mcQueContentDAO.removeMcQueContent(mcQueContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing mc question content: " + e.getMessage(), e);
        }
    }

    public void removeMcOptionsContent(McOptsContent mcOptsContent) throws McApplicationException {
        try {
            this.mcOptionsContentDAO.removeMcOptionsContent(mcOptsContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing the mc options content: " + e.getMessage(), e);
        }
    }

    public List populateCandidateAnswersDTO(Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.populateCandidateAnswersDTO(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is populating candidate answers dto" + e.getMessage(), e);
        }
    }

    public List getPersistedSelectedOptions(Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.getPersistedSelectedOptions(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is gettong persisted selected the mc options content: " + e.getMessage(), e);
        }
    }

    public McQueContent getQuestionContentByQuestionText(String question, Long mcContentId) {
        try {
            return this.mcQueContentDAO.getQuestionContentByQuestionText(question, mcContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving question content by question text: " + e.getMessage(), e);
        }
    }

    public McSession retrieveMcSession(Long mcSessionId) throws McApplicationException {
        try {
            return this.mcSessionDAO.findMcSessionById(mcSessionId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving by id mc session : " + e.getMessage(), e);
        }
    }

    public McSession findMcSessionById(Long mcSessionId) throws McApplicationException {
        try {
            return this.mcSessionDAO.findMcSessionById(mcSessionId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving by id mc session : " + e.getMessage(), e);
        }
    }

    public List getMcUserBySessionOnly(McSession mcSession) throws McApplicationException {
        try {
            return this.mcUserDAO.getMcUserBySessionOnly(mcSession);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving users by session: " + e.getMessage(), e);
        }
    }

    public McContent retrieveMcBySessionId(Long mcSessionId) throws McApplicationException {
        try {
            return this.mcContentDAO.getMcContentBySession(mcSessionId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving mc by session id: " + e.getMessage(), e);
        }
    }

    public List getSessionNamesFromContent(McContent mcContent) throws McApplicationException {
        try {
            return this.mcSessionDAO.getSessionNamesFromContent(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting session names from content: " + e.getMessage(), e);
        }
    }

    public void updateMc(McContent mc) throws McApplicationException {
        try {
            this.mcContentDAO.updateMcContent(mc);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating the mc content: " + e.getMessage(), e);
        }
    }

    public void updateMcSession(McSession mcSession) throws McApplicationException {
        try {
            this.mcSessionDAO.updateMcSession(mcSession);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating mc session : " + e.getMessage(), e);
        }
    }

    public void deleteMc(McContent mc) throws McApplicationException {
        try {
            this.mcContentDAO.removeMc(mc);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing the mc content: " + e.getMessage(), e);
        }
    }

    public void deleteMcById(Long mcId) throws McApplicationException {
        try {
            this.mcContentDAO.removeMcById(mcId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing by id the mc content: " + e.getMessage(), e);
        }
    }

    public int countSessionComplete(McContent mcContent) throws McApplicationException {
        try {
            return this.mcSessionDAO.countSessionComplete(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is counting incomplete sessions" + e.getMessage(), e);
        }
    }

    public int countSessionComplete() throws McApplicationException {
        try {
            return this.mcSessionDAO.countSessionComplete();
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is counting incomplete sessions" + e.getMessage(), e);
        }
    }

    public int countSessionIncomplete() throws McApplicationException {
        try {
            return this.mcSessionDAO.countSessionIncomplete();
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is counting incomplete sessions" + e.getMessage(), e);
        }
    }

    public void deleteMcSession(McSession mcSession) throws McApplicationException {
        try {
            this.mcSessionDAO.removeMcSession(mcSession);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is deleting the mc session: " + e.getMessage(), e);
        }
    }

    public void removeAttempt(McUsrAttempt attempt) throws McApplicationException {
        try {
            this.mcUsrAttemptDAO.removeMcUsrAttempt(attempt);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing the attempt: " + e.getMessage(), e);
        }
    }

    public List getMarksForContent(McContent mcContent) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getMarksForContent(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting marks " + e.getMessage(), e);
        }
    }

    public List getMarks() throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getMarks();
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting marks " + e.getMessage(), e);
        }
    }

    public McUsrAttempt getAttemptWithLastAttemptOrderForUserInSession(Long queUsrUid, Long mcSessionUid) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptWithLastAttemptOrderForUserInSession(queUsrUid, mcSessionUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting last attempt order for user in session" + e.getMessage(), e);
        }
    }

    public List getUserAttemptsForQuestionContentAndSessionUid(Long queUsrUid, Long mcQueContentId, Long mcSessionUid) {
        try {
            return this.mcUsrAttemptDAO.getUserAttemptsForQuestionContentAndSessionUid(queUsrUid, mcQueContentId, mcSessionUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting marks based on userid, sessionid and que content id " + e.getMessage(), e);
        }
    }

    public List getAttemptsForUserOnHighestAttemptOrderInSession(Long queUsrUid, Long mcSessionUid, Integer attemptOrder) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptsForUserOnHighestAttemptOrderInSession(queUsrUid, mcSessionUid, attemptOrder);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is finding whether attempt is correct based on userid, sessionid" + e.getMessage(), e);
        }
    }

    public List getAttemptsOnHighestAttemptOrder(Long queUsrUid, Long mcQueContentId, Long mcSessionUid, Integer attemptOrder) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptsOnHighestAttemptOrder(queUsrUid, mcQueContentId, mcSessionUid, attemptOrder);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting attempts on hightest attempt order" + e.getMessage(), e);
        }
    }

    public List getAttemptsForUserInSession(Long queUsrUid, Long mcSessionUid) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getAttemptsForUserInSession(queUsrUid, mcSessionUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is finding whether attempt is correct based on userid, sessionid" + e.getMessage(), e);
        }
    }

    public boolean getUserAttemptCorrectForQuestionContentAndSessionUid(Long queUsrUid, Long mcQueContentId, Long mcSessionUid, Integer attemptOrder) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getUserAttemptCorrectForQuestionContentAndSessionUid(queUsrUid, mcQueContentId, mcSessionUid, attemptOrder);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is finding whether attempt is correct based on userid, sessionid and que content id " + e.getMessage(), e);
        }
    }

    public McUsrAttempt getUserAttemptForQuestionContentAndSessionUid(Long queUsrUid, Long mcQueContentId, Long mcSessionUid, Integer attemptOrder) throws McApplicationException {
        try {
            return this.mcUsrAttemptDAO.getUserAttemptForQuestionContentAndSessionUid(queUsrUid, mcQueContentId, mcSessionUid, attemptOrder);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is running getUserAttemptForQuestionContentAndSessionUid:" + e.getMessage(), e);
        }
    }

    public void deleteMcQueUsr(McQueUsr mcQueUsr) throws McApplicationException {
        try {
            this.mcUserDAO.removeMcUser(mcQueUsr);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing the user: " + e.getMessage(), e);
        }
    }

    public void saveMcContent(McContent mc) throws McApplicationException {
        try {
            this.mcContentDAO.saveMcContent(mc);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is saving the mc content: " + e.getMessage(), e);
        }
    }

    public List findMcOptionsContentByQueId(Long mcQueContentId) throws McApplicationException {
        try {
            List list = this.mcOptionsContentDAO.findMcOptionsContentByQueId(mcQueContentId);
            return list;
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is finding by que id the mc options: " + e.getMessage(), e);
        }
    }

    public McOptsContent getMcOptionsContentByUID(Long uid) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.getMcOptionsContentByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting opt content by uid" + e.getMessage(), e);
        }
    }

    public List findMcOptionUidsByQueId(Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.findMcOptionUidsByQueId(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting opt uids" + e.getMessage(), e);
        }
    }

    public McQueContent findMcQuestionContentByUid(Long uid) throws McApplicationException {
        try {
            return this.mcQueContentDAO.findMcQuestionContentByUid(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting que content by uid" + e.getMessage(), e);
        }
    }

    public McOptsContent findMcOptionsContentByUid(Long uid) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.findMcOptionsContentByUid(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting opts by uid" + e.getMessage(), e);
        }
    }

    public void saveMcOptionsContent(McOptsContent mcOptsContent) throws McApplicationException {
        try {
            this.mcOptionsContentDAO.saveMcOptionsContent(mcOptsContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is saving the mc options content: " + e.getMessage(), e);
        }
    }

    public McOptsContent getOptionContentByOptionText(String option, Long mcQueContentUid) {
        try {
            return this.mcOptionsContentDAO.getOptionContentByOptionText(option, mcQueContentUid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is returning the option by option text: " + e.getMessage(), e);
        }
    }

    public List getCorrectOption(Long mcQueContentId) {
        try {
            return this.mcOptionsContentDAO.getCorrectOption(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is returning the  correct option: " + e.getMessage(), e);
        }
    }

    public void updateMcOptionsContent(McOptsContent mcOptsContent) throws McApplicationException {
        try {
            this.mcOptionsContentDAO.updateMcOptionsContent(mcOptsContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is updating the mc options content: " + e.getMessage(), e);
        }
    }

    public List getSessionsFromContent(McContent mcContent) throws McApplicationException {
        try {
            return this.mcSessionDAO.getSessionsFromContent(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting the mc sessions list: " + e.getMessage(), e);
        }
    }

    public List findMcOptionCorrectByQueId(Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.findMcOptionCorrectByQueId(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is getting correct/incorrect options list the mc options content: " + e.getMessage(), e);
        }
    }

    public void deleteMcOptionsContent(McOptsContent mcOptsContent) throws McApplicationException {
        try {
            this.mcOptionsContentDAO.removeMcOptionsContent(mcOptsContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing the mc options content: " + e.getMessage(), e);
        }
    }

    public List findMcOptionNamesByQueId(Long mcQueContentId) throws McApplicationException {
        try {
            return this.mcOptionsContentDAO.findMcOptionNamesByQueId(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is finding the mc options name: " + e.getMessage(), e);
        }
    }

    public void removeMcOptionsContentByQueId(Long mcQueContentId) throws McApplicationException {
        try {
            this.mcOptionsContentDAO.removeMcOptionsContentByQueId(mcQueContentId);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing by que id the mc options content: " + e.getMessage(), e);
        }
    }

    public void deleteMcOptionsContentByUID(Long uid) throws McApplicationException {
        try {
            this.mcOptionsContentDAO.removeMcOptionsContentByUID(uid);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is removing by uid the mc options content: " + e.getMessage(), e);
        }
    }

    public int countUserComplete(McContent mcContent) throws McApplicationException {
        try {
            return this.mcUserDAO.countUserComplete(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving completed user count: " + e.getMessage(), e);
        }
    }

    public int getTotalNumberOfUsers(McContent mcContent) throws McApplicationException {
        try {
            return this.mcUserDAO.getTotalNumberOfUsers(mcContent);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving total number of McQueUsr: " + e.getMessage(), e);
        }
    }

    public int getTotalNumberOfUsers() throws McApplicationException {
        try {
            return this.mcUserDAO.getTotalNumberOfUsers();
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is retrieving total number of McQueUsr: " + e.getMessage(), e);
        }
    }

    public User getCurrentUserData(String username) throws McApplicationException {
        try {
            logger.debug((Object)("getCurrentUserData: " + username));
            User user = this.userManagementService.getUserByLogin(username);
            if (user == null) {
                logger.error((Object)("No user with the username: " + username + " exists."));
                throw new McApplicationException("No user with that username exists.");
            }
            return user;
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Unable to find current user information Root Cause: [" + e.getMessage() + "]", e);
        }
    }

    public Lesson getCurrentLesson(long lessonId) throws McApplicationException {
        try {
            return new Lesson();
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is loading learning session:" + e.getMessage(), e);
        }
    }

    public boolean studentActivityOccurredGlobal(McContent mcContent) throws McApplicationException {
        for (McQueContent mcQueContent : mcContent.getMcQueContents()) {
            Iterator attemptsIterator = mcQueContent.getMcUsrAttempts().iterator();
            if (!attemptsIterator.hasNext()) continue;
            logger.debug((Object)"there is at least one attempt");
            return true;
        }
        logger.debug((Object)"there is no response for this content");
        return false;
    }

    public int countIncompleteSession(McContent mc) throws McApplicationException {
        int countIncompleteSession = 2;
        return countIncompleteSession;
    }

    public boolean studentActivityOccurred(McContent mc) throws McApplicationException {
        int countStudentActivity = 2;
        return countStudentActivity > 0;
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        logger.debug((Object)("start of copyToolContent with ids: " + fromContentId + " and " + toContentId));
        if (fromContentId == null) {
            logger.error((Object)"fromContentId is null.");
            logger.debug((Object)"attempt retrieving tool's default content id with signatute : lamc11");
            long defaultContentId = 0L;
            try {
                defaultContentId = this.getToolDefaultContentIdBySignature("lamc11");
                fromContentId = new Long(defaultContentId);
            }
            catch (Exception e) {
                logger.error((Object)"default content id has not been setup for signature: lamc11");
                throw new ToolException("WARNING! default content has not been setup for signaturelamc11 Can't continue!");
            }
        }
        if (toContentId == null) {
            logger.error((Object)"throwing ToolException: toContentId is null");
            throw new ToolException("toContentId is missing");
        }
        logger.debug((Object)("final - copyToolContent using ids: " + fromContentId + " and " + toContentId));
        try {
            McContent fromContent = this.mcContentDAO.findMcContentById(fromContentId);
            if (fromContent == null) {
                logger.error((Object)"fromContent is null.");
                logger.error((Object)"attempt retrieving tool's default content id with signatute : lamc11");
                long defaultContentId = 0L;
                try {
                    defaultContentId = this.getToolDefaultContentIdBySignature("lamc11");
                    fromContentId = new Long(defaultContentId);
                }
                catch (Exception e) {
                    logger.error((Object)"default content id has not been setup for signature: lamc11");
                    throw new ToolException("WARNING! default content has not been setup for signaturelamc11 Can't continue!");
                }
                fromContent = this.mcContentDAO.findMcContentById(fromContentId);
                logger.debug((Object)("using fromContent: " + fromContent));
            }
            logger.debug((Object)("final - retrieved fromContent: " + fromContent));
            logger.debug((Object)("final - before new instance using " + fromContent + " and " + toContentId));
            logger.debug((Object)("final - before new instance using mcToolContentHandler: " + this.mcToolContentHandler));
            try {
                McContent toContent = McContent.newInstance(this.mcToolContentHandler, fromContent, toContentId);
                if (toContent == null) {
                    logger.debug((Object)"throwing ToolException: WARNING!, retrieved toContent is null.");
                    throw new ToolException("WARNING! Fail to create toContent. Can't continue!");
                }
                logger.debug((Object)("retrieved toContent: " + toContent));
                this.mcContentDAO.saveMcContent(toContent);
                logger.debug((Object)("toContent has been saved successfully: " + toContent));
                logger.debug((Object)("end of copyToolContent with ids: " + fromContentId + " and " + toContentId));
            }
            catch (ItemNotFoundException e) {
                logger.error((Object)("exception occurred: " + (Object)((Object)e)));
            }
            catch (RepositoryCheckedException e) {
                logger.error((Object)("exception occurred: " + (Object)((Object)e)));
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"throwing ToolException: Exception occured when lams is copying content between content ids.");
            throw new ToolException("Exception occured when lams is copying content between content ids.");
        }
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        logger.debug((Object)("start of removeToolContent with toolContentId: " + toolContentId + "removeSessionData: " + removeSessionData));
        if (toolContentId == null) {
            logger.error((Object)"toolContentId is null");
            throw new ToolException("toolContentId is missing");
        }
        McContent mcContent = this.mcContentDAO.findMcContentById(toolContentId);
        logger.debug((Object)("retrieving mcContent: " + mcContent));
        if (mcContent != null) {
            logger.error((Object)"start deleting any uploaded file for this content from the content repository");
            for (McUploadedFile mcUploadedFile : mcContent.getMcAttachments()) {
                logger.debug((Object)("iterated mcUploadedFile : " + mcUploadedFile));
                String filesUuid = mcUploadedFile.getUuid();
                if (filesUuid == null || filesUuid.length() <= 0) continue;
                try {
                    this.mcToolContentHandler.deleteFile(new Long(filesUuid));
                }
                catch (RepositoryCheckedException e) {
                    logger.error((Object)("exception occured deleting files from content repository : " + (Object)((Object)e)));
                    throw new ToolException("undeletable file in the content repository");
                }
            }
            logger.debug((Object)"end deleting any uploaded files for this content.");
            Iterator sessionIterator = mcContent.getMcSessions().iterator();
            while (sessionIterator.hasNext()) {
                if (!removeSessionData) {
                    logger.debug((Object)"removeSessionData is false, throwing SessionDataExistsException.");
                    throw new SessionDataExistsException();
                }
                McSession mcSession = (McSession)sessionIterator.next();
                logger.debug((Object)("iterated mcSession : " + mcSession));
                for (McQueUsr mcQueUsr : mcSession.getMcQueUsers()) {
                    logger.debug((Object)("iterated mcQueUsr : " + mcQueUsr));
                    for (McUsrAttempt mcUsrAttempt : mcQueUsr.getMcUsrAttempts()) {
                        logger.debug((Object)("iterated mcUsrAttempt : " + mcUsrAttempt));
                        this.removeAttempt(mcUsrAttempt);
                        logger.debug((Object)("removed mcUsrAttempt : " + mcUsrAttempt));
                    }
                }
            }
        } else {
            logger.error((Object)"Warning!!!, We should have not come here. mcContent is null.");
            throw new ToolException("toolContentId is missing");
        }
        logger.debug((Object)("removed all existing responses of toolContent with toolContentId:" + toolContentId));
        this.mcContentDAO.removeMcById(toolContentId);
        logger.debug((Object)("removed mcContent:" + mcContent));
    }

    public void setAsForceCompleteSession(Long toolSessionId) throws McApplicationException {
        McSession mcSession = this.retrieveMcSession(toolSessionId);
        mcSession.setSessionStatus("COMPLETED");
        this.updateMcSession(mcSession);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAsForceComplete(Long userId) throws McApplicationException {
        McQueUsr mcQueUsr = this.retrieveMcQueUsr(userId);
        if (mcQueUsr == null) {
            logger.error((Object)"WARNING!: retrieved mcQueUsr is null.");
            throw new McApplicationException("Fail to setAsForceComplete based on null mcQueUsr.");
        }
        logger.error((Object)("retrieved mcQueUsr : " + mcQueUsr));
        logger.error((Object)("retrieved mcQueUsr  has the tool session : " + mcQueUsr.getMcSession()));
        McSession mcSession = mcQueUsr.getMcSession();
        if (mcSession != null) {
            Long usersToolSessionId = mcSession.getMcSessionId();
            logger.debug((Object)("retrieved  tool session has tool session id : " + usersToolSessionId));
            mcSession = this.retrieveMcSession(usersToolSessionId);
            logger.debug((Object)("retrieved  mcSession is : " + mcSession));
            mcSession.setSessionStatus("COMPLETED");
            logger.debug((Object)"updated  mcSession to COMPLETED : ");
            this.updateMcSession(mcSession);
            logger.debug((Object)"updated  mcSession to COMPLETED in the db : ");
            McContent mcContent = mcSession.getMcContent();
            logger.debug((Object)("mcSession uses mcContent : " + mcContent));
            logger.debug((Object)("mcSession uses mcContentId : " + mcContent.getMcContentId()));
            int countIncompleteSession = this.countIncompleteSession(mcContent);
            logger.debug((Object)("mcSession countIncompleteSession : " + countIncompleteSession));
            if (countIncompleteSession != 0) return;
            mcContent.setContentInUse(false);
            this.updateMc(mcContent);
            logger.debug((Object)("mcContent has been updated for contentInUse" + mcContent));
            return;
        }
        logger.error((Object)"WARNING!: retrieved mcSession is null.");
        throw new McApplicationException("Fail to setAsForceComplete based on null mcSession.");
    }

    public void unsetAsDefineLater(Long toolContentId) throws McApplicationException {
        logger.debug((Object)("request for unsetAsDefineLater with toolContentId: " + toolContentId));
        if (toolContentId == null) {
            logger.error((Object)"WARNING!: retrieved toolContentId is null.");
            throw new McApplicationException("Fail to setAsDefineLater based on null toolContentId.");
        }
        McContent mcContent = this.mcContentDAO.findMcContentById(toolContentId);
        if (mcContent == null) {
            logger.error((Object)"WARNING!!!: retrieved mcContent is null.");
            throw new McApplicationException("Fail to unsetAsDefineLater based on null mcContent.");
        }
        mcContent.setDefineLater(false);
        this.createMc(mcContent);
        logger.debug((Object)("mcContent has been updated for unsetAsDefineLater: " + mcContent));
    }

    public void setAsDefineLater(Long toolContentId) throws DataMissingException, ToolException {
        logger.debug((Object)("request for setAsDefineLater with toolContentId: " + toolContentId));
        if (toolContentId == null) {
            logger.error((Object)"throwing DataMissingException: WARNING!: retrieved toolContentId is null.");
            throw new DataMissingException("toolContentId is missing");
        }
        McContent mcContent = this.retrieveMc(toolContentId);
        if (mcContent == null) {
            logger.error((Object)"throwing DataMissingException: WARNING!: retrieved mcContent is null.");
            throw new DataMissingException("mcContent is missing");
        }
        mcContent.setDefineLater(true);
        this.saveMcContent(mcContent);
        logger.debug((Object)("success: end of setAsDefineLater on toolContentId:" + toolContentId));
    }

    public void setAsRunOffline(Long toolContentId) throws DataMissingException, ToolException {
        logger.debug((Object)("request for setAsRunOffline with toolContentId:" + toolContentId));
        if (toolContentId == null) {
            logger.error((Object)"throwing DataMissingException: WARNING!: retrieved toolContentId is null.");
            throw new DataMissingException("toolContentId is missing");
        }
        McContent mcContent = this.mcContentDAO.findMcContentById(toolContentId);
        if (mcContent == null) {
            logger.error((Object)"throwing DataMissingException: WARNING!: retrieved mcContent is null.");
            throw new DataMissingException("mcContent is missing");
        }
        mcContent.setRunOffline(true);
        this.saveMcContent(mcContent);
        logger.debug((Object)("success: end of setAsRunOffline on toolContentId:" + toolContentId));
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        McContent toolContentObj = this.mcContentDAO.findMcContentById(toolContentId);
        if (toolContentObj == null) {
            long defaultContentId = this.getToolDefaultContentIdBySignature("lamc11");
            toolContentObj = this.mcContentDAO.findMcContentById(defaultContentId);
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the multiple choice tool");
        }
        try {
            toolContentObj = McContent.newInstance(null, toolContentObj, toolContentId);
            toolContentObj.setMcSessions(null);
            Set files = toolContentObj.getMcAttachments();
            for (McUploadedFile file : files) {
                file.setMcContent(null);
            }
            this.exportContentService.registerFileClassForExport(McUploadedFile.class.getName(), "uuid", null);
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, this.mcToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new ToolException((Throwable)e);
        }
        catch (RepositoryCheckedException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(McUploadedFile.class.getName(), "uuid", null, "fileName", "fileProperty", null, null);
            this.exportContentService.registerImportVersionFilterClass(McImportContentVersionFilter.class);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.mcToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof McContent)) {
                throw new ImportToolContentException("Import MC tool content failed. Deserialized object is " + toolPOJO);
            }
            McContent toolContentObj = (McContent)toolPOJO;
            toolContentObj.setMcContentId(toolContentId);
            toolContentObj.setCreatedBy(newUserUid.intValue());
            Set files = toolContentObj.getMcAttachments();
            for (McUploadedFile file : files) {
                file.setMcContent(toolContentObj);
            }
            this.mcContentDAO.saveMcContent(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public boolean existsSession(Long toolSessionId) {
        McSession mcSession = this.retrieveMcSession(toolSessionId);
        if (mcSession == null) {
            logger.error((Object)("mcSession does not exist yet: " + toolSessionId));
            return false;
        }
        logger.debug((Object)("retrieving an existing mcSession: " + mcSession + " " + toolSessionId));
        return true;
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        logger.debug((Object)("start of createToolSession with ids: " + toolSessionId + " and " + toolContentId));
        logger.debug((Object)("toolSessionName: " + toolSessionName));
        if (toolSessionId == null) {
            logger.error((Object)"toolSessionId is null");
            throw new ToolException("toolSessionId is missing");
        }
        long defaultContentId = 0L;
        if (toolContentId == null) {
            logger.error((Object)"toolContentId is null.");
            logger.error((Object)"attempt retrieving tool's default content id with signatute : lamc11");
            try {
                defaultContentId = this.getToolDefaultContentIdBySignature("lamc11");
                toolContentId = new Long(defaultContentId);
                logger.debug((Object)("updated toolContentId to: " + toolContentId));
            }
            catch (Exception e) {
                logger.error((Object)"default content id has not been setup for signature: lamc11");
                throw new ToolException("WARNING! default content has not been setup for signaturelamc11 Can't continue!");
            }
        }
        logger.debug((Object)("final toolSessionId and toolContentId: " + toolSessionId + " " + toolContentId));
        McContent mcContent = this.mcContentDAO.findMcContentById(toolContentId);
        logger.debug((Object)("retrieved mcContent: " + mcContent));
        if (mcContent == null) {
            logger.error((Object)"mcContent is null.");
            logger.error((Object)"attempt retrieving tool's default content id with signatute : lamc11");
            try {
                defaultContentId = this.getToolDefaultContentIdBySignature("lamc11");
                toolContentId = new Long(defaultContentId);
                logger.debug((Object)("updated toolContentId to: " + toolContentId));
            }
            catch (Exception e) {
                logger.error((Object)"default content id has not been setup for signature: lamc11");
                throw new ToolException("WARNING! default content has not been setup for signaturelamc11 Can't continue!");
            }
            mcContent = this.mcContentDAO.findMcContentById(toolContentId);
        }
        logger.debug((Object)("final - retrieved mcContent: " + mcContent));
        if (!this.existsSession(toolSessionId)) {
            try {
                McSession mcSession = new McSession(toolSessionId, new Date(System.currentTimeMillis()), "INCOMPLETE", toolSessionName, mcContent, new TreeSet());
                logger.debug((Object)("created mcSession: " + mcSession));
                this.mcSessionDAO.saveMcSession(mcSession);
                logger.debug((Object)("created mcSession in the db: " + mcSession));
            }
            catch (Exception e) {
                logger.error((Object)"Error creating new toolsession in the db");
                throw new ToolException("Error creating new toolsession in the db: " + e);
            }
        }
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        logger.debug((Object)("start of removeToolSession with id: " + toolSessionId));
        if (toolSessionId == null) {
            logger.error((Object)"toolSessionId is null");
            throw new DataMissingException("toolSessionId is missing");
        }
        McSession mcSession = null;
        try {
            mcSession = this.retrieveMcSession(toolSessionId);
            logger.debug((Object)("retrieved mcSession: " + mcSession));
        }
        catch (McApplicationException e) {
            throw new DataMissingException("error retrieving mcSession: " + e);
        }
        catch (Exception e) {
            throw new ToolException("error retrieving mcSession: " + e);
        }
        if (mcSession == null) {
            logger.error((Object)"mcSession is null");
            throw new DataMissingException("mcSession is missing");
        }
        try {
            this.mcSessionDAO.removeMcSession(mcSession);
            logger.debug((Object)("mcSession " + mcSession + " has been deleted successfully."));
        }
        catch (McApplicationException e) {
            throw new ToolException("error deleting mcSession:" + e);
        }
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        logger.debug((Object)("start of leaveToolSession with toolSessionId:" + toolSessionId + " and learnerId:" + learnerId));
        logger.debug((Object)("make sure learnerService is available. Is it?" + this.learnerService));
        if (this.learnerService == null) {
            return "dummyNextUrl";
        }
        if (learnerId == null) {
            logger.error((Object)"learnerId is null");
            throw new DataMissingException("learnerId is missing");
        }
        if (toolSessionId == null) {
            logger.error((Object)"toolSessionId is null");
            throw new DataMissingException("toolSessionId is missing");
        }
        McSession mcSession = null;
        try {
            mcSession = this.retrieveMcSession(toolSessionId);
            logger.debug((Object)("retrieved mcSession: " + mcSession));
        }
        catch (McApplicationException e) {
            throw new DataMissingException("error retrieving mcSession: " + e);
        }
        catch (Exception e) {
            throw new ToolException("error retrieving mcSession: " + e);
        }
        mcSession.setSessionStatus("COMPLETED");
        this.mcSessionDAO.updateMcSession(mcSession);
        logger.debug((Object)("updated mcSession to COMPLETED" + mcSession));
        String nextUrl = this.learnerService.completeToolSession(toolSessionId, learnerId);
        logger.debug((Object)("nextUrl: " + nextUrl));
        if (nextUrl == null) {
            logger.error((Object)"nextUrl is null");
            throw new ToolException("nextUrl is null");
        }
        return nextUrl;
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        throw new ToolException("not yet implemented");
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        throw new ToolException("not yet implemented");
    }

    public IToolVO getToolBySignature(String toolSignature) throws McApplicationException {
        logger.debug((Object)("attempt retrieving tool with signature : " + toolSignature));
        IToolVO tool = this.toolService.getToolBySignature(toolSignature);
        logger.debug((Object)("retrieved tool: " + tool));
        return tool;
    }

    public long getToolDefaultContentIdBySignature(String toolSignature) throws McApplicationException {
        long contentId = 0L;
        contentId = this.toolService.getToolDefaultContentIdBySignature(toolSignature);
        logger.debug((Object)("tool default contentId : " + contentId));
        return contentId;
    }

    public McQueContent getToolDefaultQuestionContent(long contentId) throws McApplicationException {
        McQueContent mcQueContent = this.mcQueContentDAO.getToolDefaultQuestionContent(contentId);
        logger.debug((Object)("retrieved mcQueContent : " + mcQueContent));
        return mcQueContent;
    }

    public List getToolSessionsForContent(McContent mc) {
        logger.debug((Object)("attempt retrieving listToolSessionIds for : " + mc));
        List listToolSessionIds = this.mcSessionDAO.getSessionsFromContent(mc);
        return listToolSessionIds;
    }

    public void removeAttachment(McContent content, McUploadedFile attachment) throws RepositoryCheckedException {
        try {
            attachment.setMcContent(null);
            content.getMcAttachments().remove(attachment);
            this.mcToolContentHandler.deleteFile(new Long(attachment.getUuid()));
            this.saveMcContent(content);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("EXCEPTION: An exception has occurred while trying to remove this attachment" + e.getMessage(), e);
        }
    }

    public NodeKey uploadFile(InputStream istream, String filename, String contentType, String fileType) throws RepositoryCheckedException {
        return this.mcToolContentHandler.uploadFile(istream, filename, contentType, fileType);
    }

    public NodeKey copyFile(Long uuid) throws RepositoryCheckedException {
        return this.mcToolContentHandler.copyFile(uuid);
    }

    public ITicket getRepositoryLoginTicket() throws McApplicationException {
        this.repositoryService = RepositoryProxy.getRepositoryService();
        logger.debug((Object)("retrieved repositoryService : " + this.repositoryService));
        SimpleCredentials credentials = new SimpleCredentials("lamc11", this.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, "lamc11");
            logger.debug((Object)("retrieved ticket: " + ticket));
            return ticket;
        }
        catch (AccessDeniedException e) {
            throw new McApplicationException("Access Denied to repository." + e.getMessage());
        }
        catch (WorkspaceNotFoundException e) {
            throw new McApplicationException("Workspace not found." + e.getMessage());
        }
        catch (LoginException e) {
            throw new McApplicationException("Login failed." + e.getMessage());
        }
    }

    public void deleteFromRepository(Long uuid, Long versionID) throws McApplicationException {
        ITicket ticket = this.getRepositoryLoginTicket();
        logger.debug((Object)("retrieved ticket: " + ticket));
        try {
            String[] files = this.repositoryService.deleteVersion(ticket, uuid, versionID);
            logger.debug((Object)("retrieved files: " + files));
        }
        catch (Exception e) {
            throw new McApplicationException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    public NodeKey uploadFileToRepository(InputStream stream, String fileName) throws McApplicationException {
        logger.debug((Object)"attempt getting the ticket");
        ITicket ticket = this.getRepositoryLoginTicket();
        logger.debug((Object)("retrieved ticket: " + ticket));
        try {
            NodeKey nodeKey = this.repositoryService.addFileItem(ticket, stream, fileName, null, null);
            logger.debug((Object)("retrieved nodeKey from repository service: " + nodeKey));
            return nodeKey;
        }
        catch (Exception e) {
            throw new McApplicationException("Exception occured while trying to upload file into the repository" + e.getMessage());
        }
    }

    public InputStream downloadFile(Long uuid, Long versionID) throws McApplicationException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            IVersionedNode node = this.repositoryService.getFileItem(ticket, uuid, null);
            logger.debug((Object)("retrieved node: " + node));
            return node.getFile();
        }
        catch (AccessDeniedException e) {
            throw new McApplicationException("AccessDeniedException occured while trying to download file " + e.getMessage());
        }
        catch (FileException e) {
            throw new McApplicationException("FileException occured while trying to download file " + e.getMessage());
        }
        catch (ItemNotFoundException e) {
            throw new McApplicationException("ItemNotFoundException occured while trying to download file " + e.getMessage());
        }
    }

    public void persistFile(String uuid, boolean isOnlineFile, String fileName, McContent mcContent) throws McApplicationException {
        logger.debug((Object)("attempt persisting file to the db: " + uuid + " " + isOnlineFile + " " + fileName + " " + mcContent));
        McUploadedFile mcUploadedFile = new McUploadedFile(uuid, isOnlineFile, fileName, mcContent);
        logger.debug((Object)("created mcUploadedFile: " + mcUploadedFile));
        this.mcUploadedFileDAO.saveUploadFile(mcUploadedFile);
        logger.debug((Object)("persisted mcUploadedFile: " + mcUploadedFile));
    }

    public void cleanUploadedFilesMetaData() throws McApplicationException {
        logger.debug((Object)"attempt cleaning up uploaded file meta data table from the db");
        this.mcUploadedFileDAO.cleanUploadedFilesMetaData();
        logger.debug((Object)"files meta data has been cleaned up");
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        McServicePOJO.logger = logger;
    }

    public ICredentials getCred() {
        return this.cred;
    }

    public void setCred(ICredentials cred) {
        this.cred = cred;
    }

    public char[] getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryUser() {
        return "lamc11";
    }

    public String getRepositoryWorkspace() {
        return "lamc11";
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public IMcContentDAO getMcContentDAO() {
        return this.mcContentDAO;
    }

    public void setMcContentDAO(IMcContentDAO mcContentDAO) {
        this.mcContentDAO = mcContentDAO;
    }

    public IMcOptionsContentDAO getMcOptionsContentDAO() {
        return this.mcOptionsContentDAO;
    }

    public void setMcOptionsContentDAO(IMcOptionsContentDAO mcOptionsContentDAO) {
        this.mcOptionsContentDAO = mcOptionsContentDAO;
    }

    public IMcQueContentDAO getMcQueContentDAO() {
        return this.mcQueContentDAO;
    }

    public void setMcQueContentDAO(IMcQueContentDAO mcQueContentDAO) {
        this.mcQueContentDAO = mcQueContentDAO;
    }

    public IMcSessionDAO getMcSessionDAO() {
        return this.mcSessionDAO;
    }

    public void setMcSessionDAO(IMcSessionDAO mcSessionDAO) {
        this.mcSessionDAO = mcSessionDAO;
    }

    public IMcUserDAO getMcUserDAO() {
        return this.mcUserDAO;
    }

    public void setMcUserDAO(IMcUserDAO mcUserDAO) {
        this.mcUserDAO = mcUserDAO;
    }

    public IMcUsrAttemptDAO getMcUsrAttemptDAO() {
        return this.mcUsrAttemptDAO;
    }

    public void setMcUsrAttemptDAO(IMcUsrAttemptDAO mcUsrAttemptDAO) {
        this.mcUsrAttemptDAO = mcUsrAttemptDAO;
    }

    public IRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IMcUploadedFileDAO getMcUploadedFileDAO() {
        return this.mcUploadedFileDAO;
    }

    public void setMcUploadedFileDAO(IMcUploadedFileDAO mcUploadedFileDAO) {
        this.mcUploadedFileDAO = mcUploadedFileDAO;
    }

    public IToolContentHandler getMcToolContentHandler() {
        return this.mcToolContentHandler;
    }

    public void setMcToolContentHandler(IToolContentHandler mcToolContentHandler) {
        this.mcToolContentHandler = mcToolContentHandler;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        McContent toolContentObj = new McContent();
        toolContentObj.setContentInUse(false);
        toolContentObj.setCreatedBy(user.getUserID().longValue());
        toolContentObj.setCreationDate(now);
        toolContentObj.setDefineLater(false);
        toolContentObj.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        toolContentObj.setOfflineInstructions(null);
        toolContentObj.setOnlineInstructions(null);
        toolContentObj.setReflect(false);
        toolContentObj.setReflectionSubject(null);
        toolContentObj.setRunOffline(false);
        toolContentObj.setTitle((String)importValues.get("title"));
        toolContentObj.setContent(null);
        toolContentObj.setUpdateDate(now);
        toolContentObj.setMcContentId(toolContentId);
        toolContentObj.setQuestionsSequenced(false);
        toolContentObj.setShowMarks(false);
        toolContentObj.setRandomize(false);
        toolContentObj.setShowReport(false);
        try {
            Boolean bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"allowredo");
            toolContentObj.setRetries(bool != null ? bool : false);
            bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"feedback");
            Integer minPassMark = WDDXProcessor.convertToInteger((Hashtable)importValues, (String)"minpassmark");
            toolContentObj.setPassMark(minPassMark != null ? minPassMark : new Integer(0));
            this.mcContentDAO.saveMcContent(toolContentObj);
            Vector questions = (Vector)importValues.get("questionanswers");
            if (questions != null) {
                for (Hashtable questionMap : questions) {
                    this.create102Question(questionMap, toolContentObj);
                }
            }
        }
        catch (WDDXProcessorConversionException e) {
            logger.error((Object)("Unable to content for activity " + toolContentObj.getTitle() + "properly due to a WDDXProcessorConversionException."), (Throwable)e);
            throw new ToolException("Invalid import data format for activity " + toolContentObj.getTitle() + "- WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
        }
        this.mcContentDAO.saveMcContent(toolContentObj);
    }

    private void create102Question(Hashtable questionMap, McContent toolContentObj) throws WDDXProcessorConversionException {
        McQueContent question = new McQueContent();
        question.setDisplayOrder(WDDXProcessor.convertToInteger((Hashtable)questionMap, (String)"order"));
        question.setFeedback((String)questionMap.get("feedback"));
        question.setQuestion(WebUtil.convertNewlines((String)((String)questionMap.get("question"))));
        question.setMark(new Integer(1));
        String correctAnswer = (String)questionMap.get("answer");
        Vector candidates = (Vector)questionMap.get("candidates");
        if (candidates != null) {
            for (Hashtable candidate : candidates) {
                String optionText = (String)candidate.get("answer");
                if (optionText == null || optionText.length() <= 0) continue;
                McOptsContent options = new McOptsContent();
                options.setCorrectOption(correctAnswer != null && correctAnswer.equals(optionText));
                options.setMcQueOptionText(optionText);
                options.setMcQueContent(question);
                question.getMcOptionsContents().add(options);
            }
        }
        toolContentObj.getMcQueContents().add(question);
        question.setMcContent(toolContentObj);
        question.setMcContentId(toolContentObj.getUid());
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        McContent toolContentObj = null;
        if (toolContentId != null) {
            toolContentObj = this.retrieveMc(toolContentId);
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflect(true);
        toolContentObj.setReflectionSubject(description);
    }

    public List retrieveMcUploadedFiles(McContent mc) throws McApplicationException {
        try {
            return this.mcUploadedFileDAO.retrieveMcUploadedFiles(mc);
        }
        catch (DataAccessException e) {
            throw new McApplicationException("Exception occured when lams is loading mc uploaded files: " + e.getMessage(), e);
        }
    }

    public void persistFile(McContent content, McUploadedFile file) throws McApplicationException {
        logger.debug((Object)("in persistFile: " + file));
        logger.debug((Object)("in persistFile, content: " + content));
        content.getMcAttachments().add(file);
        file.setMcContent(content);
        this.mcContentDAO.saveOrUpdateMc(content);
        logger.debug((Object)("persisted mcUploadedFile: " + file));
    }

    public void removeFile(Long submissionId) throws McApplicationException {
        this.mcUploadedFileDAO.removeUploadFile(submissionId);
        logger.debug((Object)("removed mcUploadedFile: " + submissionId));
    }

    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        logger.debug((Object)("coreNotebookService: " + this.coreNotebookService));
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    public NotebookEntry getEntry(Long id, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(id, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }
}

