/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McCandidateAnswersDTO;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McQuestionContentDTO;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McOptsContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueContent;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.web.McAuthoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;

public class AuthoringUtil
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)AuthoringUtil.class.getName());

    protected static void setRadioboxes(McContent mcContent, McAuthoringForm mcAuthoringForm) {
        mcAuthoringForm.setQuestionsSequenced(mcContent.isQuestionsSequenced() ? "1" : "0");
        mcAuthoringForm.setRandomize(mcContent.isRandomize() ? "1" : "0");
        mcAuthoringForm.setShowMarks(mcContent.isShowMarks() ? "1" : "0");
        mcAuthoringForm.setRetries(mcContent.isRetries() ? "1" : "0");
        mcAuthoringForm.setSln(mcContent.isShowReport() ? "1" : "0");
        mcAuthoringForm.setReflect(mcContent.isReflect() ? "1" : "0");
    }

    public static boolean verifyMapNoEmptyString(Map map) {
        for (Map.Entry pairs : map.entrySet()) {
            logger.debug((Object)("using the  pair: " + pairs.getKey() + " = " + pairs.getValue()));
            if (pairs.getValue() == null || pairs.getValue().toString().length() != 0) continue;
            return false;
        }
        return true;
    }

    public static void cleanupRedundantQuestions(HttpServletRequest request, List existingQuestions, Map mapQuestionsContent, McContent mcContent, IMcService mcService) {
        logger.debug((Object)"doing cleanupRedundantQuestions...");
        logger.debug((Object)("using  existingQuestions: " + existingQuestions));
        logger.debug((Object)("using  mapQuestionsContent: " + mapQuestionsContent));
        logger.debug((Object)("using  mcContent: " + mcContent));
        boolean questionFound = false;
        for (McQueContent mcQueContent : existingQuestions) {
            logger.debug((Object)("mcQueContent:" + mcQueContent));
            Iterator itNewQuestionsMap = mapQuestionsContent.entrySet().iterator();
            questionFound = false;
            while (itNewQuestionsMap.hasNext()) {
                Map.Entry pairs = itNewQuestionsMap.next();
                logger.debug((Object)("using the  pair: " + pairs.getKey() + " = " + pairs.getValue()));
                logger.debug((Object)("mcQueContent.getQuestion(): " + mcQueContent.getQuestion() + "--" + pairs.getValue()));
                if (!mcQueContent.getQuestion().equals(pairs.getValue().toString())) continue;
                logger.debug((Object)("equals mcQueContent.getQuestion(): " + mcQueContent.getQuestion() + "--" + pairs.getValue()));
                questionFound = true;
                break;
            }
            if (questionFound) continue;
            String deletableQuestion = mcQueContent.getQuestion();
            logger.debug((Object)("found is false, delete this question " + deletableQuestion));
            mcQueContent = mcService.getQuestionContentByQuestionText(deletableQuestion, mcContent.getUid());
            logger.debug((Object)("found is false, delete this question " + mcQueContent));
            if (mcQueContent == null) continue;
            logger.debug((Object)("first removing from collection " + mcQueContent));
            mcContent.getMcQueContents().remove(mcQueContent);
            logger.debug((Object)"removed from collection ");
            mcService.removeMcQueContent(mcQueContent);
            logger.debug((Object)("removed mcQueContent from the db: " + mcQueContent));
        }
    }

    public static Map rebuildStartupGeneralOptionsContentMapfromDB(HttpServletRequest request, Map mapQuestionsUidContent, IMcService mcService) {
        TreeMap<String, Map> mapStartupGeneralOptionsContent = new TreeMap<String, Map>(new McComparator());
        Iterator itMap = mapQuestionsUidContent.entrySet().iterator();
        Long mapIndex = new Long(1L);
        while (itMap.hasNext()) {
            Map.Entry pairs = itMap.next();
            logger.debug((Object)("using the  pair: " + pairs.getKey() + " = " + pairs.getValue()));
            String currentQuestionUid = pairs.getValue().toString();
            logger.debug((Object)("currentQuestionUid: " + currentQuestionUid));
            List listQuestionOptions = mcService.findMcOptionsContentByQueId(new Long(currentQuestionUid));
            logger.debug((Object)("listQuestionOptions: " + listQuestionOptions));
            Map mapQuestionOptions = AuthoringUtil.generateOptionsMap(listQuestionOptions);
            mapStartupGeneralOptionsContent.put(mapIndex.toString(), mapQuestionOptions);
            mapIndex = new Long(mapIndex + 1L);
        }
        return mapStartupGeneralOptionsContent;
    }

    protected static List removeBlankEntries(List list) {
        LinkedList<McCandidateAnswersDTO> newList = new LinkedList<McCandidateAnswersDTO>();
        for (McCandidateAnswersDTO mcCandidateAnswersDTO : list) {
            logger.debug((Object)("mcCandidateAnswersDTO: " + mcCandidateAnswersDTO));
            if (mcCandidateAnswersDTO == null) continue;
            String ca = mcCandidateAnswersDTO.getCandidateAnswer();
            logger.debug((Object)("ca: " + ca));
            if (ca == null || ca.length() <= 0) continue;
            newList.add(mcCandidateAnswersDTO);
        }
        return newList;
    }

    public static Map generateOptionsMap(List listQuestionOptions) {
        TreeMap<String, String> mapOptsContent = new TreeMap<String, String>(new McComparator());
        Iterator listIterator = listQuestionOptions.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McOptsContent mcOptsContent = (McOptsContent)listIterator.next();
            logger.debug((Object)("mcOptsContent: " + mcOptsContent));
            mapOptsContent.put(mapIndex.toString(), mcOptsContent.getMcQueOptionText());
            mapIndex = new Long(mapIndex + 1L);
        }
        return mapOptsContent;
    }

    public static void updateExistingQuestionContent(HttpServletRequest request, Map mapFeedbackIncorrect, Map mapFeedbackCorrect, McQueContent mcQueContent, String displayOrder, IMcService mcService) {
        logger.debug((Object)"doing updateExistingQuestionContent...");
        logger.debug((Object)("using displayOrder: " + displayOrder));
        String incorrectFeedback = (String)mapFeedbackIncorrect.get(displayOrder);
        logger.debug((Object)("new  incorrectFeedback will be :" + incorrectFeedback));
        String correctFeedback = (String)mapFeedbackCorrect.get(displayOrder);
        logger.debug((Object)("new correctFeedback will be :" + correctFeedback));
        mcQueContent.setDisplayOrder(new Integer(displayOrder));
        mcService.saveOrUpdateMcQueContent(mcQueContent);
        logger.debug((Object)("updated mcQueContent in the db: " + mcQueContent));
    }

    public static Map rebuildQuestionMapfromDB(HttpServletRequest request, Long toolContentId, IMcService mcService) {
        TreeMap<String, String> mapQuestionsContent = new TreeMap<String, String>(new McComparator());
        logger.debug((Object)("toolContentId:" + toolContentId));
        McContent mcContent = mcService.retrieveMc(toolContentId);
        logger.debug((Object)("mcContent:" + mcContent));
        List list = mcService.refreshQuestionContent(mcContent.getUid());
        logger.debug((Object)("refreshed list:" + list));
        Iterator listIterator = list.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McQueContent mcQueContent = (McQueContent)listIterator.next();
            logger.debug((Object)("mcQueContent:" + mcQueContent));
            mapQuestionsContent.put(mapIndex.toString(), mcQueContent.getQuestion());
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("refreshed Map:" + mapQuestionsContent));
        return mapQuestionsContent;
    }

    public static Map rebuildFeedbackMapfromDB(HttpServletRequest request, Long toolContentId, IMcService mcService) {
        TreeMap<String, String> map = new TreeMap<String, String>(new McComparator());
        logger.debug((Object)("toolContentId:" + toolContentId));
        McContent mcContent = mcService.retrieveMc(toolContentId);
        logger.debug((Object)("mcContent:" + mcContent));
        List list = mcService.refreshQuestionContent(mcContent.getUid());
        logger.debug((Object)("refreshed list:" + list));
        Iterator listIterator = list.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McQueContent mcQueContent = (McQueContent)listIterator.next();
            logger.debug((Object)("mcQueContent:" + mcQueContent));
            String feedback = mcQueContent.getFeedback();
            logger.debug((Object)("feedback:" + feedback));
            map.put(mapIndex.toString(), feedback);
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("refreshed Map:" + map));
        return map;
    }

    public static Map rebuildQuestionUidMapfromDB(HttpServletRequest request, Long toolContentId, IMcService mcService) {
        TreeMap<String, Long> mapQuestionsContent = new TreeMap<String, Long>(new McComparator());
        logger.debug((Object)("toolContentId:" + toolContentId));
        McContent mcContent = mcService.retrieveMc(toolContentId);
        logger.debug((Object)("mcContent:" + mcContent));
        if (mcContent != null) {
            List list = mcService.refreshQuestionContent(mcContent.getUid());
            logger.debug((Object)("refreshed list:" + list));
            Iterator listIterator = list.iterator();
            Long mapIndex = new Long(1L);
            while (listIterator.hasNext()) {
                McQueContent mcQueContent = (McQueContent)listIterator.next();
                logger.debug((Object)("mcQueContent:" + mcQueContent));
                mapQuestionsContent.put(mapIndex.toString(), mcQueContent.getUid());
                mapIndex = new Long(mapIndex + 1L);
            }
        }
        logger.debug((Object)("refreshed Map:" + mapQuestionsContent));
        return mapQuestionsContent;
    }

    public static boolean isOptionSelected(Map mapGeneralSelectedOptionsContent, String optionText, String questionIndex) {
        Iterator itGSOMap = mapGeneralSelectedOptionsContent.entrySet().iterator();
        logger.debug((Object)("questionIndex: " + questionIndex));
        logger.debug((Object)("optionText: " + optionText));
        while (itGSOMap.hasNext()) {
            Map.Entry pairs = itGSOMap.next();
            if (!pairs.getKey().toString().equals(questionIndex)) continue;
            Map currentOptionsMap = (Map)pairs.getValue();
            logger.debug((Object)("currentOptionsMap: " + currentOptionsMap));
            boolean isOptionSelectedInMap = AuthoringUtil.isOptionSelectedInMap(optionText, currentOptionsMap);
            logger.debug((Object)("isOptionSelectedInMap: " + isOptionSelectedInMap));
            return isOptionSelectedInMap;
        }
        return false;
    }

    public static boolean isOptionSelectedInMap(String optionText, Map currentOptionsMap) {
        logger.debug((Object)("optionText: " + optionText));
        for (Map.Entry pairs : currentOptionsMap.entrySet()) {
            if (!pairs.getValue().toString().equals(optionText)) continue;
            logger.debug((Object)("option text found in the map: " + optionText));
            return true;
        }
        return false;
    }

    protected static List swapNodes(List listQuestionContentDTO, String questionIndex, String direction) {
        int intQuestionIndex;
        logger.debug((Object)"swapNodes:");
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        logger.debug((Object)("questionIndex:" + questionIndex));
        logger.debug((Object)("direction:" + direction));
        int intOriginalQuestionIndex = intQuestionIndex = new Integer(questionIndex).intValue();
        logger.debug((Object)("intQuestionIndex:" + intQuestionIndex));
        int replacedNodeIndex = 0;
        if (direction.equals("down")) {
            logger.debug((Object)"direction down:");
            replacedNodeIndex = ++intQuestionIndex;
        } else {
            logger.debug((Object)"direction up:");
            replacedNodeIndex = --intQuestionIndex;
        }
        logger.debug((Object)("replacedNodeIndex:" + replacedNodeIndex));
        logger.debug((Object)("replacing nodes:" + intOriginalQuestionIndex + " and " + replacedNodeIndex));
        McQuestionContentDTO mainNode = AuthoringUtil.extractNodeAtDisplayOrder(listQuestionContentDTO, intOriginalQuestionIndex);
        logger.debug((Object)("mainNode:" + mainNode));
        McQuestionContentDTO replacedNode = AuthoringUtil.extractNodeAtDisplayOrder(listQuestionContentDTO, replacedNodeIndex);
        logger.debug((Object)("replacedNode:" + replacedNode));
        if (mainNode == null || replacedNode == null) {
            logger.debug((Object)"mainNode/replacedNode is null");
            return listQuestionContentDTO;
        }
        List listFinalQuestionContentDTO = new LinkedList();
        listFinalQuestionContentDTO = AuthoringUtil.reorderSwappedListQuestionContentDTO(listQuestionContentDTO, intOriginalQuestionIndex, replacedNodeIndex, mainNode, replacedNode);
        logger.debug((Object)("listFinalQuestionContentDTO:" + listFinalQuestionContentDTO));
        return listFinalQuestionContentDTO;
    }

    protected static List reorderSwappedListQuestionContentDTO(List listQuestionContentDTO, int intOriginalQuestionIndex, int replacedNodeIndex, McQuestionContentDTO mainNode, McQuestionContentDTO replacedNode) {
        logger.debug((Object)("reorderSwappedListQuestionContentDTO: intOriginalQuestionIndex:" + intOriginalQuestionIndex));
        logger.debug((Object)("reorderSwappedListQuestionContentDTO: replacedNodeIndex:" + replacedNodeIndex));
        logger.debug((Object)("mainNode: " + mainNode));
        logger.debug((Object)("replacedNode: " + replacedNode));
        LinkedList<McQuestionContentDTO> listFinalQuestionContentDTO = new LinkedList<McQuestionContentDTO>();
        int queIndex = 0;
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            ++queIndex;
            McQuestionContentDTO tempNode = new McQuestionContentDTO();
            if (!mcQuestionContentDTO.getDisplayOrder().equals(new Integer(intOriginalQuestionIndex).toString()) && !mcQuestionContentDTO.getDisplayOrder().equals(new Integer(replacedNodeIndex).toString())) {
                logger.debug((Object)"normal copy ");
                tempNode.setQuestion(mcQuestionContentDTO.getQuestion());
                tempNode.setDisplayOrder(mcQuestionContentDTO.getDisplayOrder());
                tempNode.setFeedback(mcQuestionContentDTO.getFeedback());
                tempNode.setListCandidateAnswersDTO(mcQuestionContentDTO.getListCandidateAnswersDTO());
                tempNode.setCaCount(mcQuestionContentDTO.getCaCount());
                tempNode.setMark(mcQuestionContentDTO.getMark());
            } else if (mcQuestionContentDTO.getDisplayOrder().equals(new Integer(intOriginalQuestionIndex).toString())) {
                logger.debug((Object)"move type 1 ");
                tempNode.setQuestion(replacedNode.getQuestion());
                tempNode.setDisplayOrder(replacedNode.getDisplayOrder());
                tempNode.setFeedback(replacedNode.getFeedback());
                tempNode.setListCandidateAnswersDTO(replacedNode.getListCandidateAnswersDTO());
                tempNode.setCaCount(replacedNode.getCaCount());
                tempNode.setMark(replacedNode.getMark());
            } else if (mcQuestionContentDTO.getDisplayOrder().equals(new Integer(replacedNodeIndex).toString())) {
                logger.debug((Object)"move type 2 ");
                tempNode.setQuestion(mainNode.getQuestion());
                tempNode.setDisplayOrder(mainNode.getDisplayOrder());
                tempNode.setFeedback(mainNode.getFeedback());
                tempNode.setListCandidateAnswersDTO(mainNode.getListCandidateAnswersDTO());
                tempNode.setCaCount(mainNode.getCaCount());
                tempNode.setMark(mainNode.getMark());
            }
            listFinalQuestionContentDTO.add(tempNode);
        }
        logger.debug((Object)("final listFinalQuestionContentDTO:" + listFinalQuestionContentDTO));
        return listFinalQuestionContentDTO;
    }

    protected static List swapCandidateNodes(List listCandidates, String candidateIndex, String direction) {
        int intCandidateIndex;
        logger.debug((Object)"swapCandidateNodes:");
        logger.debug((Object)("listCandidates:" + listCandidates));
        logger.debug((Object)("candidateIndex:" + candidateIndex));
        logger.debug((Object)("direction:" + direction));
        int intOriginalCandidateIndex = intCandidateIndex = new Integer(candidateIndex).intValue();
        logger.debug((Object)("intCandidateIndex:" + intCandidateIndex));
        int replacedNodeIndex = 0;
        if (direction.equals("down")) {
            logger.debug((Object)"direction down:");
            replacedNodeIndex = ++intCandidateIndex;
        } else {
            logger.debug((Object)"direction up:");
            replacedNodeIndex = --intCandidateIndex;
        }
        logger.debug((Object)("replacedNodeIndex:" + replacedNodeIndex));
        logger.debug((Object)("replacing nodes:" + intOriginalCandidateIndex + " and " + replacedNodeIndex));
        McCandidateAnswersDTO mainNode = AuthoringUtil.extractCandidateAtOrder(listCandidates, intOriginalCandidateIndex);
        logger.debug((Object)("mainNode:" + mainNode));
        McCandidateAnswersDTO replacedNode = AuthoringUtil.extractCandidateAtOrder(listCandidates, replacedNodeIndex);
        logger.debug((Object)("replacedNode:" + replacedNode));
        if (mainNode == null || replacedNode == null) {
            logger.debug((Object)"mainNode/replacedNode is null");
            return listCandidates;
        }
        List listFinalCandidateDTO = new LinkedList();
        listFinalCandidateDTO = AuthoringUtil.reorderSwappedListCandidateDTO(listCandidates, intOriginalCandidateIndex, replacedNodeIndex, mainNode, replacedNode);
        logger.debug((Object)("listFinalCandidateDTO:" + listFinalCandidateDTO));
        return listFinalCandidateDTO;
    }

    protected static List reorderSwappedListCandidateDTO(List listCandidates, int intOriginalCandidateIndex, int replacedNodeIndex, McCandidateAnswersDTO mainNode, McCandidateAnswersDTO replacedNode) {
        logger.debug((Object)("reorderSwappedListCandidateDTO: intOriginalQuestionIndex:" + intOriginalCandidateIndex));
        logger.debug((Object)("reorderSwappedListCandidateDTO: replacedNodeIndex:" + replacedNodeIndex));
        logger.debug((Object)("mainNode: " + mainNode));
        logger.debug((Object)("replacedNode: " + replacedNode));
        LinkedList<McCandidateAnswersDTO> listFinalCandidatesDTO = new LinkedList<McCandidateAnswersDTO>();
        int queIndex = 0;
        for (McCandidateAnswersDTO mcCandidateAnswersDTO : listCandidates) {
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            logger.debug((Object)("mcCandidateAnswersDTO candidateAnswer:" + mcCandidateAnswersDTO.getCandidateAnswer()));
            McCandidateAnswersDTO tempNode = new McCandidateAnswersDTO();
            if (!new Integer(++queIndex).toString().equals(new Integer(intOriginalCandidateIndex).toString()) && !new Integer(queIndex).toString().equals(new Integer(replacedNodeIndex).toString())) {
                logger.debug((Object)"normal copy ");
                tempNode.setCandidateAnswer(mcCandidateAnswersDTO.getCandidateAnswer());
                tempNode.setCorrect(mcCandidateAnswersDTO.getCorrect());
            } else if (new Integer(queIndex).toString().equals(new Integer(intOriginalCandidateIndex).toString())) {
                logger.debug((Object)"move type 1 ");
                tempNode.setCandidateAnswer(replacedNode.getCandidateAnswer());
                tempNode.setCorrect(replacedNode.getCorrect());
            } else if (new Integer(queIndex).toString().equals(new Integer(replacedNodeIndex).toString())) {
                logger.debug((Object)"move type 2 ");
                tempNode.setCandidateAnswer(mainNode.getCandidateAnswer());
                tempNode.setCorrect(mainNode.getCorrect());
            }
            listFinalCandidatesDTO.add(tempNode);
        }
        logger.debug((Object)("final listFinalCandidatesDTO:" + listFinalCandidatesDTO));
        return listFinalCandidatesDTO;
    }

    protected static McQuestionContentDTO extractNodeAtDisplayOrder(List listQuestionContentDTO, int intOriginalQuestionIndex) {
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        logger.debug((Object)("intOriginalQuestionIndex:" + intOriginalQuestionIndex));
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            logger.debug((Object)("intOriginalQuestionIndex versus displayOrder:" + new Integer(intOriginalQuestionIndex).toString() + " versus " + mcQuestionContentDTO.getDisplayOrder()));
            if (!new Integer(intOriginalQuestionIndex).toString().equals(mcQuestionContentDTO.getDisplayOrder())) continue;
            logger.debug((Object)("node found:" + mcQuestionContentDTO));
            return mcQuestionContentDTO;
        }
        return null;
    }

    protected static McCandidateAnswersDTO extractCandidateAtOrder(List listCandidates, int intOriginalCandidateIndex) {
        logger.debug((Object)("listCandidates:" + listCandidates));
        logger.debug((Object)("intOriginalCandidateIndex:" + intOriginalCandidateIndex));
        int counter = 0;
        for (McCandidateAnswersDTO mcCandidateAnswerDTO : listCandidates) {
            logger.debug((Object)("mcCandidateAnswerDTO:" + mcCandidateAnswerDTO));
            logger.debug((Object)("counter:" + ++counter));
            if (!new Integer(intOriginalCandidateIndex).toString().equals(new Integer(counter).toString())) continue;
            logger.debug((Object)("node found:" + mcCandidateAnswerDTO));
            return mcCandidateAnswerDTO;
        }
        return null;
    }

    protected static String getTotalMark(List listQuestionContentDTO) {
        logger.debug((Object)("starting getTotalMark:" + listQuestionContentDTO));
        Map mapMarks = AuthoringUtil.extractMapMarks(listQuestionContentDTO);
        int intTotalMark = 0;
        for (Map.Entry pairs : mapMarks.entrySet()) {
            logger.debug((Object)("using the pair: " + pairs.getKey() + " = " + pairs.getValue()));
            String mark = (String)pairs.getValue();
            logger.debug((Object)("mark: " + mark));
            if (mark == null) continue;
            int intMark = new Integer(mark);
            logger.debug((Object)("current intTotalMark: " + (intTotalMark += intMark)));
        }
        logger.debug((Object)("final  intTotalMark: " + intTotalMark));
        String strFinalTotalMark = new Integer(intTotalMark).toString();
        logger.debug((Object)("final strFinalTotalMark: " + strFinalTotalMark));
        return strFinalTotalMark;
    }

    protected static Map extractMapQuestionContent(List listQuestionContentDTO) {
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        TreeMap<String, String> mapQuestionContent = new TreeMap<String, String>(new McComparator());
        Iterator listIterator = listQuestionContentDTO.iterator();
        int queIndex = 0;
        while (listIterator.hasNext()) {
            McQuestionContentDTO mcQuestionContentDTO = (McQuestionContentDTO)listIterator.next();
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            logger.debug((Object)("queIndex:" + ++queIndex));
            mapQuestionContent.put(new Integer(queIndex).toString(), mcQuestionContentDTO.getQuestion());
        }
        logger.debug((Object)("mapQuestionContent:" + mapQuestionContent));
        return mapQuestionContent;
    }

    protected static List reorderListCandidatesDTO(List candidates) {
        logger.debug((Object)"reorderListCandidatesDTO");
        logger.debug((Object)("reorderListCandidatesDTO:" + candidates));
        LinkedList<McCandidateAnswersDTO> listFinalCandidatesDTO = new LinkedList<McCandidateAnswersDTO>();
        boolean queIndex = false;
        for (McCandidateAnswersDTO mcCandidateAnswersDTO : candidates) {
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            logger.debug((Object)("mcCandidateAnswersDTO answer:" + mcCandidateAnswersDTO.getCandidateAnswer()));
            String answer = mcCandidateAnswersDTO.getCandidateAnswer();
            logger.debug((Object)("answer:" + answer));
            String correct = mcCandidateAnswersDTO.getCorrect();
            logger.debug((Object)("correct:" + correct));
            if (answer == null || answer.equals("")) continue;
            mcCandidateAnswersDTO.setCandidateAnswer(answer);
            mcCandidateAnswersDTO.setCorrect(correct);
            listFinalCandidatesDTO.add(mcCandidateAnswersDTO);
        }
        logger.debug((Object)("final listFinalCandidatesDTO:" + listFinalCandidatesDTO));
        return listFinalCandidatesDTO;
    }

    protected static List reorderListQuestionContentDTO(List listQuestionContentDTO, String excludeQuestionIndex) {
        logger.debug((Object)"reorderListQuestionContentDTO");
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        logger.debug((Object)("excludeQuestionIndex:" + excludeQuestionIndex));
        LinkedList<McQuestionContentDTO> listFinalQuestionContentDTO = new LinkedList<McQuestionContentDTO>();
        int queIndex = 0;
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            String question = mcQuestionContentDTO.getQuestion();
            logger.debug((Object)("question:" + question));
            String displayOrder = mcQuestionContentDTO.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            String feedback = mcQuestionContentDTO.getFeedback();
            logger.debug((Object)("feedback:" + feedback));
            String caCount = mcQuestionContentDTO.getCaCount();
            logger.debug((Object)("caCount:" + caCount));
            List caList = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("caList:" + caList));
            logger.debug((Object)("displayOrder versus excludeQuestionIndex :" + displayOrder + " versus " + excludeQuestionIndex));
            if (question == null || question.equals("") || displayOrder.equals(excludeQuestionIndex)) continue;
            logger.debug((Object)("using queIndex:" + ++queIndex));
            mcQuestionContentDTO.setQuestion(question);
            mcQuestionContentDTO.setDisplayOrder(new Integer(queIndex).toString());
            mcQuestionContentDTO.setFeedback(feedback);
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            logger.debug((Object)("caList size:" + mcQuestionContentDTO.getListCandidateAnswersDTO().size()));
            mcQuestionContentDTO.setCaCount(new Integer(mcQuestionContentDTO.getListCandidateAnswersDTO().size()).toString());
            listFinalQuestionContentDTO.add(mcQuestionContentDTO);
        }
        logger.debug((Object)("final listFinalQuestionContentDTO:" + listFinalQuestionContentDTO));
        return listFinalQuestionContentDTO;
    }

    protected static List reorderSimpleListQuestionContentDTO(List listQuestionContentDTO) {
        logger.debug((Object)"reorderListQuestionContentDTO");
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        LinkedList<McQuestionContentDTO> listFinalQuestionContentDTO = new LinkedList<McQuestionContentDTO>();
        int queIndex = 0;
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            String question = mcQuestionContentDTO.getQuestion();
            logger.debug((Object)("question:" + question));
            String displayOrder = mcQuestionContentDTO.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            String feedback = mcQuestionContentDTO.getFeedback();
            logger.debug((Object)("feedback:" + feedback));
            List caList = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("caList:" + caList));
            String caCount = mcQuestionContentDTO.getCaCount();
            logger.debug((Object)("caCount:" + caCount));
            String mark = mcQuestionContentDTO.getMark();
            logger.debug((Object)("mark:" + mark));
            if (question == null || question.equals("")) continue;
            logger.debug((Object)("using queIndex:" + ++queIndex));
            mcQuestionContentDTO.setQuestion(question);
            mcQuestionContentDTO.setDisplayOrder(new Integer(queIndex).toString());
            mcQuestionContentDTO.setFeedback(feedback);
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            mcQuestionContentDTO.setCaCount(caCount);
            mcQuestionContentDTO.setMark(mark);
            listFinalQuestionContentDTO.add(mcQuestionContentDTO);
        }
        logger.debug((Object)("final listFinalQuestionContentDTO:" + listFinalQuestionContentDTO));
        return listFinalQuestionContentDTO;
    }

    protected static List reorderUpdateListQuestionContentDTO(List listQuestionContentDTO, McQuestionContentDTO mcQuestionContentDTONew, String editableQuestionIndex) {
        logger.debug((Object)"reorderUpdateListQuestionContentDTO");
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        logger.debug((Object)("mcQuestionContentDTONew:" + mcQuestionContentDTONew));
        logger.debug((Object)("editableQuestionIndex:" + editableQuestionIndex));
        LinkedList<McQuestionContentDTO> listFinalQuestionContentDTO = new LinkedList<McQuestionContentDTO>();
        int queIndex = 0;
        for (McQuestionContentDTO mcQuestionContentDTO : listQuestionContentDTO) {
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO question:" + mcQuestionContentDTO.getQuestion()));
            logger.debug((Object)("using queIndex:" + ++queIndex));
            String question = mcQuestionContentDTO.getQuestion();
            logger.debug((Object)("question:" + question));
            String displayOrder = mcQuestionContentDTO.getDisplayOrder();
            logger.debug((Object)("displayOrder:" + displayOrder));
            String feedback = mcQuestionContentDTO.getFeedback();
            logger.debug((Object)("feedback:" + feedback));
            String mark = mcQuestionContentDTO.getMark();
            logger.debug((Object)("mark:" + mark));
            List caList = mcQuestionContentDTO.getListCandidateAnswersDTO();
            logger.debug((Object)("caList:" + caList));
            String caCount = mcQuestionContentDTO.getCaCount();
            logger.debug((Object)("caCount:" + caCount));
            if (displayOrder.equals(editableQuestionIndex)) {
                logger.debug((Object)("displayOrder equals editableQuestionIndex:" + editableQuestionIndex));
                mcQuestionContentDTO.setQuestion(mcQuestionContentDTONew.getQuestion());
                mcQuestionContentDTO.setDisplayOrder(mcQuestionContentDTONew.getDisplayOrder());
                mcQuestionContentDTO.setFeedback(mcQuestionContentDTONew.getFeedback());
                mcQuestionContentDTO.setMark(mcQuestionContentDTONew.getMark());
                mcQuestionContentDTO.setCaCount(mcQuestionContentDTONew.getCaCount());
                mcQuestionContentDTO.setListCandidateAnswersDTO(mcQuestionContentDTONew.getListCandidateAnswersDTO());
                listFinalQuestionContentDTO.add(mcQuestionContentDTO);
                continue;
            }
            logger.debug((Object)("displayOrder does not equal editableQuestionIndex:" + editableQuestionIndex));
            mcQuestionContentDTO.setQuestion(question);
            mcQuestionContentDTO.setDisplayOrder(displayOrder);
            mcQuestionContentDTO.setFeedback(feedback);
            mcQuestionContentDTO.setMark(mark);
            mcQuestionContentDTO.setCaCount(caCount);
            mcQuestionContentDTO.setListCandidateAnswersDTO(caList);
            listFinalQuestionContentDTO.add(mcQuestionContentDTO);
        }
        logger.debug((Object)("listFinalQuestionContentDTO:" + listFinalQuestionContentDTO));
        return listFinalQuestionContentDTO;
    }

    public void reOrganizeDisplayOrder(Map mapQuestionContent, IMcService mcService, McAuthoringForm mcAuthoringForm, McContent mcContent) {
        logger.debug((Object)("mcContent: " + mcContent));
        if (mcContent != null) {
            logger.debug((Object)("content uid: " + mcContent.getUid()));
            List sortedQuestions = mcService.getAllQuestionEntriesSorted(mcContent.getUid());
            logger.debug((Object)("sortedQuestions: " + sortedQuestions));
            Iterator listIterator = sortedQuestions.iterator();
            int displayOrder = 1;
            while (listIterator.hasNext()) {
                McQueContent queContent = (McQueContent)listIterator.next();
                logger.debug((Object)("queContent data: " + queContent));
                logger.debug((Object)("queContent: " + queContent.getQuestion() + " " + queContent.getDisplayOrder()));
                McQueContent existingMcQueContent = mcService.getQuestionContentByQuestionText(queContent.getQuestion(), mcContent.getUid());
                logger.debug((Object)("existingMcQueContent: " + existingMcQueContent));
                existingMcQueContent.setDisplayOrder(new Integer(displayOrder));
                logger.debug((Object)("updating the existing question content for displayOrder: " + existingMcQueContent));
                mcService.updateMcQueContent(existingMcQueContent);
                ++displayOrder;
            }
        }
        logger.debug((Object)"done with reOrganizeDisplayOrder...");
    }

    public static boolean checkDuplicateQuestions(List listQuestionContentDTO, String newQuestion) {
        logger.debug((Object)("checkDuplicateQuestions: " + listQuestionContentDTO));
        logger.debug((Object)("newQuestion: " + newQuestion));
        Map mapQuestionContent = AuthoringUtil.extractMapQuestionContent(listQuestionContentDTO);
        logger.debug((Object)("mapQuestionContent: " + mapQuestionContent));
        for (Map.Entry pairs : mapQuestionContent.entrySet()) {
            if (pairs.getValue() == null || pairs.getValue().equals("")) continue;
            logger.debug((Object)("checking the  pair: " + pairs.getKey() + " = " + pairs.getValue()));
            if (!pairs.getValue().equals(newQuestion)) continue;
            logger.debug((Object)("entry found: " + newQuestion));
            return true;
        }
        return false;
    }

    public void removeRedundantQuestions(Map mapQuestionContent, IMcService mcService, McAuthoringForm mcAuthoringForm, HttpServletRequest request, String toolContentID) {
        logger.debug((Object)"removing unused entries... ");
        logger.debug((Object)("mapQuestionContent:  " + mapQuestionContent));
        logger.debug((Object)("toolContentID:  " + toolContentID));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("mcContent:  " + mcContent));
        if (mcContent != null) {
            logger.debug((Object)("mcContent uid: " + mcContent.getUid()));
            List allQuestions = mcService.getAllQuestionEntries(mcContent.getUid());
            logger.debug((Object)("allQuestions: " + allQuestions));
            Iterator listIterator = allQuestions.iterator();
            int mapIndex = 0;
            boolean entryUsed = false;
            while (listIterator.hasNext()) {
                logger.debug((Object)("current mapIndex: " + ++mapIndex));
                McQueContent queContent = (McQueContent)listIterator.next();
                logger.debug((Object)("queContent data: " + queContent));
                logger.debug((Object)("queContent: " + queContent.getQuestion() + " " + queContent.getDisplayOrder()));
                entryUsed = false;
                Iterator itMap = mapQuestionContent.entrySet().iterator();
                int displayOrder = 0;
                while (itMap.hasNext()) {
                    logger.debug((Object)("current displayOrder: " + ++displayOrder));
                    entryUsed = false;
                    Map.Entry pairs = itMap.next();
                    logger.debug((Object)("using the pair: " + pairs.getKey() + " = " + pairs.getValue()));
                    if (pairs.getValue().toString().length() == 0) continue;
                    logger.debug((Object)("text from map:" + pairs.getValue().toString()));
                    logger.debug((Object)("text from db:" + queContent.getQuestion()));
                    logger.debug((Object)("mapIndex versus displayOrder:" + mapIndex + " versus " + displayOrder));
                    if (mapIndex != displayOrder) continue;
                    logger.debug((Object)("used displayOrder position:" + displayOrder));
                    entryUsed = true;
                    break;
                }
                if (entryUsed) continue;
                logger.debug((Object)("removing unused entry in db:" + queContent.getQuestion()));
                McQueContent removeableMcQueContent = mcService.getQuestionContentByQuestionText(queContent.getQuestion(), mcContent.getUid());
                logger.debug((Object)("removeableMcQueContent" + removeableMcQueContent));
                if (removeableMcQueContent == null) continue;
                mcService.removeMcQueContent(removeableMcQueContent);
                logger.debug((Object)("removed removeableMcQueContent from the db: " + removeableMcQueContent));
            }
        }
    }

    protected static Map extractMapFeedback(List listQuestionContentDTO) {
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        TreeMap<String, String> mapFeedbackContent = new TreeMap<String, String>(new McComparator());
        Iterator listIterator = listQuestionContentDTO.iterator();
        int queIndex = 0;
        while (listIterator.hasNext()) {
            McQuestionContentDTO mcQuestionContentDTO = (McQuestionContentDTO)listIterator.next();
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO feedback:" + mcQuestionContentDTO.getFeedback()));
            logger.debug((Object)("queIndex:" + ++queIndex));
            mapFeedbackContent.put(new Integer(queIndex).toString(), mcQuestionContentDTO.getFeedback());
        }
        logger.debug((Object)("mapFeedbackContent:" + mapFeedbackContent));
        return mapFeedbackContent;
    }

    protected static Map extractMapWeights(List listQuestionContentDTO) {
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        TreeMap<String, String> mapWeights = new TreeMap<String, String>(new McComparator());
        Iterator listIterator = listQuestionContentDTO.iterator();
        int queIndex = 0;
        while (listIterator.hasNext()) {
            McQuestionContentDTO mcQuestionContentDTO = (McQuestionContentDTO)listIterator.next();
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO weight:" + mcQuestionContentDTO.getWeight()));
            logger.debug((Object)("queIndex:" + ++queIndex));
            mapWeights.put(new Integer(queIndex).toString(), mcQuestionContentDTO.getWeight());
        }
        logger.debug((Object)("mapWeights:" + mapWeights));
        return mapWeights;
    }

    protected static Map extractMapMarks(List listQuestionContentDTO) {
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        TreeMap<String, String> mapMarks = new TreeMap<String, String>(new McComparator());
        Iterator listIterator = listQuestionContentDTO.iterator();
        int queIndex = 0;
        while (listIterator.hasNext()) {
            McQuestionContentDTO mcQuestionContentDTO = (McQuestionContentDTO)listIterator.next();
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO weight:" + mcQuestionContentDTO.getMark()));
            logger.debug((Object)("queIndex:" + ++queIndex));
            mapMarks.put(new Integer(queIndex).toString(), mcQuestionContentDTO.getMark());
        }
        logger.debug((Object)("mapMarks:" + mapMarks));
        return mapMarks;
    }

    protected static Map extractMapCandidatesList(List listQuestionContentDTO) {
        logger.debug((Object)("listQuestionContentDTO:" + listQuestionContentDTO));
        TreeMap<String, List> mapCandidatesList = new TreeMap<String, List>(new McComparator());
        Iterator listIterator = listQuestionContentDTO.iterator();
        int queIndex = 0;
        while (listIterator.hasNext()) {
            McQuestionContentDTO mcQuestionContentDTO = (McQuestionContentDTO)listIterator.next();
            logger.debug((Object)("mcQuestionContentDTO:" + mcQuestionContentDTO));
            logger.debug((Object)("mcQuestionContentDTO candidates list:" + mcQuestionContentDTO.getListCandidateAnswersDTO()));
            logger.debug((Object)("queIndex:" + ++queIndex));
            mapCandidatesList.put(new Integer(queIndex).toString(), mcQuestionContentDTO.getListCandidateAnswersDTO());
        }
        logger.debug((Object)("mapCandidatesList:" + mapCandidatesList));
        return mapCandidatesList;
    }

    public McContent saveOrUpdateMcContent(Map mapQuestionContent, Map mapFeedback, Map mapWeights, Map mapMarks, Map mapCandidatesList, IMcService mcService, McAuthoringForm mcAuthoringForm, HttpServletRequest request, McContent mcContent, String strToolContentID) {
        logger.debug((Object)("doing saveOrUpdateMcContent, mapCandidatesList: " + mapCandidatesList));
        UserDTO toolUser = (UserDTO)SessionManager.getSession().getAttribute("user");
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        logger.debug((Object)("richTextTitle: " + richTextTitle));
        logger.debug((Object)("richTextInstructions: " + richTextInstructions));
        String sln = request.getParameter("sln");
        logger.debug((Object)("sln: " + sln));
        String questionsSequenced = request.getParameter("questionsSequenced");
        logger.debug((Object)("questionsSequenced: " + questionsSequenced));
        String randomize = request.getParameter("randomize");
        logger.debug((Object)("randomize: " + randomize));
        String showMarks = request.getParameter("showMarks");
        logger.debug((Object)("showMarks: " + showMarks));
        String retries = request.getParameter("retries");
        logger.debug((Object)("retries: " + retries));
        String reflect = request.getParameter("reflect");
        logger.debug((Object)("reflect: " + reflect));
        String richTextOfflineInstructions = request.getParameter("offlineInstructions");
        String richTextOnlineInstructions = request.getParameter("onlineInstructions");
        String reflectionSubject = request.getParameter("reflectionSubject");
        logger.debug((Object)("reflectionSubject: " + reflectionSubject));
        String activeModule = request.getParameter("activeModule");
        logger.debug((Object)("activeModule: " + activeModule));
        boolean setCommonContent = true;
        if (sln == null || questionsSequenced == null || retries == null || reflect == null || showMarks == null || randomize == null) {
            setCommonContent = false;
        }
        logger.debug((Object)("setCommonContent: " + setCommonContent));
        boolean questionsSequencedBoolean = false;
        boolean randomizeBoolean = false;
        boolean showMarksBoolean = false;
        boolean slnBoolean = false;
        boolean retriesBoolean = false;
        boolean reflectBoolean = false;
        if (questionsSequenced != null && questionsSequenced.equalsIgnoreCase("1")) {
            questionsSequencedBoolean = true;
        }
        if (randomize != null && randomize.equalsIgnoreCase("1")) {
            randomizeBoolean = true;
        }
        if (showMarks != null && showMarks.equalsIgnoreCase("1")) {
            showMarksBoolean = true;
        }
        if (sln != null && sln.equalsIgnoreCase("1")) {
            slnBoolean = true;
        }
        if (retries != null && retries.equalsIgnoreCase("1")) {
            retriesBoolean = true;
        }
        if (reflect != null && reflect.equalsIgnoreCase("1")) {
            reflectBoolean = true;
        }
        logger.debug((Object)("questionsSequencedBoolean: " + questionsSequencedBoolean));
        logger.debug((Object)("slnBoolean: " + slnBoolean));
        logger.debug((Object)("retriesBoolean: " + retriesBoolean));
        logger.debug((Object)("reflectBoolean: " + reflectBoolean));
        long userId = 0L;
        if (toolUser != null) {
            userId = toolUser.getUserID().longValue();
        } else {
            HttpSession ss = SessionManager.getSession();
            logger.debug((Object)("ss: " + ss));
            UserDTO user = (UserDTO)ss.getAttribute("user");
            logger.debug((Object)("user" + user));
            if (user != null) {
                userId = user.getUserID().longValue();
            } else {
                logger.debug((Object)"should not reach here");
                userId = 0L;
            }
        }
        logger.debug((Object)("userId: " + userId));
        logger.debug((Object)("mcContent: " + mcContent));
        boolean newContent = false;
        if (mcContent == null) {
            mcContent = new McContent();
            newContent = true;
        }
        logger.debug((Object)("setting common content values..." + richTextTitle + " " + richTextInstructions));
        mcContent.setMcContentId(new Long(strToolContentID));
        mcContent.setTitle(richTextTitle);
        mcContent.setInstructions(richTextInstructions);
        mcContent.setUpdateDate(new Date(System.currentTimeMillis()));
        logger.debug((Object)("userId: " + userId));
        mcContent.setCreatedBy(userId);
        logger.debug((Object)"end of setting common content values...");
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        if (passmark == null) {
            passmark = "0";
        }
        if (passmark != null && passmark.equals(" ")) {
            passmark = "0";
        } else if (passmark != null && passmark.length() == 0) {
            passmark = "0";
        }
        logger.debug((Object)("activeModule:" + activeModule));
        if (activeModule.equals("authoring")) {
            logger.debug((Object)"setting other content values...");
            mcContent.setOnlineInstructions(richTextOnlineInstructions);
            mcContent.setOfflineInstructions(richTextOfflineInstructions);
            mcContent.setQuestionsSequenced(questionsSequencedBoolean);
            mcContent.setRandomize(randomizeBoolean);
            mcContent.setShowMarks(showMarksBoolean);
            mcContent.setRetries(retriesBoolean);
            mcContent.setShowReport(slnBoolean);
            mcContent.setReflect(reflectBoolean);
            mcContent.setReflectionSubject(reflectionSubject);
            logger.debug((Object)"setting passmark...");
            mcContent.setPassMark(new Integer(passmark));
        }
        if (newContent) {
            logger.debug((Object)("will create: " + mcContent));
            mcService.createMc(mcContent);
        } else {
            logger.debug((Object)("will update: " + mcContent));
            mcService.updateMc(mcContent);
        }
        mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent: " + mcContent));
        mcContent = this.createQuestionContent(mapQuestionContent, mapFeedback, mapWeights, mapMarks, mapCandidatesList, mcService, mcContent);
        return mcContent;
    }

    protected McContent createQuestionContent(Map mapQuestionContent, Map mapFeedback, Map mapWeights, Map mapMarks, Map mapCandidatesList, IMcService mcService, McContent mcContent) {
        logger.debug((Object)("createQuestionContent, mapCandidatesList: " + mapCandidatesList));
        logger.debug((Object)("content uid is: " + mcContent.getUid()));
        List questions = mcService.retrieveMcQueContentsByToolContentId(mcContent.getUid());
        logger.debug((Object)("questions: " + questions));
        logger.debug((Object)("mapQuestionContent: " + mapQuestionContent));
        logger.debug((Object)("mapFeedback: " + mapFeedback));
        logger.debug((Object)("mapMarks: " + mapMarks));
        Iterator itMap = mapQuestionContent.entrySet().iterator();
        int displayOrder = 0;
        while (itMap.hasNext()) {
            Map.Entry pairs = itMap.next();
            logger.debug((Object)("using the pair: " + pairs.getKey() + " = " + pairs.getValue()));
            if (pairs.getValue().toString().length() == 0) continue;
            logger.debug((Object)("starting createQuestionContent: pairs.getValue().toString():" + pairs.getValue().toString()));
            logger.debug((Object)("starting createQuestionContent: mcContent: " + mcContent));
            logger.debug((Object)("starting createQuestionContent: displayOrder: " + ++displayOrder));
            String currentFeedback = (String)mapFeedback.get(new Integer(displayOrder).toString());
            logger.debug((Object)("currentFeedback: " + currentFeedback));
            String currentMark = (String)mapMarks.get(new Integer(displayOrder).toString());
            logger.debug((Object)("currentMark: " + currentMark));
            if (currentMark == null) {
                currentMark = "1";
            }
            List caList = (List)mapCandidatesList.get(new Integer(displayOrder).toString());
            logger.debug((Object)("caList: " + caList));
            McQueContent queContent = new McQueContent(pairs.getValue().toString(), new Integer(displayOrder), new Integer(currentMark), currentFeedback, mcContent, null, null);
            logger.debug((Object)("queContent: " + queContent));
            logger.debug((Object)("question text is: " + pairs.getValue().toString()));
            logger.debug((Object)("content uid is: " + mcContent.getUid()));
            logger.debug((Object)("question display order is: " + displayOrder));
            McQueContent existingMcQueContent = mcService.getQuestionContentByDisplayOrder(new Long(displayOrder), mcContent.getUid());
            logger.debug((Object)("existingMcQueContent: " + existingMcQueContent));
            if (existingMcQueContent == null) {
                McQueContent duplicateMcQueContent = mcService.getQuestionContentByQuestionText(pairs.getValue().toString(), mcContent.getUid());
                logger.debug((Object)("duplicateMcQueContent: " + duplicateMcQueContent));
                logger.debug((Object)("adding a new question to content: " + queContent));
                mcContent.getMcQueContents().add(queContent);
                queContent.setMcContent(mcContent);
                mcService.createMcQue(queContent);
                logger.debug((Object)("start persisting candidate answers: " + queContent));
                this.persistCandidates(caList, queContent, mcService);
                continue;
            }
            String existingQuestion = existingMcQueContent.getQuestion();
            logger.debug((Object)("existingQuestion: " + existingQuestion));
            logger.debug((Object)("map question versus existingQuestion: " + pairs.getValue().toString() + " versus db question value: " + existingQuestion));
            existingMcQueContent.setQuestion(pairs.getValue().toString());
            existingMcQueContent.setFeedback(currentFeedback);
            existingMcQueContent.setDisplayOrder(new Integer(displayOrder));
            existingMcQueContent.setMark(new Integer(currentMark));
            logger.debug((Object)("updating the existing question content: " + existingMcQueContent));
            mcService.updateMcQueContent(existingMcQueContent);
            logger.debug((Object)("questionUid " + existingMcQueContent.getUid()));
            logger.debug((Object)("will be removing redundant candidates, questionUid: " + existingMcQueContent.getUid()));
            mcService.removeMcOptionsContentByQueId(existingMcQueContent.getUid());
            logger.debug((Object)("start persisting candidates " + existingMcQueContent.getUid()));
            this.persistCandidates(caList, existingMcQueContent, mcService);
        }
        return mcContent;
    }

    protected Map buildDynamicPassMarkMap(List listQuestionContentDTO, boolean initialScreen) {
        logger.debug((Object)("starting buildDynamicPassMarkMap: " + listQuestionContentDTO));
        logger.debug((Object)("initialScreen: " + initialScreen));
        TreeMap map = new TreeMap(new McComparator());
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTO);
        logger.debug((Object)("totalMark: " + totalMark));
        int intTotalMark = 0;
        if (totalMark != null && totalMark.length() > 0) {
            intTotalMark = new Integer(totalMark);
        }
        logger.debug((Object)("intTotalMark: " + intTotalMark));
        Map passMarksMap = this.buildPassMarkMap(intTotalMark, false);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        return passMarksMap;
    }

    protected Map buildPassMarkMap(int intTotalMark, boolean initialScreen) {
        logger.debug((Object)("building buildMarksMap: " + intTotalMark));
        logger.debug((Object)("initialScreen: " + initialScreen));
        TreeMap<String, String> map = new TreeMap<String, String>(new McComparator());
        if (initialScreen) {
            return map;
        }
        for (int i = 1; i <= intTotalMark; ++i) {
            map.put(new Integer(i).toString(), new Integer(i).toString());
        }
        logger.debug((Object)("return passmarks Map: " + map));
        return map;
    }

    protected Map buildMarksMap() {
        TreeMap<String, String> map = new TreeMap<String, String>(new McComparator());
        for (int i = 1; i <= 10; ++i) {
            map.put(new Integer(i).toString(), new Integer(i).toString());
        }
        logger.debug((Object)("return marks Map: " + map));
        return map;
    }

    protected Map buildCorrectMap() {
        TreeMap<String, String> map = new TreeMap<String, String>(new McComparator());
        map.put(new Integer(2).toString(), "Correct");
        logger.debug((Object)("return marks Map: " + map));
        return map;
    }

    protected List repopulateCandidateAnswersBox(HttpServletRequest request, boolean addBlankCa) {
        logger.debug((Object)("doing repopulateCandidateAnswersBox, addBlankCa: " + addBlankCa));
        String correct = request.getParameter("correct");
        logger.debug((Object)("correct: " + correct));
        int intCorrect = 0;
        if (correct == null) {
            logger.debug((Object)"correct is null: ");
        } else {
            intCorrect = new Integer(correct);
        }
        logger.debug((Object)("intCorrect: " + intCorrect));
        LinkedList<McCandidateAnswersDTO> listFinalCandidatesDTO = new LinkedList<McCandidateAnswersDTO>();
        for (int i = 0; i < 25; ++i) {
            String candidate = request.getParameter("ca" + i);
            logger.debug((Object)("candidate: " + candidate));
            String isCorrect = "Incorrect";
            logger.debug((Object)("i versus intCorrect: " + i + " versus " + intCorrect));
            if (i == intCorrect) {
                isCorrect = "Correct";
            }
            logger.debug((Object)("isCorrect: " + isCorrect));
            if (candidate == null) continue;
            McCandidateAnswersDTO mcCandidateAnswersDTO = new McCandidateAnswersDTO();
            mcCandidateAnswersDTO.setCandidateAnswer(candidate);
            mcCandidateAnswersDTO.setCorrect(isCorrect);
            listFinalCandidatesDTO.add(mcCandidateAnswersDTO);
        }
        if (addBlankCa) {
            McCandidateAnswersDTO mcCandidateAnswersDTO = new McCandidateAnswersDTO();
            mcCandidateAnswersDTO.setCandidateAnswer("");
            mcCandidateAnswersDTO.setCorrect("Incorrect");
            listFinalCandidatesDTO.add(mcCandidateAnswersDTO);
        }
        logger.debug((Object)("returning listFinalCandidatesDTO: " + listFinalCandidatesDTO));
        return listFinalCandidatesDTO;
    }

    protected boolean validateCandidateAnswersNotBlank(HttpServletRequest request) {
        for (int i = 0; i < 25; ++i) {
            String candidate = request.getParameter("ca" + i);
            logger.debug((Object)("candidate: " + candidate));
            if (candidate == null || candidate.length() != 0) continue;
            logger.debug((Object)"there is at least 1 blank candidate");
            return false;
        }
        return true;
    }

    protected List repopulateCandidateAnswersRadioBox(HttpServletRequest request, boolean addBlankCa) {
        logger.debug((Object)("doing repopulateCandidateAnswersRadioBox, addBlankCa: " + addBlankCa));
        String correct = request.getParameter("correct");
        logger.debug((Object)("correct: " + correct));
        LinkedList listFinalCandidatesDTO = new LinkedList();
        logger.debug((Object)("returning listFinalCandidatesDTO: " + listFinalCandidatesDTO));
        return listFinalCandidatesDTO;
    }

    protected boolean validateSingleCorrectCandidate(List caList) {
        for (McCandidateAnswersDTO mcCandidateAnswersDTO : caList) {
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            String candidateAnswer = mcCandidateAnswersDTO.getCandidateAnswer();
            String correct = mcCandidateAnswersDTO.getCorrect();
            logger.debug((Object)("correct:" + correct));
            if (!correct.equals("Correct")) continue;
            logger.debug((Object)"there is at least one Correct candidate, it is good.");
            return true;
        }
        return false;
    }

    protected boolean validateOnlyOneCorrectCandidate(List caList) {
        int correctCandidatesCount = 0;
        for (McCandidateAnswersDTO mcCandidateAnswersDTO : caList) {
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            String candidateAnswer = mcCandidateAnswersDTO.getCandidateAnswer();
            String correct = mcCandidateAnswersDTO.getCorrect();
            logger.debug((Object)("correct:" + correct));
            if (!correct.equals("Correct")) continue;
            logger.debug((Object)"there is at leat one Correct candidate, it is good.");
            ++correctCandidatesCount;
        }
        logger.debug((Object)("correctCandidatesCount: " + correctCandidatesCount));
        return correctCandidatesCount <= 1;
    }

    protected List buildDefaultQuestionContent(McContent mcContent, IMcService mcService) {
        logger.debug((Object)("starting buildDefaultQuestionContent, mcContent: " + mcContent));
        LinkedList<McQuestionContentDTO> listQuestionContentDTO = new LinkedList<McQuestionContentDTO>();
        logger.debug((Object)"setting content data from the db");
        Iterator queIterator = mcContent.getMcQueContents().iterator();
        Long mapIndex = new Long(1L);
        while (queIterator.hasNext()) {
            McQuestionContentDTO mcQuestionContentDTO = new McQuestionContentDTO();
            McQueContent mcQueContent = (McQueContent)queIterator.next();
            if (mcQueContent == null) continue;
            logger.debug((Object)("question: " + mcQueContent.getQuestion()));
            logger.debug((Object)("displayorder: " + mcQueContent.getDisplayOrder().toString()));
            logger.debug((Object)("mark: " + mcQueContent.getMark().toString()));
            logger.debug((Object)("feedback: " + mcQueContent.getFeedback()));
            String feedback = "";
            if (mcQueContent.getFeedback() != null) {
                feedback = mcQueContent.getFeedback();
            }
            logger.debug((Object)("feedback now: " + mcQueContent.getFeedback()));
            String question = mcQueContent.getQuestion();
            logger.debug((Object)("question: " + question));
            mcQuestionContentDTO.setQuestion(question);
            mcQuestionContentDTO.setDisplayOrder(mcQueContent.getDisplayOrder().toString());
            mcQuestionContentDTO.setFeedback(feedback);
            mcQuestionContentDTO.setMark(mcQueContent.getMark().toString());
            List list = mcService.findMcOptionsContentByQueId(mcQueContent.getUid());
            logger.debug((Object)("candidiate answers list for mapQuestionContent:" + list));
            int caCount = list.size();
            logger.debug((Object)("caCount:" + caCount));
            mcQuestionContentDTO.setCaCount(new Integer(caCount).toString());
            LinkedList<McCandidateAnswersDTO> listCandidates = new LinkedList<McCandidateAnswersDTO>();
            for (McOptsContent mcOptsContent : list) {
                McCandidateAnswersDTO mcCandidateAnswersDTO = new McCandidateAnswersDTO();
                logger.debug((Object)("mcOptsContent:" + mcOptsContent));
                logger.debug((Object)("option text:" + mcOptsContent.getMcQueOptionText()));
                logger.debug((Object)("option text:" + mcOptsContent.isCorrectOption()));
                mcCandidateAnswersDTO.setCandidateAnswer(mcOptsContent.getMcQueOptionText());
                if (mcOptsContent.isCorrectOption()) {
                    logger.debug((Object)"mcOptsContent.getMcQueOptionText() is set to true");
                    mcCandidateAnswersDTO.setCorrect("Correct");
                } else {
                    logger.debug((Object)"mcOptsContent.getMcQueOptionText() is set to true");
                    mcCandidateAnswersDTO.setCorrect("Incorrect");
                }
                logger.debug((Object)("current mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
                listCandidates.add(mcCandidateAnswersDTO);
                logger.debug((Object)("current listCandidates:" + listCandidates));
            }
            logger.debug((Object)("final listCandidates for mcQueContent:" + listCandidates));
            mcQuestionContentDTO.setListCandidateAnswersDTO(listCandidates);
            logger.debug((Object)("current mcQuestionContentDTO:" + mcQuestionContentDTO));
            listQuestionContentDTO.add(mcQuestionContentDTO);
            logger.debug((Object)("current listQuestionContentDTO:" + listQuestionContentDTO));
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("final listQuestionContentDTO:" + listQuestionContentDTO));
        return listQuestionContentDTO;
    }

    protected void persistCandidates(List caList, McQueContent mcQueContent, IMcService mcService) {
        logger.debug((Object)("doing persistCandidates:" + caList));
        logger.debug((Object)("mcQueContent:" + mcQueContent));
        int displayOrder = 0;
        for (McCandidateAnswersDTO mcCandidateAnswersDTO : caList) {
            logger.debug((Object)("mcCandidateAnswersDTO:" + mcCandidateAnswersDTO));
            String candidateAnswer = mcCandidateAnswersDTO.getCandidateAnswer();
            String correct = mcCandidateAnswersDTO.getCorrect();
            boolean correctOption = false;
            correctOption = correct.equals("Correct");
            logger.debug((Object)("displayOrder:" + ++displayOrder));
            McOptsContent mcOptsContent = new McOptsContent(new Integer(displayOrder), correctOption, candidateAnswer, mcQueContent, new TreeSet());
            logger.debug((Object)("mcOptsContent: " + mcOptsContent));
            mcService.saveMcOptionsContent(mcOptsContent);
            logger.debug((Object)("persisted mcOptsContent: " + mcOptsContent));
        }
    }
}

