/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McApplicationException;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.mc.McLearnerStarterDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McQueUsr;
import org.lamsfoundation.lams.tool.mc.pojos.McSession;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.web.LearningUtil;
import org.lamsfoundation.lams.tool.mc.web.McLearningAction;
import org.lamsfoundation.lams.tool.mc.web.McLearningForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class McLearningStarterAction
extends Action
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McLearningStarterAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, McApplicationException {
        UserDTO user;
        McUtils.cleanUpSessionAbsolute(request);
        TreeMap mapQuestionsContent = new TreeMap(new McComparator());
        TreeMap mapAnswers = new TreeMap(new McComparator());
        IMcService mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        logger.debug((Object)("retrieving mcService from proxy: " + mcService));
        McLearningForm mcLearningForm = (McLearningForm)form;
        mcLearningForm.setMcService(mcService);
        mcLearningForm.setPassMarkApplicable(new Boolean(false).toString());
        mcLearningForm.setUserOverPassMark(new Boolean(false).toString());
        ActionForward validateParameters = this.validateParameters(request, mcLearningForm, mapping);
        logger.debug((Object)("validateParameters: " + validateParameters));
        if (validateParameters != null) {
            return validateParameters;
        }
        SessionMap sessionMap = new SessionMap();
        LinkedList sequentialCheckedCa = new LinkedList();
        sessionMap.put((Object)"questionAndCandidateAnswersKey", sequentialCheckedCa);
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        mcLearningForm.setHttpSessionID(sessionMap.getSessionID());
        String toolSessionID = request.getParameter("toolSessionID");
        logger.debug((Object)("retrieved toolSessionID: " + toolSessionID));
        mcLearningForm.setToolSessionID(new Long(toolSessionID).toString());
        McSession mcSession = mcService.retrieveMcSession(new Long(toolSessionID));
        logger.debug((Object)("retrieving mcSession: " + mcSession));
        if (mcSession == null) {
            McUtils.cleanUpSessionAbsolute(request);
            logger.debug((Object)"error: The tool expects mcSession.");
            return mapping.findForward("errorList");
        }
        McContent mcContent = mcSession.getMcContent();
        logger.debug((Object)("using mcContent: " + mcContent));
        if (mcContent == null) {
            McUtils.cleanUpSessionAbsolute(request);
            logger.debug((Object)"error: The tool expects mcContent.");
            this.persistError(request, "error.content.doesNotExist");
            return mapping.findForward("errorList");
        }
        McLearnerStarterDTO mcLearnerStarterDTO = new McLearnerStarterDTO();
        logger.debug((Object)("IS_QUESTIONS_SEQUENCED: " + mcContent.isQuestionsSequenced()));
        if (mcContent.isQuestionsSequenced()) {
            mcLearnerStarterDTO.setQuestionListingMode("questionListingModeSequential");
            mcLearningForm.setQuestionListingMode("questionListingModeSequential");
        } else {
            mcLearnerStarterDTO.setQuestionListingMode("questionListingModeCombined");
            mcLearningForm.setQuestionListingMode("questionListingModeCombined");
        }
        logger.debug((Object)("IS_TOOL_ACTIVITY_OFFLINE: " + mcContent.isRunOffline()));
        mcLearnerStarterDTO.setToolActivityOffline(new Boolean(mcContent.isRunOffline()).toString());
        mcLearnerStarterDTO.setActivityTitle(mcContent.getTitle());
        request.setAttribute("mcLearnerStarterDTO", (Object)mcLearnerStarterDTO);
        mcLearningForm.setToolContentID(mcContent.getMcContentId().toString());
        this.commonContentSetup(request, mcContent, mcService, mcLearningForm, toolSessionID);
        String mode = request.getParameter("mode");
        logger.debug((Object)("mode: " + mode));
        if (mode != null && mode.equals("author")) {
            logger.debug((Object)"Author requests for a preview of the content.");
        }
        String userId = request.getParameter("userID");
        logger.debug((Object)("userId: " + userId));
        if (userId != null && mode.equals("teacher")) {
            logger.debug((Object)"request is for learner progress");
            mcLearningForm.setLearnerProgress(new Boolean(true).toString());
            mcLearningForm.setLearnerProgressUserId(userId);
            McLearningAction mcLearningAction = new McLearningAction();
            McQueUsr mcQueUsr = mcService.getMcUserBySession(new Long(userId), mcSession.getUid());
            logger.debug((Object)("mcQueUsr: " + mcQueUsr));
            if (mcQueUsr == null) {
                logger.error((Object)"error.learner.required");
                this.persistError(request, "error.learner.required");
                logger.error((Object)"forwarding to: simpleLearningError");
                return mapping.findForward("simpleLearningError");
            }
            Long sessionUid = mcQueUsr.getMcSessionId();
            logger.debug((Object)("sessionUid: " + sessionUid));
            McSession mcSessionLocal = mcService.getMcSessionByUID(sessionUid);
            logger.debug((Object)("checking mcSessionLocal" + mcSessionLocal));
            toolSessionID = mcLearningForm.getToolSessionID();
            logger.debug((Object)("toolSessionID: " + toolSessionID + " versus" + mcSessionLocal));
            if (mcSessionLocal == null || mcSessionLocal.getMcSessionId().longValue() != new Long(toolSessionID).longValue()) {
                logger.error((Object)"error.learner.sessionId.inconsistent");
            }
            LearningUtil.saveFormRequestData(request, mcLearningForm, true);
            logger.debug((Object)("learnerProgress before presenting learner Progress screen: " + mcLearningForm.getLearnerProgress()));
            request.setAttribute("requestByStarter", (Object)new Boolean(true).toString());
            return mcLearningAction.viewAnswers(mapping, mcLearningForm, request, response);
        }
        boolean isRunOffline = McUtils.isRunOffline(mcContent);
        logger.debug((Object)("isRunOffline: " + isRunOffline));
        if (isRunOffline) {
            logger.debug((Object)"the activity is offline.");
            logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
            logger.debug((Object)"fwding to :runOffline");
            return mapping.findForward("runOffline");
        }
        boolean isDefineLater = McUtils.isDefineLater(mcContent);
        logger.debug((Object)("isDefineLater: " + isDefineLater));
        if (isDefineLater) {
            logger.debug((Object)"fwding to :defineLater");
            return mapping.findForward("defineLater");
        }
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        McQueUsr mcQueUsr = mcService.getMcUserBySession(new Long(userID), mcSession.getUid());
        logger.debug((Object)("mcQueUsr:" + mcQueUsr));
        if (mcQueUsr != null) {
            logger.debug((Object)("mcQueUsr is available in the db:" + mcQueUsr));
            Long queUsrId = mcQueUsr.getUid();
            logger.debug((Object)("queUsrId: " + queUsrId));
            int highestAttemptOrder = LearningUtil.getHighestAttemptOrder(request, queUsrId, mcService);
            logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
            if (highestAttemptOrder == 0) {
                highestAttemptOrder = 1;
            }
            logger.debug((Object)("highestAttemptOrder: " + highestAttemptOrder));
            int learnerBestMark = LearningUtil.getHighestMark(request, queUsrId, mcService);
            logger.debug((Object)("learnerBestMark: " + learnerBestMark));
        } else {
            logger.debug((Object)("mcQueUsr is not available in the db:" + mcQueUsr));
        }
        logger.debug((Object)("users learning mode is: " + mode));
        request.setAttribute("mcLearnerStarterDTO", (Object)mcLearnerStarterDTO);
        boolean viewSummaryRequested = false;
        if (mcQueUsr != null) {
            viewSummaryRequested = mcQueUsr.isViewSummaryRequested();
            logger.debug((Object)("viewSummaryRequested: " + viewSummaryRequested));
            Long sessionUid = mcQueUsr.getMcSessionId();
            logger.debug((Object)("users sessionUid: " + sessionUid));
            McSession mcUserSession = mcService.getMcSessionByUID(sessionUid);
            logger.debug((Object)("mcUserSession: " + mcUserSession));
            String userSessionId = mcUserSession.getMcSessionId().toString();
            logger.debug((Object)("userSessionId: " + userSessionId));
            logger.debug((Object)("current toolSessionID: " + toolSessionID));
            if (toolSessionID.equals(userSessionId)) {
                logger.debug((Object)("the user's session id AND user id exists in the tool tables go to redo questions. " + toolSessionID + " mcQueUsr: " + mcQueUsr + " user id: " + mcQueUsr.getQueUsrId()));
                logger.debug((Object)"the learner has already responsed to this content, just generate a read-only report. Use redo questions for this.");
                boolean isRetries = mcContent.isRetries();
                logger.debug((Object)("isRetries: " + isRetries));
                McLearningAction mcLearningAction = new McLearningAction();
                logger.debug((Object)"present to learner with previous attempts data");
                String sessionStatus = mcUserSession.getSessionStatus();
                logger.debug((Object)("sessionStatus: " + sessionStatus));
                boolean isResponseFinalised = mcQueUsr.isResponseFinalised();
                logger.debug((Object)("isResponseFinalised: " + isResponseFinalised));
                if (isResponseFinalised) {
                    mcLearningForm.setReportViewOnly(new Boolean(true).toString());
                } else {
                    mcLearningForm.setReportViewOnly(new Boolean(false).toString());
                }
                request.setAttribute("requestByStarter", (Object)new Boolean(true).toString());
                return mcLearningAction.viewAnswers(mapping, mcLearningForm, request, response);
            }
        } else if (mode.equals("teacher")) {
            McLearningAction mcLearningAction = new McLearningAction();
            logger.debug((Object)"present to teacher learners progress...");
            mcLearningForm.setLearnerProgress(new Boolean(true).toString());
            mcLearningForm.setLearnerProgressUserId(userId);
            return mcLearningAction.viewAnswers(mapping, mcLearningForm, request, response);
        }
        logger.debug((Object)"just presenting standard learner screen");
        request.setAttribute("mcLearnerStarterDTO", (Object)mcLearnerStarterDTO);
        return mapping.findForward("loadLearner");
    }

    protected void commonContentSetup(HttpServletRequest request, McContent mcContent, IMcService mcService, McLearningForm mcLearningForm, String toolSessionID) {
        logger.debug((Object)"dettingcommon content: ");
        TreeMap mapQuestionsContent = new TreeMap(new McComparator());
        boolean randomize = mcContent.isRandomize();
        logger.debug((Object)("randomize: " + randomize));
        List listQuestionAndCandidateAnswersDTO = LearningUtil.buildQuestionAndCandidateAnswersDTO(request, mcContent, randomize, mcService);
        logger.debug((Object)("listQuestionAndCandidateAnswersDTO: " + listQuestionAndCandidateAnswersDTO));
        request.setAttribute("listQuestionCandidateAnswersDto", (Object)listQuestionAndCandidateAnswersDTO);
        logger.debug((Object)("LIST_QUESTION_CANDIDATEANSWERS_DTO: " + request.getAttribute("listQuestionCandidateAnswersDto")));
        McGeneralLearnerFlowDTO mcGeneralLearnerFlowDTO = LearningUtil.buildMcGeneralLearnerFlowDTO(mcContent);
        mcGeneralLearnerFlowDTO.setTotalCountReached(new Boolean(false).toString());
        mcGeneralLearnerFlowDTO.setQuestionIndex(new Integer(1).toString());
        logger.debug((Object)("is tool reflective: " + mcContent.isReflect()));
        mcGeneralLearnerFlowDTO.setReflection(new Boolean(mcContent.isReflect()).toString());
        logger.debug((Object)("reflection subject: " + mcContent.getReflectionSubject()));
        String reflectionSubject = McUtils.replaceNewLines(mcContent.getReflectionSubject());
        mcGeneralLearnerFlowDTO.setReflectionSubject(reflectionSubject);
        String userID = mcLearningForm.getUserID();
        logger.debug((Object)("userID: " + userID));
        logger.debug((Object)"attempt getting notebookEntry: ");
        NotebookEntry notebookEntry = mcService.getEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lamc11", new Integer(userID));
        logger.debug((Object)("notebookEntry: " + notebookEntry));
        if (notebookEntry != null) {
            String notebookEntryPresentable = McUtils.replaceNewLines(notebookEntry.getEntry());
            mcGeneralLearnerFlowDTO.setNotebookEntry(notebookEntryPresentable);
        }
        request.setAttribute("mcGeneralLearnerFlowDTO", (Object)mcGeneralLearnerFlowDTO);
        logger.debug((Object)("MC_GENERAL_LEARNER_FLOW_DTO: " + request.getAttribute("mcGeneralLearnerFlowDTO")));
    }

    protected ActionForward validateParameters(HttpServletRequest request, McLearningForm mcLearningForm, ActionMapping mapping) {
        UserDTO user;
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        logger.debug((Object)("ss: " + ss));
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            logger.debug((Object)("retrieved userId: " + userID));
        }
        mcLearningForm.setUserID(userID);
        String strToolSessionId = request.getParameter("toolSessionID");
        long toolSessionId = 0L;
        if (strToolSessionId == null || strToolSessionId.length() == 0) {
            logger.error((Object)"error.toolSessionId.required");
        } else {
            try {
                toolSessionId = new Long(strToolSessionId);
                logger.debug((Object)("passed TOOL_SESSION_ID : " + new Long(toolSessionId)));
            }
            catch (NumberFormatException e) {
                logger.error((Object)"error.sessionId.numberFormatException");
            }
        }
        String mode = request.getParameter("mode");
        logger.debug((Object)("mode: " + mode));
        if (mode == null || mode.length() == 0) {
            logger.error((Object)"error.mode.required");
        }
        if (!(mode.equals("learner") || mode.equals("teacher") || mode.equals("author"))) {
            logger.error((Object)"error.mode.invalid");
        }
        logger.debug((Object)("session LEARNING_MODE set to:" + mode));
        return null;
    }

    public void persistError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.debug((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }
}

