/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McApplicationException;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.mc.McUtils;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.service.McServiceProxy;
import org.lamsfoundation.lams.tool.mc.web.AuthoringUtil;
import org.lamsfoundation.lams.tool.mc.web.McAuthoringForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;

public class McStarterAction
extends Action
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McStarterAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, McApplicationException {
        McUtils.cleanUpSessionAbsolute(request);
        logger.debug((Object)"init authoring mode.");
        McAuthoringForm mcAuthoringForm = (McAuthoringForm)form;
        logger.debug((Object)("mcAuthoringForm: " + mcAuthoringForm));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        logger.debug((Object)("contentFolderID: " + contentFolderID));
        mcAuthoringForm.setContentFolderID(contentFolderID);
        McGeneralAuthoringDTO mcGeneralAuthoringDTO = new McGeneralAuthoringDTO();
        mcGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        TreeMap mapQuestionContent = new TreeMap(new McComparator());
        logger.debug((Object)("mapQuestionContent: " + mapQuestionContent));
        mcAuthoringForm.resetRadioBoxes();
        IMcService mcService = null;
        if (this.getServlet() == null || this.getServlet().getServletContext() == null) {
            logger.debug((Object)"obtaining mcService from the form");
            mcService = mcAuthoringForm.getMcService();
        } else {
            logger.debug((Object)"obtaining mcService via proxy");
            mcService = McServiceProxy.getMcService(this.getServlet().getServletContext());
        }
        logger.debug((Object)("mcService: " + mcService));
        mcGeneralAuthoringDTO.setCurrentTab("1");
        logger.debug((Object)"setting currrent tab to 1:");
        mcGeneralAuthoringDTO.setMonitoringOriginatedDefineLater(new Boolean(false).toString());
        String servletPath = request.getServletPath();
        logger.debug((Object)("getServletPath: " + servletPath));
        String requestedModule = null;
        if (servletPath.indexOf("authoringStarter") > 0) {
            logger.debug((Object)"request is for authoring module");
            mcGeneralAuthoringDTO.setActiveModule("authoring");
            mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(true).toString());
            mcGeneralAuthoringDTO.setShowAuthoringTabs(new Boolean(true).toString());
            mcAuthoringForm.setActiveModule("authoring");
            requestedModule = "authoring";
        } else {
            logger.debug((Object)"request is for define later module either direcly from define later url or monitoring url");
            mcGeneralAuthoringDTO.setActiveModule("defineLater");
            mcGeneralAuthoringDTO.setDefineLaterInEditMode(new Boolean(false).toString());
            mcGeneralAuthoringDTO.setShowAuthoringTabs(new Boolean(false).toString());
            mcAuthoringForm.setActiveModule("defineLater");
            requestedModule = "defineLater";
            if (servletPath.indexOf("monitoring") > 0) {
                logger.debug((Object)"request is from monitoring  url.");
                mcGeneralAuthoringDTO.setMonitoringOriginatedDefineLater(new Boolean(true).toString());
            }
        }
        logger.debug((Object)("requestedModule: " + requestedModule));
        mcGeneralAuthoringDTO.setRequestedModule(requestedModule);
        String sourceMcStarter = (String)request.getAttribute("sourceMcStarter");
        logger.debug((Object)("sourceMcStarter: " + sourceMcStarter));
        boolean validateSignature = this.readSignature(request, mapping, mcService, mcGeneralAuthoringDTO, mcAuthoringForm);
        logger.debug((Object)("validateSignature:  " + validateSignature));
        if (!validateSignature) {
            logger.debug((Object)"error during validation");
        }
        mcGeneralAuthoringDTO.setTargetMode("Authoring");
        logger.debug((Object)"no problems getting the default content, will render authoring screen");
        String strToolContentID = "";
        strToolContentID = request.getParameter("toolContentID");
        logger.debug((Object)("strToolContentID: " + strToolContentID));
        mcGeneralAuthoringDTO.setToolContentID(strToolContentID);
        SessionMap sessionMap = new SessionMap();
        LinkedList sequentialCheckedCa = new LinkedList();
        sessionMap.put((Object)"attachmentListKey", new ArrayList());
        sessionMap.put((Object)"deletedAttachmentListKey", new ArrayList());
        sessionMap.put((Object)"activityTitleKey", (Object)"");
        sessionMap.put((Object)"activityInstructionsKey", (Object)"");
        mcAuthoringForm.setHttpSessionID(sessionMap.getSessionID());
        mcGeneralAuthoringDTO.setHttpSessionID(sessionMap.getSessionID());
        String defaultContentId = null;
        if (strToolContentID == null) {
            logger.debug((Object)"strToolContentID is null, handle this");
            Long toolContentID = (Long)request.getSession().getAttribute("toolContentID");
            logger.debug((Object)("toolContentID: " + toolContentID));
            if (toolContentID != null) {
                strToolContentID = toolContentID.toString();
                logger.debug((Object)("cached strToolContentID from the session: " + strToolContentID));
            } else {
                logger.debug((Object)"we should IDEALLY not arrive here. The TOOL_CONTENT_ID is NOT available from the url or the session.");
                defaultContentId = mcAuthoringForm.getDefaultContentIdStr();
                logger.debug((Object)("using MCQ defaultContentId: " + defaultContentId));
                strToolContentID = defaultContentId;
            }
        }
        logger.debug((Object)("final strToolContentID: " + strToolContentID));
        if (strToolContentID == null || strToolContentID.equals("")) {
            McUtils.cleanUpSessionAbsolute(request);
            logger.debug((Object)"forwarding to: errorList");
        }
        mcAuthoringForm.setToolContentID(strToolContentID);
        String defaultContentIdStr = null;
        McContent mcContent = null;
        if (!this.existsContent(new Long(strToolContentID), mcService)) {
            logger.debug((Object)"getting default content");
            defaultContentIdStr = mcAuthoringForm.getDefaultContentIdStr();
            logger.debug((Object)("defaultContentIdStr:" + defaultContentIdStr));
            mcContent = this.retrieveContent(request, mapping, mcAuthoringForm, mapQuestionContent, new Long(defaultContentIdStr), true, mcService, mcGeneralAuthoringDTO, sessionMap);
            logger.debug((Object)("post retrive content :" + sessionMap));
        } else {
            logger.debug((Object)"getting existing content");
            mcContent = mcService.retrieveMc(new Long(strToolContentID));
            logger.debug((Object)("mcContent: " + mcContent));
            if (mcService.studentActivityOccurredGlobal(mcContent)) {
                McUtils.cleanUpSessionAbsolute(request);
                logger.debug((Object)("student activity occurred on this content:" + mcContent));
            }
            mcContent = this.retrieveContent(request, mapping, mcAuthoringForm, mapQuestionContent, new Long(strToolContentID), false, mcService, mcGeneralAuthoringDTO, sessionMap);
            logger.debug((Object)("post retrive content :" + sessionMap));
        }
        logger.debug((Object)("mcGeneralAuthoringDTO.getOnlineInstructions() :" + mcGeneralAuthoringDTO.getOnlineInstructions()));
        logger.debug((Object)("mcGeneralAuthoringDTO.getOfflineInstructions():" + mcGeneralAuthoringDTO.getOfflineInstructions()));
        if (mcGeneralAuthoringDTO.getOnlineInstructions() == null || mcGeneralAuthoringDTO.getOnlineInstructions().length() == 0) {
            mcGeneralAuthoringDTO.setOnlineInstructions("");
            mcAuthoringForm.setOnlineInstructions("");
            sessionMap.put((Object)"onlineInstructionsKey", (Object)"");
        }
        if (mcGeneralAuthoringDTO.getOfflineInstructions() == null || mcGeneralAuthoringDTO.getOfflineInstructions().length() == 0) {
            mcGeneralAuthoringDTO.setOfflineInstructions("");
            mcAuthoringForm.setOfflineInstructions("");
            sessionMap.put((Object)"offlineInstructionsKey", (Object)"");
        }
        logger.debug((Object)("final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        logger.debug((Object)("will return to jsp with: " + sourceMcStarter));
        String destination = McUtils.getDestination(sourceMcStarter, requestedModule);
        logger.debug((Object)("destination: " + destination));
        Map mapQuestionContentLocal = mcGeneralAuthoringDTO.getMapQuestionContent();
        logger.debug((Object)("mapQuestionContentLocal: " + mapQuestionContentLocal));
        logger.debug((Object)("mapQuestionContent: " + mapQuestionContent));
        sessionMap.put((Object)"mapQuestionContentKey", mapQuestionContent);
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List listAddableQuestionContentDTO = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
        logger.debug((Object)("listAddableQuestionContentDTO: " + listAddableQuestionContentDTO));
        sessionMap.put((Object)"newAddableQuestionContentKey", (Object)listAddableQuestionContentDTO);
        logger.debug((Object)("persisting sessionMap into session: " + sessionMap));
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        Map marksMap = authoringUtil.buildMarksMap();
        logger.debug((Object)("marksMap: " + marksMap));
        mcGeneralAuthoringDTO.setMarksMap(marksMap);
        mcGeneralAuthoringDTO.setMarkValue("1");
        List listQuestionContentDTOLocal = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
        logger.debug((Object)("listQuestionContentDTOLocal: " + listQuestionContentDTOLocal));
        Map passMarksMap = authoringUtil.buildDynamicPassMarkMap(listQuestionContentDTOLocal, true);
        logger.debug((Object)("passMarksMap: " + passMarksMap));
        mcGeneralAuthoringDTO.setPassMarksMap(passMarksMap);
        String totalMark = AuthoringUtil.getTotalMark(listQuestionContentDTOLocal);
        logger.debug((Object)("totalMark: " + totalMark));
        mcAuthoringForm.setTotalMarks(totalMark);
        mcGeneralAuthoringDTO.setTotalMarks(totalMark);
        String passMark = " ";
        if (mcContent.getPassMark() != null && mcContent.getPassMark() != 0) {
            passMark = mcContent.getPassMark().toString();
        }
        mcGeneralAuthoringDTO.setPassMarkValue(passMark);
        Map correctMap = authoringUtil.buildCorrectMap();
        logger.debug((Object)("correctMap: " + correctMap));
        mcGeneralAuthoringDTO.setCorrectMap(correctMap);
        logger.debug((Object)("before fwding to jsp, mcAuthoringForm : " + mcAuthoringForm));
        logger.debug((Object)("final mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
        request.setAttribute("mcGeneralAuthoringDTO", (Object)mcGeneralAuthoringDTO);
        return mapping.findForward(destination);
    }

    protected McContent retrieveContent(HttpServletRequest request, ActionMapping mapping, McAuthoringForm mcAuthoringForm, Map mapQuestionContent, long toolContentID, boolean isDefaultContent, IMcService mcService, McGeneralAuthoringDTO mcGeneralAuthoringDTO, SessionMap sessionMap) {
        logger.debug((Object)("starting retrieveContent: " + mcService));
        logger.debug((Object)("toolContentID: " + toolContentID));
        logger.debug((Object)("isDefaultContent: " + isDefaultContent));
        logger.debug((Object)("getting content with id:" + toolContentID));
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        logger.debug((Object)("McContent: " + mcContent));
        McUtils.populateAuthoringDTO(request, mcContent, mcGeneralAuthoringDTO);
        mcAuthoringForm.setSln(mcContent.isShowReport() ? "1" : "0");
        mcAuthoringForm.setQuestionsSequenced(mcContent.isQuestionsSequenced() ? "1" : "0");
        mcAuthoringForm.setRandomize(mcContent.isRandomize() ? "1" : "0");
        mcAuthoringForm.setShowMarks(mcContent.isShowMarks() ? "1" : "0");
        mcAuthoringForm.setRetries(mcContent.isRetries() ? "1" : "0");
        mcAuthoringForm.setReflect(mcContent.isReflect() ? "1" : "0");
        mcAuthoringForm.setReflectionSubject(mcContent.getReflectionSubject());
        mcGeneralAuthoringDTO.setSln(mcContent.isShowReport() ? "1" : "0");
        mcGeneralAuthoringDTO.setQuestionsSequenced(mcContent.isQuestionsSequenced() ? "1" : "0");
        mcGeneralAuthoringDTO.setRandomize(mcContent.isRandomize() ? "1" : "0");
        mcGeneralAuthoringDTO.setRetries(mcContent.isRetries() ? "1" : "0");
        mcGeneralAuthoringDTO.setReflect(mcContent.isReflect() ? "1" : "0");
        mcGeneralAuthoringDTO.setReflectionSubject(mcContent.getReflectionSubject());
        List attachmentList = mcService.retrieveMcUploadedFiles(mcContent);
        mcGeneralAuthoringDTO.setAttachmentList(attachmentList);
        mcGeneralAuthoringDTO.setDeletedAttachmentList(new ArrayList());
        sessionMap.put((Object)"attachmentListKey", (Object)attachmentList);
        sessionMap.put((Object)"deletedAttachmentListKey", new ArrayList());
        mcGeneralAuthoringDTO.setIsDefineLater(new Boolean(mcContent.isDefineLater()).toString());
        mcGeneralAuthoringDTO.setActivityTitle(mcContent.getTitle());
        mcAuthoringForm.setTitle(mcContent.getTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(mcContent.getInstructions());
        mcAuthoringForm.setInstructions(mcContent.getInstructions());
        sessionMap.put((Object)"activityTitleKey", (Object)mcGeneralAuthoringDTO.getActivityTitle());
        sessionMap.put((Object)"activityInstructionsKey", (Object)mcGeneralAuthoringDTO.getActivityInstructions());
        AuthoringUtil authoringUtil = new AuthoringUtil();
        List listQuestionContentDTO = authoringUtil.buildDefaultQuestionContent(mcContent, mcService);
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("totalQuestionCount", (Object)new Integer(listQuestionContentDTO.size()));
        logger.debug((Object)("listQuestionContentDTO: " + listQuestionContentDTO));
        request.setAttribute("listQuestionContentDTO", (Object)listQuestionContentDTO);
        sessionMap.put((Object)"listQuestionContentDTOKey", (Object)listQuestionContentDTO);
        if (isDefaultContent) {
            logger.debug((Object)"overwriting default question.");
            mcGeneralAuthoringDTO.setDefaultQuestionContent("Sample Question 1?");
        }
        logger.debug((Object)("mapQuestionContent is:" + mapQuestionContent));
        mcGeneralAuthoringDTO.setMapQuestionContent(mapQuestionContent);
        logger.debug((Object)("mcContent.getOnlineInstructions():" + mcContent.getOnlineInstructions()));
        logger.debug((Object)("mcContent.getOfflineInstructions():" + mcContent.getOfflineInstructions()));
        mcGeneralAuthoringDTO.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcGeneralAuthoringDTO.setOfflineInstructions(mcContent.getOfflineInstructions());
        mcAuthoringForm.setOnlineInstructions(mcContent.getOnlineInstructions());
        mcAuthoringForm.setOfflineInstructions(mcContent.getOfflineInstructions());
        sessionMap.put((Object)"onlineInstructionsKey", (Object)mcContent.getOnlineInstructions());
        sessionMap.put((Object)"offlineInstructionsKey", (Object)mcContent.getOfflineInstructions());
        logger.debug((Object)("ACTIVITY_TITLE_KEY set to:" + sessionMap.get((Object)"activityTitleKey")));
        mcAuthoringForm.resetUserAction();
        logger.debug((Object)("returning mcContent:" + mcContent));
        return mcContent;
    }

    public boolean readSignature(HttpServletRequest request, ActionMapping mapping, IMcService mcService, McGeneralAuthoringDTO mcGeneralAuthoringDTO, McAuthoringForm mcAuthoringForm) {
        logger.debug((Object)("mcService: " + mcService));
        long defaultContentID = 0L;
        try {
            logger.debug((Object)"attempt retrieving tool with signatute : lamc11");
            defaultContentID = mcService.getToolDefaultContentIdBySignature("lamc11");
            logger.debug((Object)("retrieved tool default contentId: " + defaultContentID));
            if (defaultContentID == 0L) {
                logger.debug((Object)"default content id has not been setup");
                return false;
            }
        }
        catch (Exception e) {
            logger.debug((Object)("error getting the default content id: " + e.getMessage()));
            this.persistError(request, "error.defaultContent.notSetup");
            return false;
        }
        long contentUID = 0L;
        try {
            logger.debug((Object)("retrieve uid of the content based on default content id determined above: " + defaultContentID));
            McContent mcContent = mcService.retrieveMc(new Long(defaultContentID));
            if (mcContent == null) {
                logger.debug((Object)"Exception occured: No default content");
                this.persistError(request, "error.defaultContent.notSetup");
                return false;
            }
            logger.debug((Object)("using mcContent: " + mcContent));
            logger.debug((Object)("using mcContent uid: " + mcContent.getUid()));
            contentUID = mcContent.getUid();
            logger.debug((Object)("contentUID: " + contentUID));
        }
        catch (Exception e) {
            logger.debug((Object)"Exception occured: No default question content");
            this.persistError(request, "error.defaultContent.notSetup");
            return false;
        }
        logger.debug((Object)("MC tool has the default content id: " + defaultContentID));
        mcGeneralAuthoringDTO.setDefaultContentIdStr(new Long(defaultContentID).toString());
        mcAuthoringForm.setDefaultContentIdStr(new Long(defaultContentID).toString());
        return true;
    }

    protected boolean existsContent(long toolContentID, IMcService mcService) {
        McContent mcContent = mcService.retrieveMc(new Long(toolContentID));
        return mcContent != null;
    }

    public ActionForward executeDefineLater(ActionMapping mapping, McAuthoringForm mcAuthoringForm, HttpServletRequest request, HttpServletResponse response, IMcService mcService) throws IOException, ServletException, McApplicationException {
        logger.debug((Object)"calling execute..., mcService will be needed next.");
        return this.execute(mapping, mcAuthoringForm, request, response);
    }

    public void persistError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.debug((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }
}

