/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams;

import java.util.Date;
import java.util.HashSet;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;

public abstract class LamsLearningDataAccessTestCase
extends AbstractLamsTestCase {
    protected ILessonDAO lessonDao;
    protected ILessonClassDAO lessonClassDao;
    protected Lesson testLesson;
    protected LessonClass testLessonClass;
    private final int TEST_GROUP_ORDER_ID = 0;
    protected IUserDAO userDao;
    protected IOrganisationDAO orgDao;
    private final Integer TEST_USER_ID = new Integer(1);
    private final Long TEST_LEARNING_DESIGN_ID = new Long(1L);
    private final Integer TEST_ORGANIZATION_ID = new Integer(1);
    protected ILearningDesignDAO learningDesignDao;
    protected LearningDesign testLearningDesign;
    protected User testUser;
    protected Organisation testOrg;

    protected void setUp() throws Exception {
        super.setUp();
        this.testUser = this.userDao.getUserById(this.TEST_USER_ID);
        this.testLearningDesign = this.learningDesignDao.getLearningDesignById(this.TEST_LEARNING_DESIGN_ID);
        this.testOrg = this.orgDao.getOrganisationById(this.TEST_ORGANIZATION_ID);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public LamsLearningDataAccessTestCase(String string) {
        super(string);
    }

    protected abstract String[] getContextConfigLocation();

    protected void initLessonClassData() {
        HashSet hashSet = new HashSet(this.testLearningDesign.getActivities());
        this.testLessonClass = new LessonClass(null, new HashSet(), hashSet, null, this.testLesson);
    }

    protected void setUpGroupsForClass() {
        HashSet<User> hashSet = new HashSet<User>();
        hashSet.add(this.testUser);
        Group group = new Group(null, 0, this.testLessonClass, hashSet, new HashSet());
        this.testLessonClass.setStaffGroup(group);
        HashSet<Group> hashSet2 = new HashSet<Group>();
        HashSet hashSet3 = new HashSet(this.testOrg.getUsers());
        Group group2 = new Group(null, this.testLessonClass.getNextGroupOrderId(), this.testLessonClass, hashSet3, new HashSet());
        hashSet2.add(group2);
        hashSet2.add(group);
        this.testLessonClass.setGroups(hashSet2);
    }

    protected void initLessonData() {
        this.testLesson = new Lesson(new Date(System.currentTimeMillis()), this.testUser, Lesson.CREATED, this.testLearningDesign, this.testLessonClass, this.testOrg, new HashSet());
    }
}

