/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;

public class LearningDesign
implements Serializable {
    public static final String DESIGN_OBJECT = "LearningDesign";
    public static final String DESIGN_LIST_OBJECT = "LearningDesignList";
    public static final int COPY_TYPE_NONE = 1;
    public static final int COPY_TYPE_LESSON = 2;
    public static final int COPY_TYPE_PREVIEW = 3;
    private Long learningDesignId;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Activity firstActivity;
    private Integer maxId;
    private Boolean validDesign;
    private Boolean readOnly;
    private Date dateReadOnly;
    private String helpText;
    private Integer copyTypeID;
    private Date createDateTime;
    private String version;
    private User user;
    private LearningDesign parentLearningDesign;
    private Set childLearningDesigns;
    private Set lessons;
    private Set transitions;
    private Set activities;
    private WorkspaceFolder workspaceFolder;
    private Long duration;
    private String licenseText;
    private License license;

    public LearningDesign(Long learningDesignId, Integer ui_id, String description, String title, Activity firstActivity, Integer maxId, Boolean validDesign, Boolean readOnly, Date dateReadOnly, String helpText, Integer copyTypeID, Date createDateTime, String version, User user, LearningDesign parentLearningDesign, Set childLearningDesigns, Set lessons, Set transitions, Set activities, Long duration, String licenseText, License license) {
        this.learningDesignId = learningDesignId;
        this.learningDesignUIID = ui_id;
        this.description = description;
        this.title = title;
        this.firstActivity = firstActivity;
        this.maxId = maxId;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime;
        this.version = version;
        this.user = user;
        this.parentLearningDesign = parentLearningDesign;
        this.childLearningDesigns = childLearningDesigns;
        this.lessons = lessons;
        this.transitions = transitions;
        this.activities = activities;
        this.duration = duration;
        this.licenseText = licenseText;
        this.license = license;
    }

    public LearningDesign() {
    }

    public LearningDesign(Long learningDesignId, Boolean validDesign, Boolean readOnly, Integer copyTypeID, Date createDateTime, String version, User user, LearningDesign parentLearningDesign, Set childLearningDesigns, Set lessons, Set transitions, Set activities) {
        this.learningDesignId = learningDesignId;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime;
        this.version = version;
        this.user = user;
        this.parentLearningDesign = parentLearningDesign;
        this.childLearningDesigns = childLearningDesigns;
        this.lessons = lessons;
        this.transitions = transitions;
        this.activities = activities;
    }

    public static LearningDesign createLearningDesignCopy(LearningDesign design, Integer designCopyType) {
        LearningDesign newDesign = LearningDesign.newInstance(design);
        if (designCopyType != 1) {
            newDesign.setReadOnly(new Boolean(true));
        } else {
            newDesign.setReadOnly(new Boolean(false));
        }
        newDesign.setCopyTypeID(designCopyType);
        return newDesign;
    }

    private static LearningDesign newInstance(LearningDesign design) {
        LearningDesign newDesign = new LearningDesign();
        newDesign.setDescription(design.getDescription());
        newDesign.setTitle(design.getTitle());
        newDesign.setMaxId(design.getMaxId());
        newDesign.setValidDesign(design.getValidDesign());
        newDesign.setDateReadOnly(design.getDateReadOnly());
        newDesign.setHelpText(design.getHelpText());
        newDesign.setVersion(design.getVersion());
        newDesign.setParentLearningDesign(design);
        newDesign.setCreateDateTime(new Date());
        newDesign.setDuration(design.getDuration());
        newDesign.setLicense(design.getLicense());
        newDesign.setLicenseText(design.getLicenseText());
        return newDesign;
    }

    public Long getLearningDesignId() {
        return this.learningDesignId;
    }

    public void setLearningDesignId(Long learningDesignId) {
        this.learningDesignId = learningDesignId;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID;
    }

    public void setLearningDesignUIID(Integer id) {
        this.learningDesignUIID = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Activity getFirstActivity() {
        return this.firstActivity;
    }

    public void setFirstActivity(Activity firstActivity) {
        this.firstActivity = firstActivity;
    }

    public Integer getMaxId() {
        return this.maxId;
    }

    public void setMaxId(Integer maxId) {
        this.maxId = maxId;
    }

    public Boolean getValidDesign() {
        return this.validDesign;
    }

    public void setValidDesign(Boolean validDesign) {
        this.validDesign = validDesign;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly;
    }

    public void setDateReadOnly(Date dateReadOnly) {
        this.dateReadOnly = dateReadOnly;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LearningDesign getParentLearningDesign() {
        return this.parentLearningDesign;
    }

    public void setParentLearningDesign(LearningDesign parentLearningDesign) {
        this.parentLearningDesign = parentLearningDesign;
    }

    public Set getChildLearningDesigns() {
        return this.childLearningDesigns;
    }

    public void setChildLearningDesigns(Set childLearningDesigns) {
        this.childLearningDesigns = childLearningDesigns;
    }

    public Set getLessons() {
        return this.lessons;
    }

    public void setLessons(Set lessons) {
        this.lessons = lessons;
    }

    public Set getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Set transitions) {
        this.transitions = transitions;
    }

    public Set getActivities() {
        return this.activities;
    }

    public void setActivities(Set activities) {
        this.activities = activities;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("learningDesignId", (Object)this.getLearningDesignId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LearningDesign)) {
            return false;
        }
        LearningDesign castOther = (LearningDesign)other;
        return new EqualsBuilder().append((Object)this.getReadOnly(), (Object)castOther.getReadOnly()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getReadOnly()).toHashCode();
    }

    public HashSet getParentActivities() {
        HashSet<Activity> parentActivities = new HashSet<Activity>();
        Iterator iterator = this.getActivities().iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity.getParentActivity() != null) continue;
            parentActivities.add(activity);
        }
        return parentActivities;
    }

    public Activity calculateFirstActivity() {
        Activity firstActivity = null;
        HashSet parentActivities = this.getParentActivities();
        Iterator parentIterator = parentActivities.iterator();
        while (parentIterator.hasNext()) {
            Activity activity = (Activity)parentIterator.next();
            if (activity.getTransitionTo() != null) continue;
            firstActivity = activity;
            break;
        }
        return firstActivity;
    }

    public WorkspaceFolder getWorkspaceFolder() {
        return this.workspaceFolder;
    }

    public void setWorkspaceFolder(WorkspaceFolder workspaceFolder) {
        this.workspaceFolder = workspaceFolder;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID;
    }

    public void setCopyTypeID(Integer copyTypeID) {
        this.copyTypeID = copyTypeID;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }
}

