/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.Set;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;

public class TestActivity
extends AbstractLamsTestCase {
    protected ActivityDAO activityDAO;
    protected IUserDAO userDAO;
    protected User testUser;
    private static final Long TEST_SEQUENCE_ACTIVITY = new Long(14L);
    private static final Long TEST_SURVEY_ACTIVITY = new Long(20L);
    private static final Long TEST_MB_ACTIVITY = new Long(19L);
    private static final Integer TEST_USER_ID = new Integer(2);

    protected void setUp() throws Exception {
        super.setUp();
        this.activityDAO = (ActivityDAO)this.context.getBean("activityDAO");
        this.userDAO = (UserDAO)this.context.getBean("userDAO");
        this.testUser = this.userDAO.getUserById(TEST_USER_ID);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestActivity(String string) {
        super(string);
    }

    public void testGetAllToolActivitiesFromComplexActivity() {
        Activity activity = this.activityDAO.getActivityByActivityId(TEST_SEQUENCE_ACTIVITY);
        Set set = activity.getAllToolActivitiesFrom(activity);
        TestActivity.assertEquals((String)"verify the number tool activity we should get", (int)2, (int)set.size());
    }

    public void testGetAllToolActivitiesFromToolActivity() {
        Activity activity = this.activityDAO.getActivityByActivityId(TEST_SURVEY_ACTIVITY);
        Set set = activity.getAllToolActivitiesFrom(activity);
        TestActivity.assertEquals((String)"verify the number tool activity we should get", (int)1, (int)set.size());
    }

    public void testGetGroupForUser() {
        Activity activity = this.activityDAO.getActivityByActivityId(TEST_MB_ACTIVITY);
        Group group = activity.getGroupFor(this.testUser);
        TestActivity.assertNotNull((Object)group);
        TestActivity.assertEquals((String)"verify group id", (long)88L, (long)group.getGroupId());
        TestActivity.assertEquals((String)"verify the grouping this group belongs to", (long)100L, (long)group.getGrouping().getGroupingId());
        TestActivity.assertEquals((String)"verify the order of this group", (int)1, (int)group.getOrderId());
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"/org/lamsfoundation/lams/learningdesign/learningDesignApplicationContext.xml", "applicationContext.xml"};
    }
}

