/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.User;

public class LearnerProgress
implements Serializable {
    public static final byte ACTIVITY_COMPLETED = 1;
    public static final byte ACTIVITY_ATTEMPTED = 2;
    public static final byte ACTIVITY_NOT_ATTEMPTED = 3;
    private Long learnerProgressId;
    private User user;
    private Lesson lesson;
    private Set attemptedActivities;
    private Set completedActivities;
    private Activity previousActivity;
    private Activity currentActivity;
    private Activity nextActivity;
    private boolean lessonComplete;

    public LearnerProgress() {
    }

    public LearnerProgress(User user, Lesson lesson) {
        this(null, user, lesson, new TreeSet(new ActivityOrderComparator()), new TreeSet(new ActivityOrderComparator()));
    }

    public LearnerProgress(Long learnerProgressId, User user, Lesson lesson, Set attemptedActivities, Set completedActivities) {
        this.learnerProgressId = learnerProgressId;
        this.user = user;
        this.lesson = lesson;
        this.attemptedActivities = attemptedActivities;
        this.completedActivities = completedActivities;
    }

    public Long getLearnerProgressId() {
        return this.learnerProgressId;
    }

    public void setLearnerProgressId(Long learnerProgressId) {
        this.learnerProgressId = learnerProgressId;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public Set getAttemptedActivities() {
        return this.attemptedActivities;
    }

    public void setAttemptedActivities(Set attemptedActivities) {
        this.attemptedActivities = attemptedActivities;
    }

    public Set getCompletedActivities() {
        return this.completedActivities;
    }

    public void setCompletedActivities(Set completedActivities) {
        this.completedActivities = completedActivities;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("learnerProgressId", (Object)this.getLearnerProgressId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LearnerProgress)) {
            return false;
        }
        LearnerProgress castOther = (LearnerProgress)other;
        return new EqualsBuilder().append((Object)this.getLearnerProgressId(), (Object)castOther.getLearnerProgressId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getLearnerProgressId()).toHashCode();
    }

    public Activity getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(Activity currentActivity) {
        this.currentActivity = currentActivity;
    }

    public byte getProgressState(Activity activity) {
        if (this.completedActivities.contains(activity)) {
            return 1;
        }
        if (this.attemptedActivities.contains(activity)) {
            return 2;
        }
        return 3;
    }

    public void setProgressState(Activity activity, byte state) {
        byte oldState = this.getProgressState(activity);
        if (oldState != 3) {
            if (oldState == 2) {
                this.attemptedActivities.remove(activity);
            } else if (oldState == 1) {
                this.completedActivities.remove(activity);
            }
        }
        if (state != 3) {
            if (state == 2) {
                this.attemptedActivities.add(activity);
            } else if (state == 1) {
                this.completedActivities.add(activity);
            }
        }
    }

    public boolean isLessonComplete() {
        return this.lessonComplete;
    }

    public void setLessonComplete(boolean lessonComplete) {
        this.lessonComplete = lessonComplete;
    }

    public Activity getNextActivity() {
        return this.nextActivity;
    }

    public void setNextActivity(Activity nextActivity) {
        this.nextActivity = nextActivity;
    }

    public Activity getPreviousActivity() {
        return this.previousActivity;
    }

    public void setPreviousActivity(Activity previousActivity) {
        this.previousActivity = previousActivity;
    }
}

