/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.util.Date;
import java.util.HashSet;
import net.sf.hibernate.HibernateException;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dao.hibernate.LearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.hibernate.LessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.hibernate.LessonDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.OrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;

public class LessonDataAccessTestCase
extends AbstractLamsTestCase {
    protected IUserDAO userDao;
    protected ILearningDesignDAO learningDesignDao;
    protected IOrganisationDAO orgDao;
    protected ILessonDAO lessonDao;
    protected ILessonClassDAO lessonClassDao;
    protected ILearnerProgressDAO learnerProgressDao;
    protected Lesson testLesson;
    protected User testUser;
    protected LearningDesign testLearningDesign;
    protected Organisation testOrg;
    protected LessonClass testLessonClass;
    protected LearnerProgress testLearnerProgress;
    private final Integer TEST_USER_ID = new Integer(1);
    private final Long TEST_LEARNING_DESIGN_ID = new Long(1L);
    private final Integer TEST_ORGANIZATION_ID = new Integer(1);
    private final int TEST_GROUP_ORDER_ID = 0;

    public LessonDataAccessTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.userDao = (UserDAO)this.context.getBean("userDAO");
        this.learningDesignDao = (LearningDesignDAO)this.context.getBean("learningDesignDAO");
        this.orgDao = (OrganisationDAO)this.context.getBean("organisationDAO");
        this.testUser = this.userDao.getUserById(this.TEST_USER_ID);
        this.testLearningDesign = this.learningDesignDao.getLearningDesignById(this.TEST_LEARNING_DESIGN_ID);
        this.testOrg = this.orgDao.getOrganisationById(this.TEST_ORGANIZATION_ID);
        this.lessonDao = (LessonDAO)this.context.getBean("lessonDAO");
        this.lessonClassDao = (LessonClassDAO)this.context.getBean("lessonClassDAO");
        this.learnerProgressDao = (LearnerProgressDAO)this.context.getBean("learnerProgressDAO");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"/org/lamsfoundation/lams/lesson/lessonApplicationContext.xml", "/org/lamsfoundation/lams/learningdesign/learningDesignApplicationContext.xml", "applicationContext.xml"};
    }

    protected void initializeTestLesson() throws HibernateException {
        this.initLessonClassData();
        this.lessonClassDao.saveLessonClass(this.testLessonClass);
        this.setUpGroupsForClass();
        this.lessonClassDao.updateLessonClass(this.testLessonClass);
        this.initLessonData();
        this.lessonDao.saveLesson(this.testLesson);
        super.getSession().flush();
    }

    protected void cleanUpLesson(Lesson lesson) {
        this.lessonDao.deleteLesson(lesson);
    }

    protected void cleanUpTestLesson() throws HibernateException {
        this.cleanUpLesson(this.testLesson);
    }

    protected void initLessonClassData() {
        HashSet hashSet = new HashSet(this.testLearningDesign.getActivities());
        this.testLessonClass = new LessonClass(null, new HashSet(), hashSet, null, this.testLesson);
    }

    protected void setUpGroupsForClass() {
        HashSet<User> hashSet = new HashSet<User>();
        hashSet.add(this.testUser);
        Group group = new Group(null, 0, this.testLessonClass, hashSet, new HashSet());
        this.testLessonClass.setStaffGroup(group);
        HashSet<Group> hashSet2 = new HashSet<Group>();
        HashSet hashSet3 = new HashSet(this.testOrg.getUsers());
        Group group2 = new Group(null, this.testLessonClass.getNextGroupOrderId(), this.testLessonClass, hashSet3, new HashSet());
        hashSet2.add(group2);
        hashSet2.add(group);
        this.testLessonClass.setGroups(hashSet2);
    }

    protected void initLessonData() {
        this.testLesson = new Lesson(new Date(System.currentTimeMillis()), this.testUser, Lesson.CREATED, this.testLearningDesign, this.testLessonClass, this.testOrg, new HashSet());
    }

    protected void initLearnerProgressData() {
        if (this.testLesson == null) {
            throw new IllegalArgumentException("Can't initialize progress without lesson");
        }
        this.testLearnerProgress = new LearnerProgress(this.testUser, this.testLesson);
    }

    protected void assertLessonClass(LessonClass lessonClass) {
        LessonDataAccessTestCase.assertEquals((String)"check up number of activities", (int)11, (int)lessonClass.getActivities().size());
        LessonDataAccessTestCase.assertEquals((String)"check up staff groups", (int)1, (int)lessonClass.getStaffGroup().getUsers().size());
        LessonDataAccessTestCase.assertEquals((String)"check up grouping types, should be class grouping", (Object)Grouping.CLASS_GROUPING_TYPE, (Object)lessonClass.getGroupingTypeId());
        LessonDataAccessTestCase.assertEquals((String)"check up groups", (int)2, (int)lessonClass.getGroups().size());
    }

    protected void assertLesson(Lesson lesson) {
        LessonDataAccessTestCase.assertEquals((String)"check up creation time", (String)this.testLesson.getCreateDateTime().toString(), (String)lesson.getCreateDateTime().toString());
        LessonDataAccessTestCase.assertEquals((String)"check up user who created this lesson", (String)this.testUser.getLogin(), (String)lesson.getUser().getLogin());
        LessonDataAccessTestCase.assertEquals((String)"check up the lesson state", (Object)Lesson.CREATED, (Object)lesson.getLessonStateId());
        LessonDataAccessTestCase.assertEquals((String)"check up the learning design that used to create lesson", (String)this.testLearningDesign.getTitle(), (String)lesson.getLearningDesign().getTitle());
        LessonDataAccessTestCase.assertEquals((String)"check up the organization", (String)this.testOrg.getName(), (String)lesson.getOrganisation().getName());
        LessonDataAccessTestCase.assertEquals((String)"check up the learner progresses", (int)0, (int)lesson.getLearnerProgresses().size());
    }
}

