/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class LessonDAO
extends HibernateDaoSupport
implements ILessonDAO {
    static /* synthetic */ Class class$org$lamsfoundation$lams$lesson$Lesson;

    public Lesson getLesson(Long lessonId) {
        return (Lesson)this.getHibernateTemplate().get(class$org$lamsfoundation$lams$lesson$Lesson == null ? (class$org$lamsfoundation$lams$lesson$Lesson = LessonDAO.class$("org.lamsfoundation.lams.lesson.Lesson")) : class$org$lamsfoundation$lams$lesson$Lesson, (Serializable)lessonId);
    }

    public Lesson getLessonWithEagerlyFetchedProgress(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Lesson)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(class$org$lamsfoundation$lams$lesson$Lesson == null ? (class$org$lamsfoundation$lams$lesson$Lesson = LessonDAO.class$("org.lamsfoundation.lams.lesson.Lesson")) : class$org$lamsfoundation$lams$lesson$Lesson).add((Criterion)Expression.like((String)"lessonId", (Object)lessonId)).setFetchMode("learnerProgresses", FetchMode.EAGER).uniqueResult();
            }
        });
    }

    public List getAllLessons() {
        return this.getHibernateTemplate().loadAll(class$org$lamsfoundation$lams$lesson$Lesson == null ? (class$org$lamsfoundation$lams$lesson$Lesson = LessonDAO.class$("org.lamsfoundation.lams.lesson.Lesson")) : class$org$lamsfoundation$lams$lesson$Lesson);
    }

    public List getActiveLessonsForLearner(final User learner) {
        List lessons = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        lessons = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("activeLessons");
                query.setInteger("userId", learner.getUserId().intValue());
                List result = query.list();
                return result;
            }
        });
        return lessons;
    }

    public void saveLesson(Lesson lesson) {
        this.getHibernateTemplate().save((Object)lesson);
    }

    public void deleteLesson(Lesson lesson) {
        this.getHibernateTemplate().delete((Object)lesson);
    }

    public void updateLesson(Lesson lesson) {
        this.getHibernateTemplate().update((Object)lesson);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

