/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao;

import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.ToolDataAccessTestCase;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolSessionDAO;

public class TestToolSessionDAO
extends ToolDataAccessTestCase {
    private IToolSessionDAO toolSessionDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.toolSessionDao = (ToolSessionDAO)this.context.getBean("toolSessionDAO");
        super.initTestToolSession();
        this.toolSessionDao.saveToolSession(this.ngToolSession);
        this.toolSessionDao.saveToolSession(this.gToolSession);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.toolSessionDao.removeToolSession(this.ngToolSession);
        this.toolSessionDao.removeToolSession(this.gToolSession);
    }

    public TestToolSessionDAO(String string) {
        super(string);
    }

    public void testGetToolSession() {
        NonGroupedToolSession nonGroupedToolSession = (NonGroupedToolSession)this.toolSessionDao.getToolSession(this.ngToolSession.getToolSessionId());
        TestToolSessionDAO.assertNotNull((Object)nonGroupedToolSession);
        TestToolSessionDAO.assertEquals((String)"verify tool session state", (int)1, (int)nonGroupedToolSession.getToolSessionStateId());
        TestToolSessionDAO.assertEquals((String)"verify tool session type", (int)2, (int)nonGroupedToolSession.getToolSessionTypeId());
        TestToolSessionDAO.assertNotNull((Object)nonGroupedToolSession.getUser());
    }

    public void testGetToolSessionByLearner() {
        ToolSession toolSession = this.toolSessionDao.getToolSessionByLearner(this.testUser, this.testNonGroupedActivity);
        TestToolSessionDAO.assertNotNull((Object)toolSession);
    }

    public void testGetToolSessionByGroup() {
        ToolSession toolSession = this.toolSessionDao.getToolSessionByGroup(this.testGroup, this.testGroupedActivity);
        TestToolSessionDAO.assertNotNull((Object)toolSession);
    }

    public void testSaveNonGroupedToolSession() {
        ToolSession toolSession = this.initNGToolSession();
        this.toolSessionDao.saveToolSession(this.ngToolSession);
    }
}

