/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao.hibernate;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class ToolSessionDAO
extends HibernateDaoSupport
implements IToolSessionDAO {
    protected static final String LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER = "from NonGroupedToolSession s where s.user = :learner and s.toolActivity = :activity";
    protected static final String LOAD_NONGROUPED_TOOL_SESSION_BY_GROUP = "from GroupedToolSession s where s.group = :group and s.toolActivity = :activity";
    static /* synthetic */ Class class$org$lamsfoundation$lams$tool$ToolSession;

    public ToolSession getToolSession(Long toolSessionId) {
        return (ToolSession)this.getHibernateTemplate().get(class$org$lamsfoundation$lams$tool$ToolSession == null ? (class$org$lamsfoundation$lams$tool$ToolSession = ToolSessionDAO.class$("org.lamsfoundation.lams.tool.ToolSession")) : class$org$lamsfoundation$lams$tool$ToolSession, (Serializable)toolSessionId);
    }

    public ToolSession getToolSessionByLearner(final User learner, final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (ToolSession)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(ToolSessionDAO.LOAD_NONGROUPED_TOOL_SESSION_BY_LEARNER).setEntity("learner", (Object)learner).setEntity("activity", (Object)activity).uniqueResult();
            }
        });
    }

    public ToolSession getToolSessionByGroup(final Group group, final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (ToolSession)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(ToolSessionDAO.LOAD_NONGROUPED_TOOL_SESSION_BY_GROUP).setEntity("group", (Object)group).setEntity("activity", (Object)activity).uniqueResult();
            }
        });
    }

    public void saveToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().save((Object)toolSession);
    }

    public void removeToolSession(ToolSession toolSession) {
        this.getHibernateTemplate().delete((Object)toolSession);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

