/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import junit.framework.TestCase;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.OrganisationTypeDAO;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class OrganisationTypeDAOTest
extends TestCase {
    private OrganisationType organisationType = null;
    private String errorMessage = "";
    private OrganisationTypeDAO organisationTypeDAO = null;
    private ApplicationContext ctx;

    protected void setUp() throws Exception {
        this.ctx = new FileSystemXmlApplicationContext("applicationContext.xml");
        this.organisationTypeDAO = (OrganisationTypeDAO)this.ctx.getBean("organisationTypeDAO");
    }

    protected void tearDown() throws Exception {
        this.organisationTypeDAO = null;
    }

    public void testSaveOrganisationType() {
        this.organisationType = new OrganisationType("TEST", "for test purpose only", null);
        this.organisationTypeDAO.saveOrganisationType(this.organisationType);
        OrganisationTypeDAOTest.assertNotNull((Object)this.organisationTypeDAO.getOrganisationTypeByName("TEST"));
    }

    public void testGetOrganisationTypeById() {
        this.errorMessage = "The name of the organisationType gotten by Id 1 is not ROOT ORGANISATION";
        this.organisationType = this.organisationTypeDAO.getOrganisationTypeById(new Integer(1));
        OrganisationTypeDAOTest.assertEquals((String)this.errorMessage, (String)"ROOT ORGANISATION", (String)this.organisationType.getName());
    }

    public void testGetOrganisationTypeByName() {
        this.errorMessage = "The id of the organisationType gotten by name ROOT ORGANISATION is not 1";
        this.organisationType = this.organisationTypeDAO.getOrganisationTypeByName("ROOT ORGANISATION");
        OrganisationTypeDAOTest.assertEquals((String)this.errorMessage, (Object)new Integer(1), (Object)this.organisationType.getOrganisationTypeId());
    }

    public void testDeleteOrganisationType() {
        this.organisationType = this.organisationTypeDAO.getOrganisationTypeByName("TEST");
        this.organisationTypeDAO.deleteOrganisationType(this.organisationType);
        OrganisationTypeDAOTest.assertNull((Object)this.organisationTypeDAO.getOrganisationTypeByName("TEST"));
    }
}

