/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.dao.IAuthenticationMethodDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationTypeDAO;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationRoleDAO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class UserManagementService
implements IUserManagementService {
    private IUserDAO userDAO;
    private IRoleDAO roleDAO;
    private IOrganisationDAO organisationDAO;
    private IOrganisationTypeDAO organisationTypeDAO;
    private IUserOrganisationDAO userOrganisationDAO;
    private IUserOrganisationRoleDAO userOrganisationRoleDAO;
    private IAuthenticationMethodDAO authenticationMethodDAO;

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setRoleDAO(IRoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationTypeDAO(IOrganisationTypeDAO organisationTypeDAO) {
        this.organisationTypeDAO = organisationTypeDAO;
    }

    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    public void setUserOrganisationRoleDAO(IUserOrganisationRoleDAO userOrganisationRoleDAO) {
        this.userOrganisationRoleDAO = userOrganisationRoleDAO;
    }

    public void setAuthenticationMethodDAO(IAuthenticationMethodDAO authenticationMethodDAO) {
        this.authenticationMethodDAO = authenticationMethodDAO;
    }

    public User getUserById(Integer userId) {
        return this.userDAO.getUserById(userId);
    }

    public User getUserByLogin(String login) {
        return this.userDAO.getUserByLogin(login);
    }

    public Organisation getOrganisationById(Integer organisationId) {
        return this.organisationDAO.getOrganisationById(organisationId);
    }

    public OrganisationType getOrganisationTypeByName(String name) {
        return this.organisationTypeDAO.getOrganisationTypeByName(name);
    }

    public Organisation getBaseOrganisation(Organisation organisation) {
        if (organisation.getOrganisationType().getName().equals("ROOT ORGANISATION")) {
            return null;
        }
        if (organisation.getOrganisationType().getName().equals("BASE ORGANISATION")) {
            return organisation;
        }
        return this.getBaseOrganisation(organisation.getParentOrganisation());
    }

    public Role getRoleByName(String roleName) {
        return this.roleDAO.getRoleByName(roleName);
    }

    public UserOrganisationRole getUserOrganisationRole(String login, Integer organisationId, String roleName) {
        User user = this.userDAO.getUserByLogin(login);
        if (user == null) {
            return null;
        }
        UserOrganisation userOrganisation = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), organisationId);
        if (userOrganisation == null) {
            return null;
        }
        Role role = this.roleDAO.getRoleByName(roleName);
        if (role == null) {
            return null;
        }
        return this.userOrganisationRoleDAO.getUserOrganisationRole(userOrganisation.getUserOrganisationId(), role.getRoleId());
    }

    public UserOrganisation getUserOrganisation(Integer userId, Integer organisationId) {
        return this.userOrganisationDAO.getUserOrganisation(userId, organisationId);
    }

    public List getAllAuthenticationMethods() {
        return this.authenticationMethodDAO.getAllAuthenticationMethods();
    }

    public AuthenticationMethod getAuthenticationMethodForUser(String login) {
        return this.authenticationMethodDAO.getAuthenticationMethodByUser(this.userDAO.getUserByLogin(login));
    }

    public AuthenticationMethod getAuthenticationMethodByName(String name) {
        return this.authenticationMethodDAO.getAuthenticationMethodByName(name);
    }

    public List getUserOrganisationsForUser(User user) {
        return this.userOrganisationDAO.getUserOrganisationsByUser(user);
    }

    public List getOrganisationsForUserByRole(User user, String roleName) {
        ArrayList<Organisation> list = new ArrayList<Organisation>();
        Iterator i = this.userOrganisationDAO.getUserOrganisationsByUser(user).iterator();
        while (i.hasNext()) {
            UserOrganisation userOrganisation = (UserOrganisation)i.next();
            Iterator i2 = userOrganisation.getUserOrganisationRoles().iterator();
            while (i2.hasNext()) {
                UserOrganisationRole userOrgansiationRole = (UserOrganisationRole)i2.next();
                if (!userOrgansiationRole.getRole().getName().equals(roleName)) continue;
                list.add(userOrgansiationRole.getUserOrganisation().getOrganisation());
            }
        }
        return list;
    }

    public List getChildOrganisations(Organisation parentOrg) {
        return this.organisationDAO.getChildOrganisations(parentOrg);
    }

    public List getRolesForUserByOrganisation(User user, Integer orgId) {
        ArrayList<Role> list = new ArrayList<Role>();
        UserOrganisation userOrg = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), orgId);
        if (userOrg == null) {
            return null;
        }
        Iterator i = this.userOrganisationRoleDAO.getUserOrganisationRoles(userOrg.getUserOrganisationId()).iterator();
        while (i.hasNext()) {
            UserOrganisationRole userOrgRole = (UserOrganisationRole)i.next();
            list.add(userOrgRole.getRole());
        }
        return list;
    }

    public List getUsersFromOrganisation(Integer orgId) {
        ArrayList<User> list = new ArrayList<User>();
        Iterator i = this.userOrganisationDAO.getUserOrganisationsByOrganisationId(orgId).iterator();
        while (i.hasNext()) {
            UserOrganisation userOrganisation = (UserOrganisation)i.next();
            list.add(userOrganisation.getUser());
        }
        return list;
    }

    public void createUser(User user) {
        this.userDAO.saveUser(user);
    }

    public void updateUser(User user) {
        this.userDAO.updateUser(user);
    }

    public void saveOrUpdateUser(User user) {
        this.userDAO.saveOrUpdateUser(user);
    }

    public void updatePassword(String login, String newPassword) {
        this.userDAO.updatePassword(login, newPassword);
    }

    public void removeUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.deleteUserOrganisation(userOrganisation);
    }

    public void saveOrUpdateOrganisation(Organisation organisation) {
        this.organisationDAO.saveOrUpdateOrganisation(organisation);
    }

    public void saveOrUpdateUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
    }

    public void saveOrUpdateUserOrganisationRole(UserOrganisationRole userOrganisationRole) {
        this.userOrganisationRoleDAO.saveOrUpdateUserOrganisationRole(userOrganisationRole);
    }
}

