/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.web;

import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.usermanagement.util.AdminPreparer;
import org.lamsfoundation.lams.usermanagement.web.OrganisationActionForm;
import org.lamsfoundation.lams.web.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OrganisationAction
extends Action {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$usermanagement$web$OrganisationAction == null ? (class$org$lamsfoundation$lams$usermanagement$web$OrganisationAction = OrganisationAction.class$("org.lamsfoundation.lams.usermanagement.web.OrganisationAction")) : class$org$lamsfoundation$lams$usermanagement$web$OrganisationAction));
    private static WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
    private static UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
    static /* synthetic */ Class class$org$lamsfoundation$lams$usermanagement$web$OrganisationAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors = new ActionErrors();
        log.debug((Object)("Form type is " + form.getClass().toString()));
        log.debug((Object)("Form is " + form.toString()));
        OrganisationActionForm orgForm = (OrganisationActionForm)form;
        Organisation org = null;
        if (this.isCancelled(request)) {
            org = orgForm.getOrgId() != -1 ? service.getOrganisationById(orgForm.getOrgId()) : service.getOrganisationById(orgForm.getParentOrgId());
            AdminPreparer.prepare(org, request, service);
            request.getSession(true).removeAttribute("OrganisationActionForm");
            return mapping.findForward("admin");
        }
        if (errors.isEmpty()) {
            log.debug((Object)("Call update organisation, based on form data " + (Object)((Object)orgForm)));
            try {
                if (orgForm.getOrgId() != -1) {
                    org = service.getOrganisationById(orgForm.getOrgId());
                    org.setName(orgForm.getName());
                    org.setDescription(orgForm.getDescription());
                    service.saveOrUpdateOrganisation(org);
                } else {
                    org = new Organisation();
                    org.setName(orgForm.getName());
                    org.setDescription(orgForm.getDescription());
                    Organisation parentOrg = service.getOrganisationById(orgForm.getParentOrgId());
                    org.setParentOrganisation(parentOrg);
                    org.setCreateDate(new Date());
                    OrganisationType orgType = parentOrg.getOrganisationType().getName().equals("ROOT ORGANISATION") ? service.getOrganisationTypeByName("BASE ORGANISATION") : service.getOrganisationTypeByName("SUB-ORGANISATION");
                    org.setOrganisationType(orgType);
                    service.saveOrUpdateOrganisation(org);
                    UserOrganisation userOrg = new UserOrganisation();
                    User user = service.getUserByLogin(request.getRemoteUser());
                    userOrg.setUser(user);
                    userOrg.setOrganisation(org);
                    service.saveOrUpdateUserOrganisation(userOrg);
                    UserOrganisationRole userOrgRole = new UserOrganisationRole();
                    userOrgRole.setUserOrganisation(userOrg);
                    userOrgRole.setRole(service.getRoleByName("ADMIN"));
                    service.saveOrUpdateUserOrganisationRole(userOrgRole);
                }
                AdminPreparer.prepare(org, request, service);
            }
            catch (Exception e) {
                log.error((Object)"Exception happened when getOrganisationEdit", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            if (mapping.getInput() != null) {
                return new ActionForward(mapping.getInput());
            }
            return mapping.findForward("error");
        }
        return mapping.findForward("admin");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

