/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.lamsfoundation.lams.util.XmlFileLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static final String CONFIG_FILE_PATH_WINDOWS = "c:/lamsconf/lams.xml";
    private static final String CONFIG_FILE_PATH_UNIX = "/usr/local/lamsconf/lams.xml";
    private static String configFilePath;

    public static String getConfigFilePath() {
        ConfigurationLoader.setConfigFilePath();
        return configFilePath;
    }

    private static void setConfigFilePath() {
        String osName = System.getProperty("os.name");
        configFilePath = osName.indexOf("Windows") != -1 || osName.indexOf("windows") != -1 ? CONFIG_FILE_PATH_WINDOWS : CONFIG_FILE_PATH_UNIX;
    }

    public static Map load() {
        ConfigurationLoader.setConfigFilePath();
        Map<String, String> items = Collections.synchronizedMap(new HashMap());
        try {
            Document configureDoc = XmlFileLoader.getDocumentFromFilePath(configFilePath);
            Element root = (Element)configureDoc.getElementsByTagName("Lams").item(0);
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element ele;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (ele = (Element)node).getLastChild() == null) continue;
                items.put(ele.getNodeName(), ele.getLastChild().getNodeValue());
            }
        }
        catch (IOException e) {
            System.out.println("===>IOExcpetion in ConfigurationLoader " + e);
        }
        catch (SAXException e) {
            System.out.println("===>SAXExcpetion in ConfigurationLoader " + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("===>ParserConfigurationException in ConfigurationLoader " + e);
        }
        return items;
    }
}

