/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.util.WebUtil;
import servletunit.HttpServletRequestSimulator;
import servletunit.struts.MockStrutsTestCase;

public class TestWebUtil
extends MockStrutsTestCase {
    HttpServletRequestSimulator req;
    HttpSession session;

    protected void setUp() throws Exception {
        super.setUp();
        this.req = (HttpServletRequestSimulator)this.getRequest();
        this.session = this.getSession();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestWebUtil(String string) {
        super(string);
    }

    public void testReadToolAccessModeParam() {
        this.addRequestParameter("mode", ToolAccessMode.LEARNER.toString());
        ToolAccessMode toolAccessMode = WebUtil.readToolAccessModeParam((HttpServletRequest)this.req, "mode", false);
        TestWebUtil.assertTrue((String)"Validating the reading of tool access mode", (toolAccessMode == ToolAccessMode.LEARNER ? 1 : 0) != 0);
    }

    public void testReadIllegalToolAccessModeParam() {
        this.addRequestParameter("mode", "IllegalMode");
        try {
            ToolAccessMode toolAccessMode = WebUtil.readToolAccessModeParam((HttpServletRequest)this.req, "mode", false);
            TestWebUtil.fail((String)"IllegalArgumentException expected");
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof IllegalArgumentException) {
                TestWebUtil.assertTrue((boolean)true);
            }
            TestWebUtil.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testReadNullToolAccessModeParam() {
        try {
            ToolAccessMode toolAccessMode = WebUtil.readToolAccessModeParam((HttpServletRequest)this.req, "mode", false);
            TestWebUtil.fail((String)"IllegalArgumentException expected");
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof IllegalArgumentException) {
                TestWebUtil.assertTrue((boolean)true);
            }
            TestWebUtil.fail((String)"IllegalArgumentException expected");
        }
    }
}

