/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;

public class WebUtil {
    public static final String CURRENT_TASK_ID = "currentTaskId";
    public static final String COMPLETED_TASK_ID = "completedTaskId";
    public static final String TASK_TO_DISPLAY = "tasktodisplay";
    public static final String SEQUENCE_COMPLETED = "sequenceCompleted";
    public static final String REFRESH_PROGRESS_DATA = "refresh";
    public static final String IS_REUSABLE = "isReusable";
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$util$WebUtil == null ? (class$org$lamsfoundation$lams$util$WebUtil = WebUtil.class$("org.lamsfoundation.lams.util.WebUtil")) : class$org$lamsfoundation$lams$util$WebUtil));
    static /* synthetic */ Class class$org$lamsfoundation$lams$util$WebUtil;

    public static boolean isTokenValid(HttpServletRequest req, String tokenName) {
        if (req.getSession() != null) {
            String valueSession = (String)req.getSession().getAttribute(tokenName);
            String valueRequest = req.getParameter(tokenName);
            log.debug((Object)("(Session Token) name : " + tokenName + " value : " + valueSession));
            log.debug((Object)("(Request Token) name : " + tokenName + " value : " + valueRequest));
            if (valueSession != null && valueRequest != null && valueSession.equals(valueRequest)) {
                return true;
            }
        }
        return false;
    }

    public static void saveTaskURL(HttpServletRequest req, String[] urls) {
        if (urls != null) {
            if (urls.length == 1) {
                req.setAttribute("urlA", (Object)urls[0]);
            } else if (urls.length == 2) {
                req.setAttribute("urlA", (Object)urls[0]);
                req.setAttribute("urlB", (Object)urls[1]);
            }
        }
    }

    public static void setRefresh(HttpServletRequest req, boolean refreshValue) {
        req.getSession().setAttribute(REFRESH_PROGRESS_DATA, (Object)Boolean.toString(refreshValue));
    }

    public static void initTaskAttributes(HttpServletRequest req) {
        req.getSession().setAttribute(CURRENT_TASK_ID, (Object)"-1");
        req.getSession().setAttribute(COMPLETED_TASK_ID, (Object)"-1");
        req.getSession().setAttribute(TASK_TO_DISPLAY, null);
        req.getSession().setAttribute(SEQUENCE_COMPLETED, (Object)"false");
        req.getSession().setAttribute(REFRESH_PROGRESS_DATA, (Object)"false");
        req.getSession().setAttribute(IS_REUSABLE, (Object)"false");
    }

    public static void saveToken(HttpServletRequest req, String tokenName, String tokenValue) {
        if (req.getSession().getAttribute(tokenName) != null) {
            WebUtil.resetToken(req, tokenName);
        }
        req.getSession().setAttribute(tokenName, (Object)tokenValue);
        log.debug((Object)("(Save Session Token) name : " + tokenName + " value : " + tokenValue));
    }

    public static String retrieveToken(HttpServletRequest req, String tokenName) {
        return (String)req.getSession().getAttribute(tokenName);
    }

    public static void resetToken(HttpServletRequest req, String tokenName) {
        req.getSession().removeAttribute(tokenName);
    }

    public static void checkString(String paramName, String paramValue) throws IllegalArgumentException {
        if (paramValue == null || paramValue.length() < 1) {
            throw new IllegalArgumentException(paramName + " is required '" + paramValue + "'");
        }
    }

    public static int checkInteger(String paramName, String paramValue) throws IllegalArgumentException {
        try {
            WebUtil.checkString(paramName, paramValue);
            return Integer.parseInt(paramValue.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be an integer '" + paramValue + "'");
        }
    }

    public static long checkLong(String paramName, String paramValue) throws IllegalArgumentException {
        try {
            WebUtil.checkString(paramName, paramValue);
            return Long.parseLong(paramValue.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be a long '" + paramValue + "'");
        }
    }

    public static boolean checkBoolean(String paramName, String paramValue) throws IllegalArgumentException {
        WebUtil.checkString(paramName, paramValue);
        return Boolean.valueOf(paramValue.trim());
    }

    public static int readIntParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkInteger(paramName, req.getParameter(paramName));
    }

    public static int readIntParamFromUserSession(HttpServletRequest req, String paramName) {
        HttpSession session = req.getSession();
        if (session.getAttribute(paramName) != null) {
            return WebUtil.checkInteger(paramName, String.valueOf((Integer)session.getAttribute(paramName)));
        }
        return -1;
    }

    public static long readLongParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkLong(paramName, req.getParameter(paramName));
    }

    public static String readStrParam(HttpServletRequest req, String paramName) {
        return WebUtil.readStrParam(req, paramName, false);
    }

    public static String readStrParam(HttpServletRequest req, String paramName, boolean isOptional) {
        if (!isOptional) {
            WebUtil.checkString(paramName, req.getParameter(paramName));
        }
        return req.getParameter(paramName);
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName) throws IllegalArgumentException {
        return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName, boolean defaultValue) {
        try {
            return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static String getUsername(HttpServletRequest req) throws RuntimeException {
        Principal prin = req.getUserPrincipal();
        if (prin == null) {
            throw new RuntimeException("Trying to get username but principal object missing. Request is " + req.toString());
        }
        String username = prin.getName();
        if (username == null) {
            throw new RuntimeException("Name missing from principal object. Request is " + req.toString() + " Principal object is " + ((Object)prin).toString());
        }
        return username;
    }

    public static ToolAccessMode readToolAccessModeParam(HttpServletRequest request, String param_mode, boolean optional) {
        String mode = WebUtil.readStrParam(request, param_mode, optional);
        if (mode.equals(ToolAccessMode.AUTHOR.toString())) {
            return ToolAccessMode.AUTHOR;
        }
        if (mode.equals(ToolAccessMode.LEARNER.toString())) {
            return ToolAccessMode.LEARNER;
        }
        if (mode.equals(ToolAccessMode.TEACHER.toString())) {
            return ToolAccessMode.TEACHER;
        }
        throw new IllegalArgumentException("[" + mode + "] is not a legal mode" + "in LAMS");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

