/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.cache;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import org.apache.log4j.Logger;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.lamsfoundation.lams.cache.CacheDebugListener;
import org.lamsfoundation.lams.cache.ICacheManager;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class CacheManager
implements ICacheManager {
    protected Logger log = Logger.getLogger(CacheManager.class);
    private String DEFAULT_CACHE_OBJECT_NAME = "jboss.cache:service=TreeCache";
    private String cacheObjectName = null;
    private TreeCacheMBean treeCache = null;
    private TreeCacheListener listener = null;

    private TreeCacheMBean getCache() {
        if (this.treeCache == null) {
            try {
                if (this.cacheObjectName == null) {
                    this.cacheObjectName = this.DEFAULT_CACHE_OBJECT_NAME;
                }
                MBeanServer server = MBeanServerLocator.locate();
                this.treeCache = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (String)this.cacheObjectName, (MBeanServer)server);
                if (Configuration.getAsBoolean(ConfigurationKeys.USE_CACHE_DEBUG_LISTENER)) {
                    if (this.listener != null) {
                        this.treeCache.removeTreeCacheListener(this.listener);
                    }
                    this.listener = new CacheDebugListener();
                    this.treeCache.addTreeCacheListener(this.listener);
                    this.log.info((Object)"Added tree cache listener.");
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to access the JBOSS cache mbean " + this.cacheObjectName + ". Cache not available."), (Throwable)e);
            }
        }
        return this.treeCache;
    }

    public String[] getPartsFromClass(Class clasz) {
        return clasz.getName().split("\\.");
    }

    private Fqn getFqn(Class clasz) {
        return new Fqn((Object[])this.getPartsFromClass(clasz));
    }

    private Fqn getFqn(String[] classNameParts) {
        return new Fqn((Object[])classNameParts);
    }

    public Object getItem(String[] classNameParts, Object key) {
        if (key == null || classNameParts == null) {
            return null;
        }
        return this.getItem(this.getFqn(classNameParts), key);
    }

    public Object getItem(Class clasz, Object key) {
        if (key == null || clasz == null) {
            return null;
        }
        return this.getItem(this.getFqn(clasz), key);
    }

    private Object getItem(Fqn fqn, Object key) {
        TreeCacheMBean cache = this.getCache();
        if (cache == null) {
            this.log.error((Object)("Unable to get item with fqn " + fqn + " key " + key + " as we can't get the JBOSS Cache mbean."));
            return null;
        }
        Object obj = null;
        try {
            obj = cache.get(fqn, key);
            if (obj != null) {
                this.log.debug((Object)("Retrieved object from cache fqn " + fqn + " key " + key));
            }
        }
        catch (CacheException e) {
            this.log.error((Object)("JBOSS Cache exception occured getting object from cache. fqn " + fqn + " key " + key), (Throwable)e);
        }
        return obj;
    }

    public void addItem(String[] classNameParts, Object key, Object item) {
        if (item != null && key != null && classNameParts != null) {
            this.addItem(this.getFqn(classNameParts), key, item);
        }
    }

    public void addItem(Class clasz, Object key, Object item) {
        if (item != null && key != null && clasz != null) {
            this.addItem(this.getFqn(clasz), key, item);
        }
    }

    private void addItem(Fqn fqn, Object key, Object item) {
        TreeCacheMBean cache = this.getCache();
        if (cache == null) {
            this.log.error((Object)("Unable to get cache item with fqn " + fqn + " key " + key + " as we can't get the JBOSS Cache mbean."));
            return;
        }
        try {
            cache.put(fqn, key, item);
        }
        catch (CacheException e) {
            this.log.error((Object)("JBOSS Cache exception occured putting object in cache. fqn " + fqn + " key " + key), (Throwable)e);
        }
    }

    public Map getCachedItems() {
        TreeCacheMBean cache = this.getCache();
        TreeMap allChildNames = new TreeMap();
        if (cache == null) {
            this.log.error((Object)"Unable to get cache items as we can't get the JBOSS Cache mbean.");
        } else {
            this.addChildren("/", cache, allChildNames);
        }
        return allChildNames;
    }

    private void addChildren(String node, TreeCacheMBean cache, Map allChildNames) {
        try {
            Set childNames = cache.getChildrenNames(node);
            if (childNames != null) {
                allChildNames.put(node, childNames);
                for (String childNode : childNames) {
                    if (node.endsWith("/")) {
                        this.addChildren(node + childNode, cache, allChildNames);
                        continue;
                    }
                    this.addChildren(node + "/" + childNode, cache, allChildNames);
                }
            }
        }
        catch (CacheException e) {
            this.log.error((Object)"JBOSS Cache exception occured getting child names from cache", (Throwable)e);
        }
    }

    public void clearCache(String node) {
        TreeCacheMBean cache = this.getCache();
        if (cache == null) {
            this.log.error((Object)"Unable to clear cache items as we can't get the JBOSS Cache mbean.");
        } else {
            try {
                cache.remove(node);
            }
            catch (CacheException e) {
                this.log.error((Object)"JBOSS Cache exception occured getting child names from cache", (Throwable)e);
            }
        }
    }

    public String getCacheObjectName() {
        return this.cacheObjectName;
    }

    public void setCacheObjectName(String cacheObjectName) {
        this.cacheObjectName = cacheObjectName;
    }
}

