/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.BaseDAO;
import org.springframework.dao.DataRetrievalFailureException;

public class ActivityDAO
extends BaseDAO
implements IActivityDAO {
    private static final String TABLENAME = "lams_learning_activity";
    private static final String FIND_BY_PARENT = "from lams_learning_activity in class " + Activity.class.getName() + " where parent_activity_id=?";
    private static final String FIND_BY_LEARNING_DESIGN_ID = "from lams_learning_activity in class " + Activity.class.getName() + " where learning_design_id=?";
    private static final String FIND_BY_UI_ID = "from lams_learning_activity in class " + Activity.class.getName() + " where activity_ui_id=?" + " AND " + " learning_design_id=?";
    private static final String FIND_BY_LIBRARY_ID = "from lams_learning_activity in class " + Activity.class.getName() + " where learning_library_id=?" + " AND learning_design_id IS NULL";

    public Activity getActivityByActivityId(Long activityId) {
        Activity act = (Activity)super.find(Activity.class, activityId);
        return this.getNonCGLibActivity(act);
    }

    private Activity getNonCGLibActivity(Activity act) {
        if (act != null) {
            Integer activityType = act.getActivityTypeId();
            Long activityId = act.getActivityId();
            if (activityType != null) {
                switch (activityType) {
                    case 1: {
                        return this.getActivityByActivityId(activityId, ToolActivity.class);
                    }
                    case 2: {
                        return this.getActivityByActivityId(activityId, GroupingActivity.class);
                    }
                    case 3: {
                        return this.getActivityByActivityId(activityId, SynchGateActivity.class);
                    }
                    case 4: {
                        return this.getActivityByActivityId(activityId, ScheduleGateActivity.class);
                    }
                    case 5: {
                        return this.getActivityByActivityId(activityId, PermissionGateActivity.class);
                    }
                    case 6: {
                        return this.getActivityByActivityId(activityId, ParallelActivity.class);
                    }
                    case 7: {
                        return this.getActivityByActivityId(activityId, OptionsActivity.class);
                    }
                    case 8: {
                        return this.getActivityByActivityId(activityId, SequenceActivity.class);
                    }
                }
            }
            throw new DataRetrievalFailureException("Unable to get activity as the activity type is unknown or missing. Activity type is " + activityType);
        }
        return null;
    }

    public Activity getActivityByActivityId(Long activityId, Class clasz) {
        return (Activity)super.find(clasz, activityId);
    }

    public List getActivitiesByParentActivityId(Long parentActivityId) {
        List list = this.getHibernateTemplate().find(FIND_BY_PARENT, (Object)parentActivityId);
        return list;
    }

    public List getAllActivities() {
        return super.findAll(Activity.class);
    }

    public List getActivitiesByLearningDesignId(Long learningDesignId) {
        return this.getHibernateTemplate().find(FIND_BY_LEARNING_DESIGN_ID, (Object)learningDesignId);
    }

    public void insertActivity(Activity activity) {
        this.getHibernateTemplate().save((Object)activity);
    }

    public void insertOptActivity(OptionsActivity activity) {
        this.getHibernateTemplate().save((Object)activity);
    }

    public void updateActivity(Activity activity) {
        this.getHibernateTemplate().update((Object)activity);
    }

    public void deleteActivity(Activity activity) {
        this.getHibernateTemplate().delete((Object)activity);
    }

    public Activity getActivityByUIID(Integer id, LearningDesign design) {
        if (id != null && design != null) {
            Long designID = design.getLearningDesignId();
            Query query = this.getSession().createQuery(FIND_BY_UI_ID);
            query.setInteger(0, id.intValue());
            query.setLong(1, designID.longValue());
            return this.getNonCGLibActivity((Activity)query.uniqueResult());
        }
        return null;
    }

    public List getActivitiesByLibraryID(Long libraryID) {
        List list = this.getHibernateTemplate().find(FIND_BY_LIBRARY_ID, (Object)libraryID);
        return list;
    }

    public Activity getTemplateActivityByLibraryID(Long libraryID) {
        List list = this.getHibernateTemplate().find(FIND_BY_LIBRARY_ID, (Object)libraryID);
        return list != null && list.size() != 0 ? (Activity)list.get(0) : null;
    }
}

