/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.BaseDAO;

public class LearningDesignDAO
extends BaseDAO
implements ILearningDesignDAO {
    private static final String TABLENAME = "lams_learning_design";
    private static final String FIND_BY_USERID = "from lams_learning_design in class " + LearningDesign.class.getName() + " where user_id =?";
    private static final String VALID_IN_FOLDER = "from lams_learning_design in class " + LearningDesign.class.getName() + " where valid_design_flag=true AND workspace_folder_id=?";
    private static final String ALL_IN_FOLDER = "from lams_learning_design in class " + LearningDesign.class.getName() + " where workspace_folder_id=?";
    private static final String FIND_BY_ORIGINAL = "from lams_learning_design in class " + LearningDesign.class.getName() + " where original_learning_design_id=?";

    public LearningDesign getLearningDesignById(Long learningDesignId) {
        return (LearningDesign)super.find(LearningDesign.class, learningDesignId);
    }

    public LearningDesign getLearningDesignByTitle(String title) {
        return (LearningDesign)super.find(LearningDesign.class, (Serializable)((Object)title));
    }

    public List getAllLearningDesigns() {
        return super.findAll(LearningDesign.class);
    }

    public List getLearningDesignByUserId(Long userID) {
        if (userID != null) {
            try {
                Query query = this.getSession().createQuery(FIND_BY_USERID);
                query.setLong(0, userID.longValue());
                return query.list();
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
        }
        return null;
    }

    public List getAllValidLearningDesignsInFolder(Integer workspaceFolderID) {
        return this.getHibernateTemplate().find(VALID_IN_FOLDER, (Object)workspaceFolderID);
    }

    public List getAllLearningDesignsInFolder(Integer workspaceFolderID) {
        return this.getHibernateTemplate().find(ALL_IN_FOLDER, (Object)workspaceFolderID);
    }

    public List getLearningDesignsByOriginalDesign(Long originalDesignID) {
        List list = this.getHibernateTemplate().find(FIND_BY_ORIGINAL, (Object)originalDesignID);
        return list;
    }
}

