/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class LearningDesignDTO
extends BaseDTO {
    private Long learningDesignID;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Long firstActivityID;
    private Integer firstActivityUIID;
    private Integer maxID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Date dateReadOnly;
    private Integer userID;
    private String helpText;
    private Integer copyTypeID;
    private Date createDateTime;
    private String version;
    private Long originalLearningDesignID;
    private Integer workspaceFolderID;
    private Long duration;
    private String licenseText;
    private Long licenseID;
    private Long lessonOrgID;
    private String lessonOrgName;
    private Long lessonID;
    private String lessonName;
    private Date lessonStartDateTime;
    private Date lastModifiedDateTime;
    private String offlineInstructions;
    private String onlineInstructions;
    private ArrayList groupings;
    private ArrayList activities;
    private ArrayList transitions;

    public LearningDesignDTO() {
    }

    public LearningDesignDTO(Long learningDesignId, Integer learningDesignUIID, String description, String title, Long firstActivityID, Integer firstActivityUIID, Integer maxId, Boolean validDesign, Boolean readOnly, Date dateReadOnly, Integer userID, String helpText, Integer copyTypeID, Date createDateTime, String version, Long originalLearningDesignID, Integer workspaceFolderID, Long duration, String licenseText, Long licenseID, Long lessonOrgID, String lessonOrgName, Long lessonID, String lessonName, Date lessonStartDateTime, Date lastModifiedDateTime, String offlineInstructions, String onlineInstructions) {
        this.learningDesignID = learningDesignId;
        this.learningDesignUIID = learningDesignUIID;
        this.description = description;
        this.title = title;
        this.firstActivityID = firstActivityID;
        this.firstActivityUIID = firstActivityUIID;
        this.maxID = maxId;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.offlineInstructions = offlineInstructions;
        this.onlineInstructions = onlineInstructions;
        this.userID = userID;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime;
        this.version = version;
        this.originalLearningDesignID = originalLearningDesignID;
        this.workspaceFolderID = workspaceFolderID;
        this.duration = duration;
        this.licenseText = licenseText;
        this.licenseID = licenseID;
        this.lessonOrgID = lessonOrgID;
        this.lessonOrgName = lessonOrgName;
        this.lessonID = lessonID;
        this.lessonName = lessonName;
        this.lessonStartDateTime = lessonStartDateTime;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.groupings = new ArrayList();
        this.activities = new ArrayList();
        this.transitions = new ArrayList();
    }

    public LearningDesignDTO(LearningDesign learningDesign) {
        this.learningDesignID = learningDesign.getLearningDesignId();
        this.learningDesignUIID = learningDesign.getLearningDesignUIID();
        this.description = learningDesign.getDescription();
        this.title = learningDesign.getTitle();
        this.firstActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : null;
        this.firstActivityUIID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityUIID() : null;
        this.maxID = learningDesign.getMaxID();
        this.validDesign = learningDesign.getValidDesign();
        this.readOnly = learningDesign.getReadOnly();
        this.dateReadOnly = learningDesign.getDateReadOnly();
        this.offlineInstructions = learningDesign.getOfflineInstructions();
        this.onlineInstructions = learningDesign.getOnlineInstructions();
        this.userID = learningDesign.getUser() != null ? learningDesign.getUser().getUserId() : null;
        this.helpText = learningDesign.getHelpText();
        this.copyTypeID = learningDesign.getCopyTypeID();
        this.createDateTime = learningDesign.getCreateDateTime();
        this.version = learningDesign.getVersion();
        this.originalLearningDesignID = learningDesign.getOriginalLearningDesign() != null ? learningDesign.getOriginalLearningDesign().getLearningDesignId() : null;
        this.workspaceFolderID = learningDesign.getWorkspaceFolder() != null ? learningDesign.getWorkspaceFolder().getWorkspaceFolderId() : null;
        this.duration = learningDesign.getDuration();
        this.licenseText = learningDesign.getLicenseText();
        this.licenseID = learningDesign.getLicense() != null ? learningDesign.getLicense().getLicenseID() : null;
        this.lessonOrgID = learningDesign.getLessonOrgID();
        this.lessonOrgName = learningDesign.getLessonOrgName();
        this.lessonID = learningDesign.getLessonID();
        this.lessonName = learningDesign.getLessonName();
        this.lessonStartDateTime = learningDesign.getLessonStartDateTime();
        this.lastModifiedDateTime = learningDesign.getLastModifiedDateTime();
        this.groupings = this.populateGroupings(learningDesign);
        this.activities = this.populateActivities(learningDesign);
        this.transitions = this.populateTransitions(learningDesign);
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getFirstActivityID() {
        return this.firstActivityID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID;
    }

    public Long getLessonID() {
        return this.lessonID;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public Long getLessonOrgID() {
        return this.lessonOrgID;
    }

    public String getLessonOrgName() {
        return this.lessonOrgName;
    }

    public Date getLessonStartDateTime() {
        return this.lessonStartDateTime;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public Integer getMaxID() {
        return this.maxID;
    }

    public Long getOriginalLearningDesignID() {
        return this.originalLearningDesignID;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getUserID() {
        return this.userID;
    }

    public Boolean getValidDesign() {
        return this.validDesign;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID;
    }

    public ArrayList getActivities() {
        return this.activities;
    }

    public ArrayList populateGroupings(LearningDesign design) {
        ArrayList<GroupingDTO> groupingList = new ArrayList<GroupingDTO>();
        for (Activity object : design.getParentActivities()) {
            if (!object.isGroupingActivity()) continue;
            GroupingActivity groupingActivity = (GroupingActivity)object;
            Grouping grouping = groupingActivity.getCreateGrouping();
            groupingList.add(grouping.getGroupingDTO());
        }
        return groupingList;
    }

    public ArrayList populateActivities(LearningDesign design) {
        ArrayList activities = new ArrayList();
        for (Activity object : design.getParentActivities()) {
            if (object.isComplexActivity()) {
                Set dtoSet = object.getAuthoringActivityDTOSet();
                activities.addAll(dtoSet);
                continue;
            }
            activities.addAll(object.getAuthoringActivityDTOSet());
        }
        return activities;
    }

    public ArrayList populateTransitions(LearningDesign design) {
        ArrayList<TransitionDTO> transitions = new ArrayList<TransitionDTO>();
        if (design.getTransitions() != null) {
            for (Transition trans : design.getTransitions()) {
                transitions.add(trans.getTransitionDTO());
            }
        }
        return transitions;
    }

    public ArrayList getTransitions() {
        return this.transitions;
    }

    public void setActivities(ArrayList activities) {
        this.activities = activities;
    }

    public void setCopyTypeID(Integer copyTypeID) {
        this.copyTypeID = copyTypeID;
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setDateReadOnly(Date dateReadOnly) {
        if (!dateReadOnly.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.dateReadOnly = dateReadOnly;
        }
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setDuration(Long duration) {
        if (!duration.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.duration = duration;
        }
    }

    public void setFirstActivityID(Long firstActivityID) {
        if (!firstActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.firstActivityID = firstActivityID;
        }
    }

    public void setHelpText(String helpText) {
        if (!helpText.equals("string_null_value")) {
            this.helpText = helpText;
        }
    }

    public void setLastModifiedDateTime(Date lastModifiedDateTime) {
        if (!lastModifiedDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }
    }

    public void setLearningDesignID(Long learningDesignId) {
        if (!learningDesignId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignID = learningDesignId;
        }
    }

    public void setLearningDesignUIID(Integer learningDesignUIID) {
        if (!learningDesignUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.learningDesignUIID = learningDesignUIID;
        }
    }

    public void setLessonID(Long lessonID) {
        if (!lessonID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.lessonID = lessonID;
        }
    }

    public void setLessonName(String lessonName) {
        if (!lessonName.equals("string_null_value")) {
            this.lessonName = lessonName;
        }
    }

    public void setLessonOrgID(Long lessonOrgID) {
        if (!lessonOrgID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.lessonOrgID = lessonOrgID;
        }
    }

    public void setLessonOrgName(String lessonOrgName) {
        if (!lessonOrgName.equals("string_null_value")) {
            this.lessonOrgName = lessonOrgName;
        }
    }

    public void setLessonStartDateTime(Date lessonStartDateTime) {
        if (!lessonStartDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.lessonStartDateTime = lessonStartDateTime;
        }
    }

    public void setLicenseID(Long licenseID) {
        if (!licenseID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.licenseID = licenseID;
        }
    }

    public void setLicenseText(String licenseText) {
        if (!licenseText.equals("string_null_value")) {
            this.licenseText = licenseText;
        }
    }

    public void setMaxID(Integer maxID) {
        if (!maxID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxID = maxID;
        }
    }

    public void setOriginalLearningDesignID(Long originalLearningDesignID) {
        if (!originalLearningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.originalLearningDesignID = originalLearningDesignID;
        }
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.title = title;
        }
    }

    public void setTransitions(ArrayList transitions) {
        this.transitions = transitions;
    }

    public void setUserID(Integer userID) {
        if (!userID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.userID = userID;
        }
    }

    public void setValidDesign(Boolean validDesign) {
        this.validDesign = validDesign;
    }

    public void setVersion(String version) {
        if (!version.equals("string_null_value")) {
            this.version = version;
        }
    }

    public void setWorkspaceFolderID(Integer workspaceFolderID) {
        if (!workspaceFolderID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.workspaceFolderID = workspaceFolderID;
        }
    }

    public Integer getFirstActivityUIID() {
        return this.firstActivityUIID;
    }

    public void setFirstActivityUIID(Integer firstActivityUIID) {
        if (!firstActivityUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.firstActivityUIID = firstActivityUIID;
        }
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        if (!onlineInstructions.equals("string_null_value")) {
            this.onlineInstructions = onlineInstructions;
        }
    }

    public void setOfflineInstructions(String offlineInstructions) {
        if (!offlineInstructions.equals("string_null_value")) {
            this.offlineInstructions = offlineInstructions;
        }
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public ArrayList getGroupings() {
        return this.groupings;
    }

    public void setGroupings(ArrayList groupings) {
        this.groupings = groupings;
    }
}

