/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;

public class MonitoringActivityDTO {
    private String title;
    private String description;
    private Long activityID;
    private Integer activityTypeID;
    private Integer orderID;
    private Integer contributionType;
    private Boolean isRequired;

    public MonitoringActivityDTO() {
    }

    public MonitoringActivityDTO(Activity activity, Integer contributionType) {
        this.title = activity.getTitle();
        this.description = activity.getDescription();
        this.activityID = activity.getActivityId();
        this.activityTypeID = activity.getActivityTypeId();
        this.contributionType = contributionType;
        this.orderID = activity.getOrderId();
        this.isRequired = new Boolean(this.calculateIsRequired(contributionType));
    }

    private boolean calculateIsRequired(Integer contributionType) {
        return contributionType != null && contributionType.equals(SimpleActivityStrategy.DEFINE_LATER) || contributionType.equals(SimpleActivityStrategy.PERMISSION_GATE) || contributionType.equals(SimpleActivityStrategy.CHOSEN_GROUPING);
    }

    public Long getActivityID() {
        return this.activityID;
    }

    public Integer getActivityTypeID() {
        return this.activityTypeID;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getOrderID() {
        return this.orderID;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getContributionType() {
        return this.contributionType;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }
}

