/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.util.Set;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.util.MessageService;

public class LearningDesignService
implements ILearningDesignService {
    protected MessageService messageService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public Vector validateLearningDesign(LearningDesign learningDesign) {
        Vector listOfValidationErrorDTOs = new Vector();
        this.validateActivityTransitionRules(learningDesign.getParentActivities(), learningDesign.getTransitions(), listOfValidationErrorDTOs);
        this.validateGeneral(learningDesign.getActivities(), listOfValidationErrorDTOs);
        return listOfValidationErrorDTOs;
    }

    private void validateActivityTransitionRules(Set topLevelActivities, Set transitions, Vector listOfValidationErrorDTOs) {
        this.validateTransitions(transitions, listOfValidationErrorDTOs);
        Vector<Activity> noInputTransition = new Vector<Activity>();
        Vector<Activity> noOuputTransition = new Vector<Activity>();
        int numOfTopLevelActivities = topLevelActivities.size();
        for (Activity activity : topLevelActivities) {
            this.checkActivityForTransition(activity, numOfTopLevelActivities, listOfValidationErrorDTOs);
            if (activity.getTransitionFrom() == null) {
                noOuputTransition.add(activity);
            }
            if (activity.getTransitionTo() != null) continue;
            noInputTransition.add(activity);
        }
        if (numOfTopLevelActivities > 0) {
            if (noInputTransition.size() == 0) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.inputTransitionType2")));
            }
            if (noInputTransition.size() > 1) {
                for (Activity a : noInputTransition) {
                    listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.inputTransitionType1"), a.getActivityUIID()));
                }
            }
            if (noOuputTransition.size() == 0) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.outputTransitionType2")));
            }
            if (noOuputTransition.size() > 1) {
                for (Activity a : noOuputTransition) {
                    listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.outputTransitionType1"), a.getActivityUIID()));
                }
            }
        }
    }

    private void validateTransitions(Set transitions, Vector listOfValidationErrorDTOs) {
        for (Transition transition : transitions) {
            Activity fromActivity = transition.getFromActivity();
            Activity toActivity = transition.getToActivity();
            if (fromActivity == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
                continue;
            }
            if (toActivity != null) continue;
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
        }
    }

    private void checkActivityForTransition(Activity activity, int numOfActivities, Vector listOfValidationErrorDTOs) {
        Transition inputTransition = activity.getTransitionTo();
        Transition outputTransition = activity.getTransitionFrom();
        if (numOfActivities > 1 && inputTransition == null && outputTransition == null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
        if (numOfActivities == 1 && (inputTransition != null || outputTransition != null)) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
    }

    private void validateGeneral(Set activities, Vector listOfValidationErrorDTOs) {
        for (Activity activity : activities) {
            this.checkIfGroupingRequired(activity, listOfValidationErrorDTOs);
            this.validateGroupingIfGroupingIsApplied(activity, listOfValidationErrorDTOs);
            this.validateOptionalActivity(activity, listOfValidationErrorDTOs);
            this.validateOptionsActivityOrderId(activity, listOfValidationErrorDTOs);
            Vector activityErrors = activity.validateActivity(this.messageService);
            if (activityErrors == null || activityErrors.isEmpty()) continue;
            listOfValidationErrorDTOs.addAll(activityErrors);
        }
    }

    private void checkIfGroupingRequired(Activity activity, Vector listOfValidationErrorDTOs) {
        Grouping grouping;
        Integer groupingSupportType = activity.getGroupingSupportType();
        if (groupingSupportType == 3) {
            Grouping grouping2 = activity.getGrouping();
            if (grouping2 == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.GroupingRequired"), activity.getActivityUIID()));
            }
        } else if (groupingSupportType == 1 && (grouping = activity.getGrouping()) != null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.GroupingNotRequired"), activity.getActivityUIID()));
        }
    }

    private void validateOptionalActivity(Activity parentActivity, Vector listOfValidationErrorDTOs) {
        OptionsActivity optionsActivity;
        Set childActivities;
        int numOfChildActivities;
        if (parentActivity.isOptionsActivity() && (numOfChildActivities = (childActivities = (optionsActivity = (OptionsActivity)parentActivity).getActivities()).size()) == 0) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.OptionalActivity"), optionsActivity.getActivityUIID()));
        }
    }

    private void validateOptionsActivityOrderId(Activity parentActivity, Vector listOfValidationErrorDTOs) {
        Long thisActivityId = null;
        Long previousActivityId = null;
        boolean validOrderId = true;
        if (parentActivity.isOptionsActivity()) {
            OptionsActivity optionsActivity = (OptionsActivity)parentActivity;
            Set childActivities = optionsActivity.getActivities();
            for (Activity childActivity : childActivities) {
                thisActivityId = childActivity.getActivityId();
                if (previousActivityId != null) {
                    if (thisActivityId != previousActivityId + 1L) {
                        if (validOrderId) {
                            // empty if block
                        }
                        validOrderId = false;
                    }
                } else if (thisActivityId != 1L) {
                    if (validOrderId) {
                        // empty if block
                    }
                    validOrderId = false;
                }
                previousActivityId = thisActivityId;
            }
            if (!validOrderId) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.OptionalActivityOrderId"), optionsActivity.getActivityUIID()));
            }
        }
    }

    private void validateGroupingIfGroupingIsApplied(Activity activity, Vector listOfValidationErrorDTOs) {
        if (activity.getApplyGrouping().booleanValue() && activity.getGrouping() == null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage(ValidationErrorDTO.GROUPING_SELECTED_ERROR), activity.getActivityUIID()));
        }
    }
}

