/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.dto;

import java.text.ParseException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.themes.CSSProperty;
import org.lamsfoundation.lams.themes.CSSStyle;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class CSSStyleDTO
extends Hashtable {
    protected Logger log = Logger.getLogger(CSSStyleDTO.class);

    public CSSStyleDTO(Hashtable styleHashtable) {
        for (Map.Entry entry : styleHashtable.entrySet()) {
            if (WDDXProcessor.isNull(entry.getValue())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public CSSStyleDTO(CSSStyle styleObject) {
        super.put("_tf", new Hashtable());
        Set properties = styleObject.getProperties();
        if (properties != null && properties.size() > 0) {
            for (CSSProperty element : properties) {
                this.add(element);
            }
        }
    }

    public CSSStyle createNewCSSStyle() {
        CSSStyle style = new CSSStyle();
        if (this.size() > 0) {
            for (Map.Entry element : this.entrySet()) {
                String key = (String)element.getKey();
                Object value = element.getValue();
                if ("_tf".equals(key) && Map.class.isInstance(value)) {
                    this.processTF((Map)value, style);
                    continue;
                }
                CSSProperty property = new CSSProperty(key, value, null);
                style.addProperty(property);
            }
        }
        return style;
    }

    private void processTF(Map tfMap, CSSStyle style) {
        for (Map.Entry element : tfMap.entrySet()) {
            String key = (String)element.getKey();
            Object value = element.getValue();
            CSSProperty property = new CSSProperty(key, value, "_tf");
            style.addProperty(property);
        }
    }

    public void putAll(Map m) {
    }

    public Object put(Object key, Object value) {
        return null;
    }

    public void add(CSSProperty property) {
        try {
            if ("_tf".equals(property.getStyleSubset())) {
                Hashtable tf = (Hashtable)this.get("_tf");
                tf.put(property.getName(), property.getValueAsObject());
            } else {
                super.put(property.getName(), property.getValueAsObject());
            }
        }
        catch (NumberFormatException e) {
            this.log.error((Object)("NumberFormatException thrown processing property " + property + ". Skipping this property"), (Throwable)e);
        }
        catch (ParseException e) {
            this.log.error((Object)("ParseException thrown processing property " + property + ". Skipping this property"), (Throwable)e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("[CSSStyleDTO: ");
        for (Map.Entry element : this.entrySet()) {
            buf.append(element.getKey() + "=" + element.getValue());
        }
        buf.append("]");
        return buf.toString();
    }
}

