/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LamsCoreToolService
implements ILamsCoreToolService,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(LamsCoreToolService.class);
    private ApplicationContext context;
    private IToolSessionDAO toolSessionDAO;
    private ToolContentIDGenerator contentIDGenerator;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    public ToolSession createToolSession(User learner, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        ToolSession toolSession = this.toolSessionDAO.getToolSessionByLearner(learner, activity);
        if (toolSession == null) {
            toolSession = activity.createToolSessionForActivity(learner, lesson);
            this.toolSessionDAO.saveToolSession(toolSession);
            return toolSession;
        }
        return null;
    }

    public Set createToolSessions(Set learners, ToolActivity activity, Lesson lesson) throws LamsToolServiceException {
        Iterator iter = learners.iterator();
        HashSet<ToolSession> newToolSessions = new HashSet<ToolSession>();
        while (iter.hasNext()) {
            User learner = (User)iter.next();
            ToolSession toolSession = this.createToolSession(learner, activity, lesson);
            if (toolSession == null) continue;
            newToolSessions.add(toolSession);
        }
        return newToolSessions;
    }

    public ToolSession getToolSessionByLearner(User learner, Activity activity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, activity);
    }

    public ToolSession getToolSessionById(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    public ToolSession getToolSessionByActivity(User learner, ToolActivity toolActivity) throws LamsToolServiceException {
        return this.toolSessionDAO.getToolSessionByLearner(learner, toolActivity);
    }

    public void notifyToolsToCreateSession(ToolSession toolSession, ToolActivity activity) throws ToolException {
        if (this.isToolOnClasspath(activity)) {
            ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(activity);
            sessionManager.createToolSession(toolSession.getToolSessionId(), toolSession.getToolSessionName(), activity.getToolContentId());
        }
    }

    public Long notifyToolToCopyContent(ToolActivity toolActivity) throws DataMissingException, ToolException {
        Long newToolcontentID = this.contentIDGenerator.getNextToolContentIDFor(toolActivity.getTool());
        if (this.isToolOnClasspath(toolActivity)) {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity);
            contentManager.copyToolContent(toolActivity.getToolContentId(), newToolcontentID);
            if (toolActivity.getDefineLater() != null && toolActivity.getDefineLater().booleanValue()) {
                contentManager.setAsDefineLater(newToolcontentID);
            }
            if (toolActivity.getRunOffline() != null && toolActivity.getRunOffline().booleanValue()) {
                contentManager.setAsRunOffline(newToolcontentID);
            }
        }
        return newToolcontentID;
    }

    public void notifyToolToDeleteContent(ToolActivity toolActivity) throws ToolException {
        if (this.isToolOnClasspath(toolActivity)) {
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(toolActivity);
            contentManager.removeToolContent(toolActivity.getToolContentId(), true);
        }
    }

    public void updateToolSession(ToolSession toolSession) {
        this.toolSessionDAO.updateToolSession(toolSession);
    }

    public List getToolSessionsByLesson(Lesson lesson) {
        return this.toolSessionDAO.getToolSessionsByLesson(lesson);
    }

    public void deleteToolSession(ToolSession toolSession) {
        if (toolSession == null) {
            log.error((Object)"deleteToolSession: unable to delete tool session as tool session is null.");
            return;
        }
        ToolSessionManager sessionManager = (ToolSessionManager)this.findToolService(toolSession.getToolActivity());
        try {
            sessionManager.removeToolSession(toolSession.getToolSessionId());
        }
        catch (DataMissingException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as toolSession does not exist"), (Throwable)e);
        }
        catch (ToolException e) {
            log.error((Object)("Unable to delete tool data for tool session " + toolSession.getToolSessionId() + " as tool threw an exception"), (Throwable)e);
        }
        this.toolSessionDAO.removeToolSession(toolSession);
    }

    public String getLearnerToolURLByMode(ToolActivity activity, User learner, ToolAccessMode accessMode) throws LamsToolServiceException {
        String toolURL = activity.getTool().getLearnerUrl();
        if (accessMode == ToolAccessMode.LEARNER) {
            toolURL = this.appendModeToURL(ToolAccessMode.LEARNER, toolURL);
        } else if (accessMode == ToolAccessMode.TEACHER) {
            toolURL = this.appendModeToURL(ToolAccessMode.TEACHER, toolURL);
            toolURL = this.appendUserIDToURL(learner, toolURL);
        } else if (accessMode == ToolAccessMode.AUTHOR) {
            toolURL = this.appendModeToURL(ToolAccessMode.AUTHOR, toolURL);
        } else {
            throw new LamsToolServiceException("Unknown tool access mode:" + accessMode.toString());
        }
        return this.setupToolURLWithToolSession(activity, learner, toolURL);
    }

    private String appendModeToURL(ToolAccessMode toolAccessMode, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "mode", toolAccessMode.toString());
    }

    private String appendUserIDToURL(User user, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "userID", user.getUserId().toString());
    }

    public String setupToolURLWithToolSession(ToolActivity activity, User learner, String toolURL) throws LamsToolServiceException {
        ToolSession toolSession = this.getToolSessionByActivity(learner, activity);
        if (toolSession == null) {
            String error = "Unable to set up url as session does not exist. Activity " + (activity != null ? activity.getActivityId() + ":" + activity.getTitle() : "null") + " learner " + (learner != null ? learner.getUserId() + ":" + learner.getLogin() : "null");
            log.error((Object)error);
            throw new LamsToolServiceException(error);
        }
        return WebUtil.appendParameterToURL(toolURL, "toolSessionID", toolSession.getToolSessionId().toString());
    }

    public String setupToolURLWithToolContent(ToolActivity activity, String toolURL) {
        return WebUtil.appendParameterToURL(toolURL, "toolContentID", activity.getToolContentId().toString());
    }

    private Object findToolService(ToolActivity toolActivity) {
        return this.context.getBean(toolActivity.getTool().getServiceName());
    }

    private boolean isToolOnClasspath(ToolActivity toolActivity) {
        String serviceName = toolActivity.getTool().getServiceName();
        if (serviceName == null) {
            return false;
        }
        return serviceName.equals("ImscpService") || serviceName.equals("nbService") || serviceName.equals("qaService") || serviceName.equals("mcService") || serviceName.equals("submitFilesService") || serviceName.equals("surveyService") || serviceName.equals("forumService");
    }
}

