/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.filter.LocaleRequestWrapper;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class LocaleFilter
extends OncePerRequestFilter {
    private static final String PREFERRED_LOCALE_KEY = "org.apache.struts.action.LOCALE";

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        HttpSession sharedsession;
        UserDTO user;
        Locale preferredLocale = null;
        if (preferredLocale == null && (user = (UserDTO)(sharedsession = SessionManager.getSession()).getAttribute("user")) != null) {
            String lang = user.getLocaleLanguage();
            String country = user.getLocaleCountry();
            if (!StringUtils.isEmpty((String)lang) && !StringUtils.isEmpty((String)country)) {
                preferredLocale = new Locale(lang, country);
            }
        }
        if ((session = request.getSession(false)) != null) {
            if (preferredLocale == null) {
                preferredLocale = (Locale)session.getAttribute(PREFERRED_LOCALE_KEY);
            } else {
                session.setAttribute(PREFERRED_LOCALE_KEY, preferredLocale);
                Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)preferredLocale);
            }
        }
        if (preferredLocale != null && !(request instanceof LocaleRequestWrapper)) {
            request = new LocaleRequestWrapper((HttpServletRequest)request, preferredLocale);
            LocaleContextHolder.setLocale((Locale)preferredLocale);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        LocaleContextHolder.setLocaleContext(null);
    }
}

