/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

public final class CodecUtil {
    public static final int CODEC_MAGIC = 1071082519;
    public static final int FOOTER_MAGIC = -1071082520;

    private CodecUtil() {
    }

    public static void writeHeader(DataOutput out, String codec, int version) throws IOException {
        BytesRef bytes = new BytesRef(codec);
        if (bytes.length != codec.length() || bytes.length >= 128) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 128 characters in length [got " + codec + "]");
        }
        out.writeInt(1071082519);
        out.writeString(codec);
        out.writeInt(version);
    }

    public static int headerLength(String codec) {
        return 9 + codec.length();
    }

    public static int checkHeader(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        int actualHeader = in.readInt();
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=" + 1071082519 + " (resource: " + in + ")");
        }
        return CodecUtil.checkHeaderNoMagic(in, codec, minVersion, maxVersion);
    }

    public static int checkHeaderNoMagic(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        String actualCodec = in.readString();
        if (!actualCodec.equals(codec)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + actualCodec + " vs expected codec=" + codec + " (resource: " + in + ")");
        }
        int actualVersion = in.readInt();
        if (actualVersion < minVersion) {
            throw new IndexFormatTooOldException(in, actualVersion, minVersion, maxVersion);
        }
        if (actualVersion > maxVersion) {
            throw new IndexFormatTooNewException(in, actualVersion, minVersion, maxVersion);
        }
        return actualVersion;
    }

    public static void writeFooter(IndexOutput out) throws IOException {
        out.writeInt(-1071082520);
        out.writeInt(0);
        out.writeLong(out.getChecksum());
    }

    public static int footerLength() {
        return 16;
    }

    public static long checkFooter(ChecksumIndexInput in) throws IOException {
        CodecUtil.validateFooter(in);
        long actualChecksum = in.getChecksum();
        long expectedChecksum = in.readLong();
        if (expectedChecksum != actualChecksum) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(expectedChecksum) + " actual=" + Long.toHexString(actualChecksum) + " (resource=" + in + ")");
        }
        if (in.getFilePointer() != in.length()) {
            throw new CorruptIndexException("did not read all bytes from file: read " + in.getFilePointer() + " vs size " + in.length() + " (resource: " + in + ")");
        }
        return actualChecksum;
    }

    public static long retrieveChecksum(IndexInput in) throws IOException {
        in.seek(in.length() - (long)CodecUtil.footerLength());
        CodecUtil.validateFooter(in);
        return in.readLong();
    }

    private static void validateFooter(IndexInput in) throws IOException {
        int magic = in.readInt();
        if (magic != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch: actual footer=" + magic + " vs expected footer=" + -1071082520 + " (resource: " + in + ")");
        }
        int algorithmID = in.readInt();
        if (algorithmID != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + algorithmID);
        }
    }

    @Deprecated
    public static void checkEOF(IndexInput in) throws IOException {
        if (in.getFilePointer() != in.length()) {
            throw new CorruptIndexException("did not read all bytes from file: read " + in.getFilePointer() + " vs size " + in.length() + " (resource: " + in + ")");
        }
    }

    public static long checksumEntireFile(IndexInput input) throws IOException {
        IndexInput clone = input.clone();
        clone.seek(0L);
        BufferedChecksumIndexInput in = new BufferedChecksumIndexInput(clone);
        assert (((IndexInput)in).getFilePointer() == 0L);
        in.seek(((IndexInput)in).length() - (long)CodecUtil.footerLength());
        return CodecUtil.checkFooter(in);
    }
}

