/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.LongValues;

public class DirectReader {
    public static LongValues getInstance(RandomAccessInput slice, int bitsPerValue) {
        switch (bitsPerValue) {
            case 1: {
                return new DirectPackedReader1(slice);
            }
            case 2: {
                return new DirectPackedReader2(slice);
            }
            case 4: {
                return new DirectPackedReader4(slice);
            }
            case 8: {
                return new DirectPackedReader8(slice);
            }
            case 12: {
                return new DirectPackedReader12(slice);
            }
            case 16: {
                return new DirectPackedReader16(slice);
            }
            case 20: {
                return new DirectPackedReader20(slice);
            }
            case 24: {
                return new DirectPackedReader24(slice);
            }
            case 28: {
                return new DirectPackedReader28(slice);
            }
            case 32: {
                return new DirectPackedReader32(slice);
            }
            case 40: {
                return new DirectPackedReader40(slice);
            }
            case 48: {
                return new DirectPackedReader48(slice);
            }
            case 56: {
                return new DirectPackedReader56(slice);
            }
            case 64: {
                return new DirectPackedReader64(slice);
            }
        }
        throw new IllegalArgumentException("unsupported bitsPerValue: " + bitsPerValue);
    }

    static final class DirectPackedReader64
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader64(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(index << 3);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader56
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader56(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(index * 7L) >>> 8;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader48
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader48(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(index * 6L) >>> 16;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader40
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader40(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(index * 5L) >>> 24;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader32
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader32(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return (long)this.in.readInt(index << 2) & 0xFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader28
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader28(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * 28L >>> 3;
                int shift = (int)(index + 1L & 1L) << 2;
                return (long)(this.in.readInt(offset) >>> shift) & 0xFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader24
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader24(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readInt(index * 3L) >>> 8;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader20
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader20(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * 20L >>> 3;
                int v = this.in.readInt(offset) >>> 8;
                int shift = (int)(index + 1L & 1L) << 2;
                return v >>> shift & 0xFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader16
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader16(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readShort(index << 1) & 0xFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader12
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader12(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * 12L >>> 3;
                int shift = (int)(index + 1L & 1L) << 2;
                return this.in.readShort(offset) >>> shift & 0xFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader8
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader8(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readByte(index) & 0xFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader4
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader4(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index + 1L & 1L) << 2;
                return this.in.readByte(index >>> 1) >>> shift & 0xF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader2
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader2(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                int shift = 3 - (int)(index & 3L) << 1;
                return this.in.readByte(index >>> 2) >>> shift & 3;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class DirectPackedReader1
    extends LongValues {
        final RandomAccessInput in;

        DirectPackedReader1(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public long get(long index) {
            try {
                int shift = 7 - (int)(index & 7L);
                return this.in.readByte(index >>> 3) >>> shift & 1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

