/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListItemVisitDAO;
import org.lamsfoundation.lams.tool.taskList.dao.hibernate.BaseDAOHibernate;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemVisitLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListItemVisitDAOHibernate
extends BaseDAOHibernate
implements TaskListItemVisitDAO {
    private static final String FIND_BY_ITEM_AND_USER = "from " + TaskListItemVisitLog.class.getName() + " as r where r.user.userId = ? and r.taskListItem.uid=?";
    private static final String FIND_BY_ITEM_BYSESSION = "from " + TaskListItemVisitLog.class.getName() + " as r where r.sessionId = ? and r.taskListItem.uid=?";
    private static final String FIND_TASKS_COMPLETED_COUNT_BY_USER = "select count(*) from " + TaskListItemVisitLog.class.getName() + " as r where r.complete=true and r.sessionId=? and  r.user.userId =?";

    @Override
    public TaskListItemVisitLog getTaskListItemLog(Long itemUid, Long userId) {
        List list = this.getHibernateTemplate().find(FIND_BY_ITEM_AND_USER, new Object[]{userId, itemUid});
        if (list == null || list.size() == 0) {
            return null;
        }
        return (TaskListItemVisitLog)list.get(0);
    }

    @Override
    public int getTasksCompletedCountByUser(Long toolSessionId, Long userUid) {
        List list = this.getHibernateTemplate().find(FIND_TASKS_COMPLETED_COUNT_BY_USER, new Object[]{toolSessionId, userUid});
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public List<TaskListItemVisitLog> getTaskListItemLogBySession(Long sessionId, Long itemUid) {
        return this.getHibernateTemplate().find(FIND_BY_ITEM_BYSESSION, new Object[]{sessionId, itemUid});
    }
}

