/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.taskList.model.TaskListAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListCondition;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItem;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.util.TaskListToolContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskList
implements Cloneable {
    private static final Logger log = Logger.getLogger(TaskList.class);
    private Long uid;
    private Long contentId;
    private String title;
    private String instructions;
    private boolean lockWhenFinished;
    private boolean sequentialOrder;
    private int minimumNumberTasks;
    private boolean allowContributeTasks;
    private boolean monitorVerificationRequired;
    private boolean runOffline;
    private boolean defineLater;
    private boolean contentInUse;
    private String onlineInstructions;
    private String offlineInstructions;
    private Set attachments = new HashSet();
    private Set conditions = new HashSet();
    private Date created;
    private Date updated;
    private TaskListUser createdBy;
    private Set taskListItems = new HashSet();
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private IToolContentHandler toolContentHandler;
    private List<TaskListAttachment> onlineFileList;
    private List<TaskListAttachment> offlineFileList;
    private String minimumNumberTasksErrorStr;

    public static TaskList newInstance(TaskList defaultContent, Long contentId, TaskListToolContentHandler taskListToolContentHandler) {
        TaskList toContent = new TaskList();
        defaultContent.toolContentHandler = taskListToolContentHandler;
        toContent = (TaskList)defaultContent.clone();
        toContent.setContentId(contentId);
        if (toContent.getCreatedBy() != null) {
            toContent.getCreatedBy().setTaskList(toContent);
            Set items = toContent.getTaskListItems();
            for (TaskListItem item : items) {
                item.setCreateBy(toContent.getCreatedBy());
            }
        }
        return toContent;
    }

    public Object clone() {
        TaskList taskList = null;
        try {
            HashSet<Cloneable> set;
            Iterator iter;
            taskList = (TaskList)super.clone();
            taskList.setUid(null);
            if (this.taskListItems != null) {
                iter = this.taskListItems.iterator();
                set = new HashSet<Cloneable>();
                while (iter.hasNext()) {
                    TaskListItem item = (TaskListItem)iter.next();
                    TaskListItem newItem = (TaskListItem)item.clone();
                    set.add(newItem);
                }
                taskList.taskListItems = set;
            }
            if (this.attachments != null) {
                iter = this.attachments.iterator();
                set = new HashSet();
                while (iter.hasNext()) {
                    TaskListAttachment file = (TaskListAttachment)iter.next();
                    TaskListAttachment newFile = (TaskListAttachment)file.clone();
                    set.add(newFile);
                }
                taskList.attachments = set;
            }
            if (this.conditions != null) {
                HashMap<Integer, TaskListItem> taskListItemsSeq = new HashMap<Integer, TaskListItem>();
                for (Object itemObject : taskList.taskListItems) {
                    TaskListItem item = (TaskListItem)itemObject;
                    taskListItemsSeq.put(item.getSequenceId(), item);
                }
                HashSet<TaskListCondition> newConditions = new HashSet<TaskListCondition>();
                for (TaskListCondition condition : this.conditions) {
                    TaskListCondition newCondition = (TaskListCondition)condition.clone();
                    if (condition.getTaskListItems() != null) {
                        HashSet condTaskListItems = new HashSet();
                        for (TaskListItem item : condition.getTaskListItems()) {
                            condTaskListItems.add(taskListItemsSeq.get(item.getSequenceId()));
                        }
                        newCondition.setTaskListItems(condTaskListItems);
                    }
                    newConditions.add(newCondition);
                }
                taskList.conditions = newConditions;
            }
            if (this.createdBy != null) {
                taskList.setCreatedBy((TaskListUser)this.createdBy.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + TaskList.class + " failed"));
        }
        return taskList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskList)) {
            return false;
        }
        TaskList genericEntity = (TaskList)o;
        return new EqualsBuilder().append((Object)this.uid, (Object)genericEntity.uid).append((Object)this.title, (Object)genericEntity.title).append((Object)this.instructions, (Object)genericEntity.instructions).append((Object)this.onlineInstructions, (Object)genericEntity.onlineInstructions).append((Object)this.offlineInstructions, (Object)genericEntity.offlineInstructions).append((Object)this.created, (Object)genericEntity.created).append((Object)this.updated, (Object)genericEntity.updated).append((Object)this.createdBy, (Object)genericEntity.createdBy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.title).append((Object)this.instructions).append((Object)this.onlineInstructions).append((Object)this.offlineInstructions).append((Object)this.created).append((Object)this.updated).append((Object)this.createdBy).toHashCode();
    }

    public void updateModificationData() {
        long now = System.currentTimeMillis();
        if (this.created == null) {
            this.setCreated(new Date(now));
        }
        this.setUpdated(new Date(now));
    }

    public void toDTO() {
        this.onlineFileList = new ArrayList<TaskListAttachment>();
        this.offlineFileList = new ArrayList<TaskListAttachment>();
        Set fileSet = this.getAttachments();
        if (fileSet != null) {
            for (TaskListAttachment file : fileSet) {
                if (StringUtils.equalsIgnoreCase((String)file.getFileType(), (String)"OFFLINE")) {
                    this.offlineFileList.add(file);
                    continue;
                }
                this.onlineFileList.add(file);
            }
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public TaskListUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(TaskListUser createdBy) {
        this.createdBy = createdBy;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean forceOffline) {
        this.runOffline = forceOffline;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set attachments) {
        this.attachments = attachments;
    }

    public Set getConditions() {
        return this.conditions;
    }

    public void setConditions(Set conditions) {
        this.conditions = conditions;
    }

    public Set getTaskListItems() {
        return this.taskListItems;
    }

    public void setTaskListItems(Set taskListItems) {
        this.taskListItems = taskListItems;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public boolean getLockWhenFinished() {
        return this.lockWhenFinished;
    }

    public void setLockWhenFinished(boolean lockWhenFinished) {
        this.lockWhenFinished = lockWhenFinished;
    }

    public boolean isAllowContributeTasks() {
        return this.allowContributeTasks;
    }

    public void setAllowContributeTasks(boolean allowContributeTasks) {
        this.allowContributeTasks = allowContributeTasks;
    }

    public boolean isMonitorVerificationRequired() {
        return this.monitorVerificationRequired;
    }

    public void setMonitorVerificationRequired(boolean monitorVerificationRequired) {
        this.monitorVerificationRequired = monitorVerificationRequired;
    }

    public boolean isSequentialOrder() {
        return this.sequentialOrder;
    }

    public void setSequentialOrder(boolean sequentialOrder) {
        this.sequentialOrder = sequentialOrder;
    }

    public int getMinimumNumberTasks() {
        return this.minimumNumberTasks;
    }

    public void setMinimumNumberTasks(int minimumNumberTasks) {
        this.minimumNumberTasks = minimumNumberTasks;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public List<TaskListAttachment> getOfflineFileList() {
        return this.offlineFileList;
    }

    public void setOfflineFileList(List<TaskListAttachment> offlineFileList) {
        this.offlineFileList = offlineFileList;
    }

    public List<TaskListAttachment> getOnlineFileList() {
        return this.onlineFileList;
    }

    public void setOnlineFileList(List<TaskListAttachment> onlineFileList) {
        this.onlineFileList = onlineFileList;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }

    public String getMinimumNumberTasksErrorStr() {
        return this.minimumNumberTasksErrorStr;
    }

    public void setMinimumNumberTasksErrorStr(String minimumNumberTasksErrorStr) {
        this.minimumNumberTasksErrorStr = minimumNumberTasksErrorStr;
    }
}

