/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemComment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;

public class TaskListItem
implements Cloneable {
    private static final Logger log = Logger.getLogger(TaskListItem.class);
    private Long uid;
    private String title;
    private String description;
    private int sequenceId;
    private String initialItem;
    private String organizationXml;
    private boolean isCreateByAuthor;
    private Date createDate;
    private TaskListUser createBy;
    private boolean isRequired;
    private boolean isCommentsAllowed;
    private boolean isCommentsRequired;
    private boolean isFilesAllowed;
    private boolean isFilesRequired;
    private boolean isChildTask;
    private String parentTaskName;
    private boolean isCommentsFilesAllowed;
    private boolean showCommentsToAll;
    private Set attachments = new HashSet();
    private Set comments = new HashSet();
    private boolean complete;

    public Object clone() {
        TaskListItem taskListItem = null;
        try {
            HashSet<Cloneable> set;
            Iterator iter;
            taskListItem = (TaskListItem)super.clone();
            taskListItem.setUid(null);
            if (this.attachments != null) {
                iter = this.attachments.iterator();
                set = new HashSet<Cloneable>();
                while (iter.hasNext()) {
                    TaskListItemAttachment file = (TaskListItemAttachment)iter.next();
                    TaskListItemAttachment newFile = (TaskListItemAttachment)file.clone();
                    set.add(newFile);
                }
                taskListItem.attachments = set;
            }
            if (this.comments != null) {
                iter = this.comments.iterator();
                set = new HashSet();
                while (iter.hasNext()) {
                    TaskListItemComment comment = (TaskListItemComment)iter.next();
                    TaskListItemComment newComment = (TaskListItemComment)comment.clone();
                    set.add(newComment);
                }
                taskListItem.comments = set;
            }
            if (this.createBy != null) {
                taskListItem.setCreateBy((TaskListUser)this.createBy.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + TaskListItem.class + " failed"));
        }
        return taskListItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskListItem)) {
            return false;
        }
        TaskListItem genericEntity = (TaskListItem)o;
        return new EqualsBuilder().append((Object)this.uid, (Object)genericEntity.uid).append((Object)this.title, (Object)genericEntity.title).append((Object)this.description, (Object)genericEntity.description).append((Object)this.createDate, (Object)genericEntity.createDate).append((Object)this.createBy, (Object)genericEntity.createBy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.title).append((Object)this.description).append((Object)this.createDate).append((Object)this.createBy).toHashCode();
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long userID) {
        this.uid = userID;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInitialItem() {
        return this.initialItem;
    }

    public void setInitialItem(String initialItem) {
        this.initialItem = initialItem;
    }

    public String getOrganizationXml() {
        return this.organizationXml;
    }

    public void setOrganizationXml(String organizationXml) {
        this.organizationXml = organizationXml;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TaskListUser getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(TaskListUser createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public boolean isCreateByAuthor() {
        return this.isCreateByAuthor;
    }

    public void setCreateByAuthor(boolean isCreateByAuthor) {
        this.isCreateByAuthor = isCreateByAuthor;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean isCommentsAllowed() {
        return this.isCommentsAllowed;
    }

    public void setCommentsAllowed(boolean isCommentsAllowed) {
        this.isCommentsAllowed = isCommentsAllowed;
    }

    public boolean isCommentsRequired() {
        return this.isCommentsRequired;
    }

    public void setCommentsRequired(boolean isCommentsRequired) {
        this.isCommentsRequired = isCommentsRequired;
    }

    public boolean isFilesAllowed() {
        return this.isFilesAllowed;
    }

    public void setFilesAllowed(boolean isFilesAllowed) {
        this.isFilesAllowed = isFilesAllowed;
    }

    public boolean isFilesRequired() {
        return this.isFilesRequired;
    }

    public void setFilesRequired(boolean isFilesRequired) {
        this.isFilesRequired = isFilesRequired;
    }

    public boolean isChildTask() {
        return this.isChildTask;
    }

    public void setChildTask(boolean isChildTask) {
        this.isChildTask = isChildTask;
    }

    public String getParentTaskName() {
        return this.parentTaskName;
    }

    public void setParentTaskName(String parentTaskName) {
        this.parentTaskName = parentTaskName;
    }

    public boolean getShowCommentsToAll() {
        return this.showCommentsToAll;
    }

    public void setShowCommentsToAll(boolean showCommentsToAll) {
        this.showCommentsToAll = showCommentsToAll;
    }

    public boolean isCommentsFilesAllowed() {
        return true;
    }

    public void setCommentsFilesAllowed(boolean isCommentsFilesAllowed) {
        this.isCommentsFilesAllowed = isCommentsFilesAllowed;
    }

    public Set getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set attachments) {
        this.attachments = attachments;
    }

    public Set getComments() {
        return this.comments;
    }

    public void setComments(Set comments) {
        this.comments = comments;
    }
}

