/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.model;

import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListSession;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

public class TaskListUser
implements Cloneable {
    private static final long serialVersionUID = -7043502180037866257L;
    private static Logger log = Logger.getLogger(TaskListUser.class);
    private Long uid;
    private Long userId;
    private String firstName;
    private String lastName;
    private String loginName;
    private boolean sessionFinished;
    private boolean isVerifiedByMonitor;
    private TaskListSession session;
    private TaskList taskList;
    private Date accessDate;

    public TaskListUser() {
    }

    public TaskListUser(UserDTO user, TaskListSession session) {
        this.userId = new Long(user.getUserID().intValue());
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.loginName = user.getLogin();
        this.session = session;
        this.taskList = null;
        this.sessionFinished = false;
    }

    public TaskListUser(UserDTO user, TaskList content) {
        this.userId = new Long(user.getUserID().intValue());
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.loginName = user.getLogin();
        this.session = null;
        this.taskList = content;
        this.sessionFinished = false;
    }

    public Object clone() {
        TaskListUser user = null;
        try {
            user = (TaskListUser)super.clone();
            user.setUid(null);
            user.setSession(null);
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + TaskListUser.class + " failed"));
        }
        return user;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long userID) {
        this.uid = userID;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userID) {
        this.userId = userID;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public TaskListSession getSession() {
        return this.session;
    }

    public void setSession(TaskListSession session) {
        this.session = session;
    }

    public TaskList getTaskList() {
        return this.taskList;
    }

    public void setTaskList(TaskList content) {
        this.taskList = content;
    }

    public boolean isSessionFinished() {
        return this.sessionFinished;
    }

    public void setSessionFinished(boolean sessionFinished) {
        this.sessionFinished = sessionFinished;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskListUser)) {
            return false;
        }
        TaskListUser user = (TaskListUser)obj;
        return new EqualsBuilder().append((Object)this.uid, (Object)user.uid).append((Object)this.firstName, (Object)user.firstName).append((Object)this.lastName, (Object)user.lastName).append((Object)this.loginName, (Object)user.loginName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.firstName).append((Object)this.lastName).append((Object)this.loginName).toHashCode();
    }

    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    public boolean isVerifiedByMonitor() {
        return this.isVerifiedByMonitor;
    }

    public void setVerifiedByMonitor(boolean isVerifiedByMonitor) {
        this.isVerifiedByMonitor = isVerifiedByMonitor;
    }
}

