/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.tool.OutputFactory;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListCondition;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListOutputFactory
extends OutputFactory {
    protected static final String OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED = "learner.number.of.tasks.completed";
    protected static final String OUTPUT_NAME_TOOL_CONDITION = "tool.condition";

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Object toolContentObject) throws ToolException {
        TreeMap<String, ToolOutputDefinition> definitionMap = new TreeMap<String, ToolOutputDefinition>();
        ToolOutputDefinition simpleDefinition = this.buildRangeDefinition(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, new Long(0L), null);
        definitionMap.put(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, simpleDefinition);
        if (toolContentObject != null) {
            TaskList taskList = (TaskList)toolContentObject;
            ToolOutputDefinition definition = this.buildBooleanSetOutputDefinition(OUTPUT_NAME_TOOL_CONDITION);
            if (definition.getDefaultConditions() == null) {
                definition.setDefaultConditions(new ArrayList());
            }
            List defaultConditions = definition.getDefaultConditions();
            String trueString = Boolean.TRUE.toString();
            for (TaskListCondition condition : taskList.getConditions()) {
                String name = this.buildConditionName(OUTPUT_NAME_TOOL_CONDITION, condition.getName());
                defaultConditions.add(new BranchCondition(null, null, Integer.valueOf(condition.getSequenceId()), name, condition.getName(), OutputType.OUTPUT_BOOLEAN.toString(), null, null, trueString));
            }
            definition.setShowConditionNameOnly(Boolean.TRUE);
            definitionMap.put(OUTPUT_NAME_TOOL_CONDITION, definition);
        }
        return definitionMap;
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, ITaskListService taskListService, Long toolSessionId, Long learnerId) {
        TreeMap<String, ToolOutput> output = null;
        if (names == null) {
            output = this.createAllDisplayOrderOutputs(taskListService, toolSessionId, learnerId);
        } else {
            output = new TreeMap();
            for (String name : names) {
                ToolOutput newOutput = this.getToolOutput(name, taskListService, toolSessionId, learnerId);
                if (newOutput == null) continue;
                output.put(name, newOutput);
            }
        }
        return output;
    }

    public ToolOutput getToolOutput(String name, ITaskListService taskListService, Long toolSessionId, Long learnerId) {
        if (name != null && name.equals(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED)) {
            int num = taskListService.getNumTasksCompletedByUser(toolSessionId, learnerId);
            return new ToolOutput(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, this.getI18NText(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, true), new Long(num));
        }
        if (name.startsWith(OUTPUT_NAME_TOOL_CONDITION)) {
            boolean check;
            String[] dcNames = this.splitConditionName(name);
            if (dcNames[1] == null || dcNames[1].length() == 0) {
                this.log.error((Object)("Wrong name for tool output tool.condition. Returning false. Condition name was: " + name));
                check = false;
            } else {
                check = taskListService.checkCondition(dcNames[1], toolSessionId, learnerId);
            }
            return new ToolOutput(name, this.getI18NText(OUTPUT_NAME_TOOL_CONDITION, true), Boolean.valueOf(check));
        }
        return null;
    }

    private TreeMap<String, ToolOutput> createAllDisplayOrderOutputs(ITaskListService taskListService, Long toolSessionId, Long learnerId) {
        TreeMap output = null;
        int num = taskListService.getNumTasksCompletedByUser(toolSessionId, learnerId);
        ToolOutput toolOutput = new ToolOutput(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, this.getI18NText(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, true), new Long(num));
        output.put(OUTPUT_NAME_LEARNER_NUM_TASKS_COMPLETED, toolOutput);
        String i18nDescription = this.getI18NText(OUTPUT_NAME_TOOL_CONDITION, true);
        TaskList taskList = taskListService.getTaskListBySessionId(toolSessionId);
        Set conditions = taskList.getConditions();
        for (TaskListCondition condition : conditions) {
            String name = this.buildConditionName(OUTPUT_NAME_TOOL_CONDITION, condition.getName());
            boolean check = taskListService.checkCondition(condition.getName(), toolSessionId, learnerId);
            output.put(name, new ToolOutput(name, i18nDescription, Boolean.valueOf(check)));
        }
        return output;
    }
}

