/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.service;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListAttachmentDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListConditionDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListItemAttachmentDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListItemCommentDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListItemDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListItemVisitDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListSessionDAO;
import org.lamsfoundation.lams.tool.taskList.dao.TaskListUserDAO;
import org.lamsfoundation.lams.tool.taskList.dto.GroupSummary;
import org.lamsfoundation.lams.tool.taskList.dto.ItemSummary;
import org.lamsfoundation.lams.tool.taskList.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.taskList.dto.Summary;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListCondition;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItem;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemComment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemVisitLog;
import org.lamsfoundation.lams.tool.taskList.model.TaskListSession;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;
import org.lamsfoundation.lams.tool.taskList.service.TaskListException;
import org.lamsfoundation.lams.tool.taskList.service.TaskListOutputFactory;
import org.lamsfoundation.lams.tool.taskList.service.UploadTaskListFileException;
import org.lamsfoundation.lams.tool.taskList.util.TaskListToolContentHandler;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListServiceImpl
implements ITaskListService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager {
    static Logger log = Logger.getLogger((String)TaskListServiceImpl.class.getName());
    private TaskListDAO taskListDao;
    private TaskListItemDAO taskListItemDao;
    private TaskListAttachmentDAO taskListAttachmentDao;
    private TaskListConditionDAO taskListConditionDAO;
    private TaskListUserDAO taskListUserDao;
    private TaskListSessionDAO taskListSessionDao;
    private TaskListItemVisitDAO taskListItemVisitDao;
    private TaskListItemAttachmentDAO taskListItemAttachmentDao;
    private TaskListItemCommentDAO taskListItemCommentDAO;
    private TaskListToolContentHandler taskListToolContentHandler;
    private MessageService messageService;
    private TaskListOutputFactory taskListOutputFactory;
    private IRepositoryService repositoryService;
    private ILamsToolService toolService;
    private ILearnerService learnerService;
    private IAuditService auditService;
    private IUserManagementService userManagementService;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;

    @Override
    public TaskList getTaskListByContentId(Long contentId) {
        TaskList rs = this.taskListDao.getByContentId(contentId);
        if (rs == null) {
            log.error((Object)("Could not find the content by given ID:" + contentId));
        }
        return rs;
    }

    @Override
    public TaskList getDefaultContent(Long contentId) throws TaskListException {
        if (contentId == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new TaskListException(error);
        }
        TaskList defaultContent = this.getDefaultTaskList();
        TaskList content = new TaskList();
        content = TaskList.newInstance(defaultContent, contentId, this.taskListToolContentHandler);
        return content;
    }

    @Override
    public List getAuthoredItems(Long taskListUid) {
        return this.taskListItemDao.getAuthoringItems(taskListUid);
    }

    @Override
    public TaskListAttachment uploadInstructionFile(FormFile uploadFile, String fileType) throws UploadTaskListFileException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.upload.file.not.found", new Object[]{uploadFile}));
        }
        NodeKey nodeKey = this.processFile(uploadFile, fileType);
        TaskListAttachment file = new TaskListAttachment();
        file.setFileType(fileType);
        file.setFileUuid(nodeKey.getUuid());
        file.setFileVersionId(nodeKey.getVersion());
        file.setFileName(uploadFile.getFileName());
        file.setCreated(new Date());
        return file;
    }

    @Override
    public TaskListItemAttachment uploadTaskListItemFile(FormFile uploadFile, String fileType, TaskListUser user) throws UploadTaskListFileException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.upload.file.not.found", new Object[]{uploadFile}));
        }
        NodeKey nodeKey = this.processFile(uploadFile, fileType);
        TaskListItemAttachment file = new TaskListItemAttachment();
        file.setFileType(fileType);
        file.setFileUuid(nodeKey.getUuid());
        file.setFileVersionId(nodeKey.getVersion());
        file.setFileName(uploadFile.getFileName());
        file.setCreated(new Timestamp(new Date().getTime()));
        file.setCreateBy(user);
        return file;
    }

    @Override
    public void createUser(TaskListUser taskListUser) {
        this.taskListUserDao.saveObject(taskListUser);
    }

    @Override
    public TaskListUser getUserByIDAndContent(Long userId, Long contentId) {
        return this.taskListUserDao.getUserByUserIDAndContentID(userId, contentId);
    }

    @Override
    public TaskListUser getUserByIDAndSession(Long userId, Long sessionId) {
        return this.taskListUserDao.getUserByUserIDAndSessionID(userId, sessionId);
    }

    @Override
    public TaskListUser getUser(Long uid) {
        return (TaskListUser)this.taskListUserDao.getObject(TaskListUser.class, uid);
    }

    @Override
    public void deleteFromRepository(Long fileUuid, Long fileVersionId) throws TaskListException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, fileUuid, fileVersionId);
        }
        catch (Exception e) {
            throw new TaskListException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void saveOrUpdateTaskList(TaskList taskList) {
        this.taskListDao.saveObject(taskList);
    }

    @Override
    public void deleteTaskListAttachment(Long attachmentUid) {
        this.taskListAttachmentDao.removeObject(TaskListAttachment.class, attachmentUid);
    }

    @Override
    public void deleteTaskListCondition(Long conditionUid) {
        this.taskListConditionDAO.removeObject(TaskListCondition.class, conditionUid);
    }

    public void deleteTaskListItemAttachment(Long attachmentUid) {
        this.taskListItemAttachmentDao.removeObject(TaskListItemAttachment.class, attachmentUid);
    }

    @Override
    public void saveOrUpdateTaskListItem(TaskListItem item) {
        this.taskListItemDao.saveObject(item);
    }

    @Override
    public void deleteTaskListItem(Long uid) {
        this.taskListItemDao.removeObject(TaskListItem.class, uid);
    }

    @Override
    public TaskList getTaskListBySessionId(Long sessionId) {
        TaskListSession session = this.taskListSessionDao.getSessionBySessionId(sessionId);
        Long contentId = session.getTaskList().getContentId();
        TaskList taskList = this.taskListDao.getByContentId(contentId);
        return taskList;
    }

    @Override
    public TaskListItem getTaskListItemByUid(Long itemUid) {
        return this.taskListItemDao.getByUid(itemUid);
    }

    @Override
    public TaskListSession getTaskListSessionBySessionId(Long sessionId) {
        return this.taskListSessionDao.getSessionBySessionId(sessionId);
    }

    @Override
    public void saveOrUpdateTaskListSession(TaskListSession resSession) {
        this.taskListSessionDao.saveObject(resSession);
    }

    @Override
    public String finishToolSession(Long toolSessionId, Long userId) throws TaskListException {
        TaskListUser user = this.taskListUserDao.getUserByUserIDAndSessionID(userId, toolSessionId);
        user.setSessionFinished(true);
        this.taskListUserDao.saveObject(user);
        String nextUrl = null;
        try {
            nextUrl = this.leaveToolSession(toolSessionId, userId);
        }
        catch (DataMissingException e) {
            throw new TaskListException(e);
        }
        catch (ToolException e) {
            throw new TaskListException(e);
        }
        return nextUrl;
    }

    @Override
    public void setItemComplete(Long taskListItemUid, Long userId, Long sessionId) {
        TaskListItemVisitLog log = this.taskListItemVisitDao.getTaskListItemLog(taskListItemUid, userId);
        if (log == null) {
            log = new TaskListItemVisitLog();
            TaskListItem item = this.taskListItemDao.getByUid(taskListItemUid);
            log.setTaskListItem(item);
            TaskListUser user = this.taskListUserDao.getUserByUserIDAndSessionID(userId, sessionId);
            log.setUser(user);
            log.setSessionId(sessionId);
            log.setAccessDate(new Timestamp(new Date().getTime()));
        }
        log.setComplete(true);
        this.taskListItemVisitDao.saveObject(log);
    }

    @Override
    public void setItemAccess(Long taskListItemUid, Long userId, Long sessionId) {
        TaskListItemVisitLog log = this.taskListItemVisitDao.getTaskListItemLog(taskListItemUid, userId);
        if (log == null) {
            log = new TaskListItemVisitLog();
            TaskListItem item = this.taskListItemDao.getByUid(taskListItemUid);
            log.setTaskListItem(item);
            TaskListUser user = this.taskListUserDao.getUserByUserIDAndSessionID(userId, sessionId);
            log.setUser(user);
            log.setComplete(false);
            log.setSessionId(sessionId);
            log.setAccessDate(new Timestamp(new Date().getTime()));
            this.taskListItemVisitDao.saveObject(log);
        }
    }

    @Override
    public void retrieveComplete(Set<TaskListItem> taskListItemList, TaskListUser user) {
        for (TaskListItem item : taskListItemList) {
            TaskListItemVisitLog log = this.taskListItemVisitDao.getTaskListItemLog(item.getUid(), user.getUserId());
            if (log == null) {
                item.setComplete(false);
                continue;
            }
            item.setComplete(log.isComplete());
        }
    }

    @Override
    public List<Summary> getSummary(Long contentId) {
        TaskList taskList = this.taskListDao.getByContentId(contentId);
        List<TaskListSession> sessionList = this.taskListSessionDao.getByContentId(contentId);
        ArrayList<Summary> summaryList = new ArrayList<Summary>();
        for (TaskListSession session : sessionList) {
            List<TaskListItem> itemList = this.getItemListForGroup(contentId, session.getSessionId());
            List<TaskListUser> userList = this.taskListUserDao.getBySessionID(session.getSessionId());
            boolean[][] complete = new boolean[userList.size()][itemList.size()];
            int[] visitNumbers = new int[itemList.size()];
            for (int i = 0; i < userList.size(); ++i) {
                TaskListUser user = userList.get(i);
                for (int j = 0; j < itemList.size(); ++j) {
                    TaskListItem item = itemList.get(j);
                    TaskListItemVisitLog visitLog = this.taskListItemVisitDao.getTaskListItemLog(item.getUid(), user.getUserId());
                    if (visitLog != null) {
                        complete[i][j] = visitLog.isComplete();
                        if (!visitLog.isComplete()) continue;
                        int n = j;
                        visitNumbers[n] = visitNumbers[n] + 1;
                        continue;
                    }
                    complete[i][j] = false;
                }
            }
            Summary summary = new Summary(session.getSessionName(), itemList, userList, complete, visitNumbers, taskList.isMonitorVerificationRequired());
            summaryList.add(summary);
        }
        return summaryList;
    }

    @Override
    public List<GroupSummary> getItemSummary(Long contentId, Long taskListItemUid, boolean isExportProcessing) {
        TaskListItem taskListItem = this.taskListItemDao.getByUid(taskListItemUid);
        ArrayList<GroupSummary> groupSummaries = new ArrayList<GroupSummary>();
        List<Object> sessionList = new ArrayList();
        if (taskListItem.isCreateByAuthor()) {
            sessionList = this.taskListSessionDao.getByContentId(contentId);
        } else {
            TaskListSession userSession = taskListItem.getCreateBy().getSession();
            sessionList.add(userSession);
        }
        for (TaskListSession taskListSession : sessionList) {
            GroupSummary groupSummary = new GroupSummary();
            groupSummary.setSessionName(taskListSession.getSessionName());
            groupSummary.setTaskListItem(taskListItem);
            List<TaskListUser> usersBelongToGroup = this.taskListUserDao.getBySessionID(taskListSession.getSessionId());
            for (TaskListUser user : usersBelongToGroup) {
                ItemSummary userItemSummary = new ItemSummary();
                userItemSummary.setUser(user);
                TaskListItemVisitLog visitLog = this.taskListItemVisitDao.getTaskListItemLog(taskListItem.getUid(), user.getUserId());
                if (visitLog != null) {
                    userItemSummary.setCompleted(visitLog.isComplete());
                    if (visitLog.isComplete()) {
                        userItemSummary.setDate(visitLog.getAccessDate());
                    }
                    Set itemComments = taskListItem.getComments();
                    for (TaskListItemComment comment : itemComments) {
                        if (!user.getUserId().equals(comment.getCreateBy().getUserId())) continue;
                        userItemSummary.getComments().add(comment);
                    }
                    Set itemAttachments = taskListItem.getAttachments();
                    for (TaskListItemAttachment attachment : itemAttachments) {
                        if (!user.getUserId().equals(attachment.getCreateBy().getUserId())) continue;
                        userItemSummary.getAttachments().add(attachment);
                    }
                } else {
                    userItemSummary.setCompleted(false);
                }
                if (isExportProcessing) {
                    NotebookEntry notebookEntry = this.getEntry(taskListSession.getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "latask10", user.getUserId().intValue());
                    ReflectDTO reflectDTO = new ReflectDTO(user);
                    if (notebookEntry == null) {
                        reflectDTO.setFinishReflection(false);
                        reflectDTO.setReflect(null);
                    } else {
                        reflectDTO.setFinishReflection(true);
                        reflectDTO.setReflect(notebookEntry.getEntry());
                    }
                    reflectDTO.setReflectInstructions(taskListSession.getTaskList().getReflectInstructions());
                    userItemSummary.setReflectDTO(reflectDTO);
                }
                groupSummary.getItemSummaries().add(userItemSummary);
            }
            groupSummaries.add(groupSummary);
        }
        return groupSummaries;
    }

    @Override
    public List<List<GroupSummary>> exportForTeacher(Long contentId) {
        TaskList taskList = this.taskListDao.getByContentId(contentId);
        ArrayList<TaskListItem> itemList = new ArrayList<TaskListItem>();
        itemList.addAll(taskList.getTaskListItems());
        List<TaskListSession> sessionList = this.taskListSessionDao.getByContentId(contentId);
        for (TaskListSession session : sessionList) {
            Set newItems = session.getTaskListItems();
            for (TaskListItem item : newItems) {
                if (itemList.contains(item)) continue;
                itemList.add(item);
            }
        }
        ArrayList<List<GroupSummary>> taskSummaries = new ArrayList<List<GroupSummary>>();
        for (TaskListItem item : itemList) {
            taskSummaries.add(this.getItemSummary(contentId, item.getUid(), true));
        }
        return taskSummaries;
    }

    @Override
    public List<List<GroupSummary>> exportForLearner(Long sessionId, TaskListUser learner) {
        Long contentId = this.getTaskListBySessionId(sessionId).getContentId();
        TaskList taskList = this.taskListDao.getByContentId(contentId);
        List<TaskListItem> itemList = this.getItemListForGroup(contentId, sessionId);
        ArrayList<List<GroupSummary>> eachItemOverallSummaries = new ArrayList<List<GroupSummary>>();
        for (TaskListItem taskListItem : itemList) {
            eachItemOverallSummaries.add(this.getItemSummary(contentId, taskListItem.getUid(), true));
        }
        for (List list : eachItemOverallSummaries) {
            GroupSummary newGroupSummary = new GroupSummary();
            for (GroupSummary groupSummary : list) {
                for (ItemSummary itemSummary : groupSummary.getItemSummaries()) {
                    if (!learner.equals(itemSummary.getUser())) continue;
                    newGroupSummary.setSessionName(groupSummary.getSessionName());
                    newGroupSummary.setTaskListItem(groupSummary.getTaskListItem());
                    newGroupSummary.getItemSummaries().add(itemSummary);
                }
            }
            list.clear();
            list.add(newGroupSummary);
        }
        return eachItemOverallSummaries;
    }

    @Override
    public int getNumTasksCompletedByUser(Long toolSessionId, Long userUid) {
        return this.getTaskListItemVisitDao().getTasksCompletedCountByUser(toolSessionId, userUid);
    }

    @Override
    public boolean checkCondition(String conditionName, Long toolSessionId, Long userUid) {
        TaskListUser user = this.taskListUserDao.getUserByUserIDAndSessionID(userUid, toolSessionId);
        TaskList taskList = this.taskListSessionDao.getSessionBySessionId(toolSessionId).getTaskList();
        Set conditions = taskList.getConditions();
        TaskListCondition condition = null;
        for (TaskListCondition cond : conditions) {
            if (!cond.getName().equals(conditionName)) continue;
            condition = cond;
            break;
        }
        boolean result = true;
        if (condition != null) {
            for (TaskListItem item : condition.getTaskListItems()) {
                TaskListItemVisitLog visitLog = this.taskListItemVisitDao.getTaskListItemLog(item.getUid(), userUid);
                if (visitLog != null) {
                    result &= visitLog.isComplete();
                    continue;
                }
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public List<TaskListUser> getUserListBySessionItem(Long sessionId, Long itemUid) {
        List<TaskListItemVisitLog> logList = this.taskListItemVisitDao.getTaskListItemLogBySession(sessionId, itemUid);
        ArrayList<TaskListUser> userList = new ArrayList<TaskListUser>(logList.size());
        for (TaskListItemVisitLog visit : logList) {
            TaskListUser user = visit.getUser();
            user.setAccessDate(visit.getAccessDate());
            userList.add(user);
        }
        return userList;
    }

    @Override
    public List<TaskListUser> getUserListBySessionId(Long sessionId) {
        return this.taskListUserDao.getBySessionID(sessionId);
    }

    @Override
    public Long createNotebookEntry(Long sessionId, Integer notebookToolType, String toolSignature, Integer userId, String entryText) {
        return this.coreNotebookService.createNotebookEntry(sessionId, notebookToolType, toolSignature, userId, "", entryText);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public TaskListOutputFactory getTaskListOutputFactory() {
        return this.taskListOutputFactory;
    }

    public void setTaskListOutputFactory(TaskListOutputFactory taskListOutputFactory) {
        this.taskListOutputFactory = taskListOutputFactory;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setTaskListAttachmentDao(TaskListAttachmentDAO taskListAttachmentDao) {
        this.taskListAttachmentDao = taskListAttachmentDao;
    }

    public void setTaskListConditionDao(TaskListConditionDAO taskListConditionDAO) {
        this.taskListConditionDAO = taskListConditionDAO;
    }

    public void setTaskListDao(TaskListDAO taskListDao) {
        this.taskListDao = taskListDao;
    }

    public void setTaskListItemDao(TaskListItemDAO taskListItemDao) {
        this.taskListItemDao = taskListItemDao;
    }

    public void setTaskListSessionDao(TaskListSessionDAO taskListSessionDao) {
        this.taskListSessionDao = taskListSessionDao;
    }

    public void setTaskListToolContentHandler(TaskListToolContentHandler taskListToolContentHandler) {
        this.taskListToolContentHandler = taskListToolContentHandler;
    }

    public void setTaskListUserDao(TaskListUserDAO taskListUserDao) {
        this.taskListUserDao = taskListUserDao;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public TaskListItemVisitDAO getTaskListItemVisitDao() {
        return this.taskListItemVisitDao;
    }

    public void setTaskListItemVisitDao(TaskListItemVisitDAO taskListItemVisitDao) {
        this.taskListItemVisitDao = taskListItemVisitDao;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        TaskList toolContentObj = this.taskListDao.getByContentId(toolContentId);
        if (toolContentObj == null) {
            try {
                toolContentObj = this.getDefaultTaskList();
            }
            catch (TaskListException e) {
                throw new DataMissingException(e.getMessage());
            }
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the taskList tool");
        }
        toolContentObj = TaskList.newInstance(toolContentObj, toolContentId, null);
        toolContentObj.setToolContentHandler(null);
        toolContentObj.setOfflineFileList(null);
        toolContentObj.setOnlineFileList(null);
        Set taskListItems = toolContentObj.getTaskListItems();
        for (TaskListItem taskListItem : taskListItems) {
            taskListItem.setComments(null);
            taskListItem.setAttachments(null);
        }
        try {
            this.exportContentService.registerFileClassForExport(TaskListAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, (IToolContentHandler)this.taskListToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(TaskListAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, (IToolContentHandler)this.taskListToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof TaskList)) {
                throw new ImportToolContentException("Import Share taskList tool content failed. Deserialized object is " + toolPOJO);
            }
            TaskList toolContentObj = (TaskList)toolPOJO;
            toolContentObj.setContentId(toolContentId);
            TaskListUser user = this.taskListUserDao.getUserByUserIDAndContentID(new Long(newUserUid.longValue()), toolContentId);
            if (user == null) {
                user = new TaskListUser();
                UserDTO sysUser = ((User)this.userManagementService.findById(User.class, (Serializable)newUserUid)).getUserDTO();
                user.setFirstName(sysUser.getFirstName());
                user.setLastName(sysUser.getLastName());
                user.setLoginName(sysUser.getLogin());
                user.setUserId(new Long(newUserUid.longValue()));
                user.setTaskList(toolContentObj);
            }
            toolContentObj.setCreatedBy(user);
            Set items = toolContentObj.getTaskListItems();
            for (TaskListItem item : items) {
                item.setCreateBy(user);
            }
            this.taskListDao.saveObject(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        TaskList taskList = this.getTaskListByContentId(toolContentId);
        if (taskList == null) {
            taskList = this.getDefaultTaskList();
        }
        return this.getTaskListOutputFactory().getToolOutputDefinitions(taskList);
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to create the SharedTaskListFiles tool seession");
        }
        TaskList taskList = null;
        if (fromContentId != null) {
            taskList = this.taskListDao.getByContentId(fromContentId);
        }
        if (taskList == null) {
            try {
                taskList = this.getDefaultTaskList();
            }
            catch (TaskListException e) {
                throw new ToolException((Throwable)e);
            }
        }
        TaskList toContent = TaskList.newInstance(taskList, toContentId, this.taskListToolContentHandler);
        this.taskListDao.saveObject(toContent);
        Set items = toContent.getTaskListItems();
        if (items != null) {
            for (TaskListItem item : items) {
            }
        }
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        TaskList taskList = this.taskListDao.getByContentId(toolContentId);
        if (taskList == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        taskList.setDefineLater(value);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        TaskList taskList = this.taskListDao.getByContentId(toolContentId);
        if (taskList == null) {
            throw new ToolException("No found tool content by given content ID:" + toolContentId);
        }
        taskList.setRunOffline(value);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
        TaskList taskList = this.taskListDao.getByContentId(toolContentId);
        if (removeSessionData) {
            List<TaskListSession> list = this.taskListSessionDao.getByContentId(toolContentId);
            for (TaskListSession session : list) {
                this.taskListSessionDao.delete(session);
            }
        }
        this.taskListDao.delete(taskList);
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        TaskListSession session = new TaskListSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        TaskList taskList = this.taskListDao.getByContentId(toolContentId);
        session.setTaskList(taskList);
        this.taskListSessionDao.saveObject(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        if (toolSessionId == null) {
            log.error((Object)"Fail to leave tool Session based on null tool session id.");
            throw new ToolException("Fail to remove tool Session based on null tool session id.");
        }
        if (learnerId == null) {
            log.error((Object)"Fail to leave tool Session based on null learner.");
            throw new ToolException("Fail to remove tool Session based on null learner.");
        }
        TaskListSession session = this.taskListSessionDao.getSessionBySessionId(toolSessionId);
        if (session == null) {
            log.error((Object)("Fail to leave tool Session.Could not find shared taskList session by given session id: " + toolSessionId));
            throw new DataMissingException("Fail to leave tool Session.Could not find shared taskList session by given session id: " + toolSessionId);
        }
        session.setStatus(1);
        this.taskListSessionDao.saveObject(session);
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.taskListSessionDao.deleteBySessionId(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return this.taskListOutputFactory.getToolOutput(names, (ITaskListService)this, toolSessionId, learnerId);
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return this.taskListOutputFactory.getToolOutput(name, (ITaskListService)this, toolSessionId, learnerId);
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        TaskList toolContentObj = this.getTaskListByContentId(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflectOnActivity(Boolean.TRUE);
        toolContentObj.setReflectInstructions(description);
    }

    private TaskList getDefaultTaskList() throws TaskListException {
        Long defaultTaskListId = this.getToolDefaultContentIdBySignature("latask10");
        TaskList defaultTaskList = this.getTaskListByContentId(defaultTaskListId);
        if (defaultTaskList == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new TaskListException(error);
        }
        return defaultTaskList;
    }

    private Long getToolDefaultContentIdBySignature(String toolSignature) throws TaskListException {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = this.messageService.getMessage("error.msg.default.content.not.find");
            log.error((Object)error);
            throw new TaskListException(error);
        }
        return contentId;
    }

    private List<TaskListItem> getItemListForGroup(Long contentId, Long sessionId) {
        TaskList taskList = this.taskListDao.getByContentId(contentId);
        ArrayList<TaskListItem> itemList = new ArrayList<TaskListItem>();
        itemList.addAll(taskList.getTaskListItems());
        List<TaskListSession> sessionList = this.taskListSessionDao.getByContentId(contentId);
        for (TaskListSession session : sessionList) {
            Set newItems = session.getTaskListItems();
            for (TaskListItem item : newItems) {
                if (itemList.contains(item)) continue;
                itemList.add(item);
            }
        }
        List<TaskListUser> userList = this.taskListUserDao.getBySessionID(sessionId);
        ArrayList<TaskListItem> groupItemList = new ArrayList<TaskListItem>();
        block2: for (TaskListItem item : itemList) {
            if (item.isCreateByAuthor()) {
                groupItemList.add(item);
                continue;
            }
            for (TaskListUser user : userList) {
                if (!user.getUserId().equals(item.getCreateBy().getUserId())) continue;
                groupItemList.add(item);
                continue block2;
            }
        }
        return groupItemList;
    }

    private NodeKey processFile(FormFile file, String fileType) throws UploadTaskListFileException {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.taskListToolContentHandler.uploadFile(file.getInputStream(), fileName, file.getContentType(), fileType);
            }
            catch (InvalidParameterException e) {
                throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.invaid.param.upload"));
            }
            catch (FileNotFoundException e) {
                throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.file.not.found"));
            }
            catch (RepositoryCheckedException e) {
                throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.repository"));
            }
            catch (IOException e) {
                throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.io.exception"));
            }
        }
        return node;
    }

    private NodeKey processPackage(String packageDirectory, String initFile) throws UploadTaskListFileException {
        NodeKey node = null;
        try {
            node = this.taskListToolContentHandler.uploadPackage(packageDirectory, initFile);
        }
        catch (InvalidParameterException e) {
            throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.invaid.param.upload"));
        }
        catch (RepositoryCheckedException e) {
            throw new UploadTaskListFileException(this.messageService.getMessage("error.msg.repository"));
        }
        return node;
    }

    private String findWebsiteInitialItem(String packageDirectory) {
        File file = new File(packageDirectory);
        if (!file.isDirectory()) {
            return null;
        }
        File[] initFiles = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname == null || pathname.getName() == null) {
                    return false;
                }
                String name = pathname.getName();
                return name.endsWith("default.html") || name.endsWith("default.htm") || name.endsWith("index.html") || name.endsWith("index.htm");
            }
        });
        if (initFiles != null && initFiles.length > 0) {
            return initFiles[0].getName();
        }
        return null;
    }

    private IVersionedNode getFile(Long uuid, Long versionId, String relativePath) throws TaskListException {
        ITicket tic = this.getRepositoryLoginTicket();
        try {
            return this.repositoryService.getFileItem(tic, uuid, versionId, relativePath);
        }
        catch (AccessDeniedException e) {
            String error = "Unable to access repository to get file uuid " + uuid + " version id " + versionId + " path " + relativePath + ".";
            error = error + "AccessDeniedException: " + e.getMessage() + " Unable to retry further.";
            log.error((Object)error);
            throw new TaskListException(error, e);
        }
        catch (Exception e) {
            String error = "Unable to access repository to get file uuid " + uuid + " version id " + versionId + " path " + relativePath + "." + " Exception: " + e.getMessage();
            log.error((Object)error);
            throw new TaskListException(error, e);
        }
    }

    private ITicket getRepositoryLoginTicket() throws TaskListException {
        SimpleCredentials credentials = new SimpleCredentials(this.taskListToolContentHandler.getRepositoryUser(), this.taskListToolContentHandler.getRepositoryId());
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, this.taskListToolContentHandler.getRepositoryWorkspaceName());
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new TaskListException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new TaskListException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new TaskListException("Login failed." + e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReflectDTOComparator
    implements Comparator<ReflectDTO> {
        private ReflectDTOComparator() {
        }

        @Override
        public int compare(ReflectDTO o1, ReflectDTO o2) {
            if (o1 != null && o2 != null) {
                return o1.getFullName().compareTo(o2.getFullName());
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

