/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.web.action;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListCondition;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItem;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;
import org.lamsfoundation.lams.tool.taskList.service.UploadTaskListFileException;
import org.lamsfoundation.lams.tool.taskList.util.TaskListConditionComparator;
import org.lamsfoundation.lams.tool.taskList.util.TaskListItemComparator;
import org.lamsfoundation.lams.tool.taskList.web.form.TaskListForm;
import org.lamsfoundation.lams.tool.taskList.web.form.TaskListItemForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringAction
extends Action {
    private static Logger log = Logger.getLogger(AuthoringAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("start")) {
            ToolAccessMode mode = this.getAccessMode(request);
            if (mode != null) {
                request.setAttribute("mode", (Object)mode.toString());
            } else {
                request.setAttribute("mode", (Object)ToolAccessMode.AUTHOR.toString());
            }
            return this.start(mapping, form, request, response);
        }
        if (param.equals("definelater")) {
            Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
            ITaskListService service = this.getTaskListService();
            TaskList taskList = service.getTaskListByContentId(contentId);
            taskList.setDefineLater(true);
            service.saveOrUpdateTaskList(taskList);
            request.setAttribute("mode", (Object)ToolAccessMode.TEACHER.toString());
            return this.start(mapping, form, request, response);
        }
        if (param.equals("initPage")) {
            return this.initPage(mapping, form, request, response);
        }
        if (param.equals("updateContent")) {
            return this.updateContent(mapping, form, request, response);
        }
        if (param.equals("uploadOnlineFile")) {
            return this.uploadOnline(mapping, form, request, response);
        }
        if (param.equals("uploadOfflineFile")) {
            return this.uploadOffline(mapping, form, request, response);
        }
        if (param.equals("deleteOnlineFile")) {
            return this.deleteOnlineFile(mapping, form, request, response);
        }
        if (param.equals("deleteOfflineFile")) {
            return this.deleteOfflineFile(mapping, form, request, response);
        }
        if (param.equals("newItemInit")) {
            return this.newItemlInit(mapping, form, request, response);
        }
        if (param.equals("editItemInit")) {
            return this.editItemInit(mapping, form, request, response);
        }
        if (param.equals("saveOrUpdateItem")) {
            return this.saveOrUpdateItem(mapping, form, request, response);
        }
        if (param.equals("removeItem")) {
            return this.removeItem(mapping, form, request, response);
        }
        if (param.equals("upItem")) {
            return this.upItem(mapping, form, request, response);
        }
        if (param.equals("downItem")) {
            return this.downItem(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        ITaskListService service = this.getTaskListService();
        ArrayList items = null;
        TaskList taskList = null;
        TaskListForm taskListForm = (TaskListForm)form;
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        taskListForm.setContentFolderID(contentFolderID);
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        taskListForm.setSessionMapID(sessionMap.getSessionID());
        try {
            taskList = service.getTaskListByContentId(contentId);
            items = taskList == null ? ((taskList = service.getDefaultContent(contentId)).getTaskListItems() != null ? new ArrayList(taskList.getTaskListItems()) : null) : service.getAuthoredItems(taskList.getUid());
            taskListForm.setTaskList(taskList);
            List attachmentList = this.getAttachmentList(sessionMap);
            attachmentList.clear();
            attachmentList.addAll(taskList.getAttachments());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
        conditionList.clear();
        conditionList.addAll(taskList.getConditions());
        if (items == null) {
            items = new ArrayList();
        } else {
            TaskListUser taskListUser = null;
            for (TaskListItem item : items) {
                if (item.getCreateBy() != null) continue;
                if (taskListUser == null) {
                    HttpSession ss = SessionManager.getSession();
                    UserDTO user = (UserDTO)ss.getAttribute("user");
                    taskListUser = new TaskListUser(user, taskList);
                }
                item.setCreateBy(taskListUser);
            }
        }
        SortedSet<TaskListItem> taskListItemList = this.getTaskListItemList(sessionMap);
        taskListItemList.clear();
        taskListItemList.addAll(items);
        sessionMap.put((Object)"taskListForm", (Object)taskListForm);
        return mapping.findForward("success");
    }

    private ActionForward initPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        TaskListForm existForm = (TaskListForm)((Object)sessionMap.get((Object)"taskListForm"));
        TaskListForm taskListForm = (TaskListForm)form;
        try {
            PropertyUtils.copyProperties((Object)((Object)taskListForm), (Object)((Object)existForm));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        ToolAccessMode mode = this.getAccessMode(request);
        if (mode.isAuthor()) {
            return mapping.findForward("success");
        }
        return mapping.findForward("definelater");
    }

    private ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskListForm taskListForm = (TaskListForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(taskListForm.getSessionMapID());
        ToolAccessMode mode = this.getAccessMode(request);
        ActionMessages errors = this.validate(taskListForm, mapping, request);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            if (mode.isAuthor()) {
                return mapping.findForward("author");
            }
            return mapping.findForward("monitor");
        }
        TaskList taskList = taskListForm.getTaskList();
        ITaskListService service = this.getTaskListService();
        TaskList taskListPO = service.getTaskListByContentId(taskListForm.getTaskList().getContentId());
        if (taskListPO == null) {
            taskListPO = taskList;
            taskListPO.setCreated(new Timestamp(new Date().getTime()));
            taskListPO.setUpdated(new Timestamp(new Date().getTime()));
        } else {
            if (mode.isAuthor()) {
                Long uid = taskListPO.getUid();
                PropertyUtils.copyProperties((Object)taskListPO, (Object)taskList);
                taskListPO.setUid(uid);
            } else {
                taskListPO.setInstructions(taskList.getInstructions());
                taskListPO.setTitle(taskList.getTitle());
                taskListPO.setDefineLater(false);
            }
            taskListPO.setUpdated(new Timestamp(new Date().getTime()));
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        TaskListUser taskListUser = service.getUserByIDAndContent(new Long(user.getUserID().intValue()), taskListForm.getTaskList().getContentId());
        if (taskListUser == null) {
            taskListUser = new TaskListUser(user, taskListPO);
        }
        taskListPO.setCreatedBy(taskListUser);
        HashSet<TaskListAttachment> attPOSet = taskListPO.getAttachments();
        if (attPOSet == null) {
            attPOSet = new HashSet<TaskListAttachment>();
        }
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        for (TaskListAttachment newAtt : attachmentList) {
            attPOSet.add(newAtt);
        }
        attachmentList.clear();
        Iterator iter = deleteAttachmentList.iterator();
        while (iter.hasNext()) {
            TaskListAttachment delAtt = (TaskListAttachment)iter.next();
            iter.remove();
            if (delAtt.getUid() == null) continue;
            Iterator attIter = attPOSet.iterator();
            while (attIter.hasNext()) {
                TaskListAttachment att = (TaskListAttachment)attIter.next();
                if (!delAtt.getUid().equals(att.getUid())) continue;
                attIter.remove();
                break;
            }
            service.deleteTaskListAttachment(delAtt.getUid());
        }
        taskListPO.setAttachments(attPOSet);
        LinkedHashSet<TaskListItem> itemList = new LinkedHashSet<TaskListItem>();
        SortedSet<TaskListItem> items = this.getTaskListItemList(sessionMap);
        for (TaskListItem item : items) {
            if (item == null) continue;
            item.setCreateBy(taskListUser);
            itemList.add(item);
        }
        taskListPO.setTaskListItems(itemList);
        SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
        TreeSet<TaskListCondition> conditionListWithoutEmptyElements = new TreeSet<TaskListCondition>(conditionList);
        List delTaskListConditionList = this.getDeletedTaskListConditionList(sessionMap);
        for (TaskListCondition condition : conditionList) {
            if (condition.getTaskListItems().size() != 0) continue;
            conditionListWithoutEmptyElements.remove(condition);
            delTaskListConditionList.add(condition);
        }
        conditionList.clear();
        conditionList.addAll(conditionListWithoutEmptyElements);
        taskListPO.setConditions(conditionList);
        iter = delTaskListConditionList.iterator();
        while (iter.hasNext()) {
            TaskListCondition condition = (TaskListCondition)iter.next();
            iter.remove();
            if (condition.getUid() == null) continue;
            service.deleteTaskListCondition(condition.getUid());
        }
        List delTaskListItemList = this.getDeletedTaskListItemList(sessionMap);
        iter = delTaskListItemList.iterator();
        while (iter.hasNext()) {
            TaskListItem item = (TaskListItem)iter.next();
            iter.remove();
            if (item.getUid() == null) continue;
            service.deleteTaskListItem(item.getUid());
        }
        if (taskListPO.getMinimumNumberTasks() > items.size()) {
            taskListPO.setMinimumNumberTasks(items.size());
        }
        service.saveOrUpdateTaskList(taskListPO);
        service.getTaskListByContentId(taskListPO.getContentId());
        attachmentList = this.getAttachmentList(sessionMap);
        attachmentList.addAll(taskList.getAttachments());
        taskListForm.setTaskList(taskListPO);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        if (mode.isAuthor()) {
            return mapping.findForward("author");
        }
        return mapping.findForward("monitor");
    }

    private ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadTaskListFileException {
        return this.uploadFile(mapping, form, "ONLINE", request);
    }

    private ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadTaskListFileException {
        return this.uploadFile(mapping, form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, ActionForm form, String type, HttpServletRequest request) throws UploadTaskListFileException {
        TaskListForm taskListForm = (TaskListForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(taskListForm.getSessionMapID());
        FormFile file = StringUtils.equals((String)"OFFLINE", (String)type) ? taskListForm.getOfflineFile() : taskListForm.getOnlineFile();
        if (file == null || StringUtils.isBlank((String)file.getFileName())) {
            return mapping.findForward("success");
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        ITaskListService service = this.getTaskListService();
        TaskListAttachment att = service.uploadInstructionFile(file, type);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            TaskListAttachment existAtt = (TaskListAttachment)iter.next();
            if (!StringUtils.equals((String)existAtt.getFileName(), (String)att.getFileName()) || !StringUtils.equals((String)existAtt.getFileType(), (String)att.getFileType())) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
            break;
        }
        attachmentList.add(att);
        return mapping.findForward("success");
    }

    private ActionForward deleteOfflineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, request, response, form, "OFFLINE");
    }

    private ActionForward deleteOnlineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, request, response, form, "ONLINE");
    }

    private ActionForward deleteFile(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ActionForm form, String type) {
        Long versionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileVersionId"));
        Long uuID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileUuid"));
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            TaskListAttachment existAtt = (TaskListAttachment)iter.next();
            if (!existAtt.getFileUuid().equals(uuID) || !existAtt.getFileVersionId().equals(versionID)) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
        }
        request.setAttribute("fileTypeFlag", (Object)type);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward newItemlInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        ((TaskListItemForm)form).setSessionMapID(sessionMapID);
        return mapping.findForward("task");
    }

    private ActionForward editItemInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SortedSet<TaskListItem> taskListList;
        ArrayList<TaskListItem> rList;
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        TaskListItem item = null;
        if (itemIdx != -1 && (item = (TaskListItem)(rList = new ArrayList<TaskListItem>(taskListList = this.getTaskListItemList(sessionMap))).get(itemIdx)) != null) {
            this.populateItemToForm(itemIdx, item, (TaskListItemForm)form, request);
        }
        return item == null ? null : mapping.findForward("task");
    }

    private ActionForward saveOrUpdateItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TaskListItemForm itemForm;
        block3: {
            itemForm = (TaskListItemForm)form;
            ActionErrors errors = this.validateTaskListItem(itemForm);
            if (!errors.isEmpty()) {
                this.addErrors(request, (ActionMessages)errors);
                return mapping.findForward("task");
            }
            try {
                this.extractFormToTaskListItem(request, itemForm);
            }
            catch (Exception e) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.upload.failed", (Object)e.getMessage()));
                if (errors.isEmpty()) break block3;
                this.addErrors(request, (ActionMessages)errors);
                return mapping.findForward("task");
            }
        }
        request.setAttribute("sessionMapID", (Object)itemForm.getSessionMapID());
        return mapping.findForward("success");
    }

    private ActionForward removeItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        if (itemIdx != -1) {
            SortedSet<TaskListItem> taskListList = this.getTaskListItemList(sessionMap);
            ArrayList<TaskListItem> rList = new ArrayList<TaskListItem>(taskListList);
            TaskListItem item = (TaskListItem)rList.remove(itemIdx);
            taskListList.clear();
            taskListList.addAll(rList);
            List delList = this.getDeletedTaskListItemList(sessionMap);
            delList.add(item);
            SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
            for (TaskListCondition condition : conditionList) {
                Set itemList = condition.getTaskListItems();
                if (!itemList.contains(item)) continue;
                itemList.remove(item);
            }
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward upItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.switchItem(mapping, request, true);
    }

    private ActionForward downItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.switchItem(mapping, request, false);
    }

    private ActionForward switchItem(ActionMapping mapping, HttpServletRequest request, boolean up) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        if (itemIdx != -1) {
            SortedSet<TaskListItem> taskListList = this.getTaskListItemList(sessionMap);
            ArrayList<TaskListItem> rList = new ArrayList<TaskListItem>(taskListList);
            TaskListItem item = (TaskListItem)rList.get(itemIdx);
            TaskListItem repItem = up ? (TaskListItem)rList.get(--itemIdx) : (TaskListItem)rList.get(++itemIdx);
            int upSeqId = repItem.getSequenceId();
            repItem.setSequenceId(item.getSequenceId());
            item.setSequenceId(upSeqId);
            taskListList.clear();
            taskListList.addAll(rList);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ITaskListService getTaskListService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ITaskListService)wac.getBean("lataskTaskListService");
    }

    private List getAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "instructionAttachmentList");
    }

    private List getDeletedAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAttachmmentList");
    }

    private SortedSet<TaskListItem> getTaskListItemList(SessionMap sessionMap) {
        TreeSet<TaskListItem> list = (TreeSet<TaskListItem>)sessionMap.get((Object)"taskListList");
        if (list == null) {
            list = new TreeSet<TaskListItem>(new TaskListItemComparator());
            sessionMap.put((Object)"taskListList", list);
        }
        return list;
    }

    private SortedSet<TaskListCondition> getTaskListConditionList(SessionMap sessionMap) {
        TreeSet<TaskListCondition> list = (TreeSet<TaskListCondition>)sessionMap.get((Object)"conditionList");
        if (list == null) {
            list = new TreeSet<TaskListCondition>(new TaskListConditionComparator());
            sessionMap.put((Object)"conditionList", list);
        }
        return list;
    }

    private List getDeletedTaskListConditionList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deleteConditionList");
    }

    private List getDeletedTaskListItemList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deleteTaskListList");
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private void populateItemToForm(int itemIdx, TaskListItem item, TaskListItemForm form, HttpServletRequest request) {
        form.setDescription(item.getDescription());
        form.setTitle(item.getTitle());
        if (itemIdx >= 0) {
            form.setItemIndex(new Integer(itemIdx).toString());
        }
        form.setRequired(item.isRequired());
        form.setCommentsAllowed(item.isCommentsAllowed());
        form.setCommentsRequired(item.isCommentsRequired());
        form.setFilesAllowed(item.isFilesAllowed());
        form.setFilesRequired(item.isFilesRequired());
        form.setCommentsFilesAllowed(item.isCommentsFilesAllowed());
        form.setShowCommentsToAll(item.getShowCommentsToAll());
        form.setChildTask(item.isChildTask());
        form.setParentTaskName(item.getParentTaskName());
    }

    private void extractFormToTaskListItem(HttpServletRequest request, TaskListItemForm itemForm) throws Exception {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(itemForm.getSessionMapID());
        SortedSet<TaskListItem> taskListList = this.getTaskListItemList(sessionMap);
        int itemIdx = NumberUtils.stringToInt((String)itemForm.getItemIndex(), (int)-1);
        TaskListItem item = null;
        if (itemIdx == -1) {
            item = new TaskListItem();
            item.setCreateDate(new Timestamp(new Date().getTime()));
            int maxSeq = 1;
            if (taskListList != null && taskListList.size() > 0) {
                TaskListItem last = taskListList.last();
                maxSeq = last.getSequenceId() + 1;
            }
            item.setSequenceId(maxSeq);
            taskListList.add(item);
        } else {
            ArrayList<TaskListItem> rList = new ArrayList<TaskListItem>(taskListList);
            item = (TaskListItem)rList.get(itemIdx);
        }
        item.setTitle(itemForm.getTitle());
        item.setDescription(itemForm.getDescription());
        item.setCreateByAuthor(true);
        item.setRequired(itemForm.isRequired());
        item.setCommentsAllowed(itemForm.isCommentsAllowed());
        item.setCommentsRequired(itemForm.isCommentsRequired());
        item.setFilesAllowed(itemForm.isFilesAllowed());
        item.setFilesRequired(itemForm.isFilesRequired());
        item.setCommentsFilesAllowed(itemForm.isCommentsFilesAllowed());
        item.setShowCommentsToAll(itemForm.getShowCommentsToAll());
        item.setChildTask(itemForm.isChildTask());
        item.setParentTaskName(itemForm.getParentTaskName());
    }

    private ActionErrors validateTaskListItem(TaskListItemForm itemForm) {
        ActionErrors errors = new ActionErrors();
        if (StringUtils.isBlank((String)itemForm.getTitle())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.title.blank"));
        }
        return errors;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private ActionMessages validate(TaskListForm taskListForm, ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        String modeStr = request.getParameter("mode");
        if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
            return errors;
        }
        return errors;
    }
}

