/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.web.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.taskList.model.TaskListCondition;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItem;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;
import org.lamsfoundation.lams.tool.taskList.util.TaskListConditionComparator;
import org.lamsfoundation.lams.tool.taskList.util.TaskListItemComparator;
import org.lamsfoundation.lams.tool.taskList.web.form.TaskListConditionForm;
import org.lamsfoundation.lams.tool.taskList.web.form.TaskListForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringTaskListConditionAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("showConditions")) {
            return this.showConditions(mapping, form, request, response);
        }
        if (param.equals("newConditionInit")) {
            return this.newConditionInit(mapping, form, request, response);
        }
        if (param.equals("editCondition")) {
            return this.editCondition(mapping, form, request, response);
        }
        if (param.equals("saveOrUpdateCondition")) {
            return this.saveOrUpdateCondition(mapping, form, request, response);
        }
        if (param.equals("removeCondition")) {
            return this.removeCondition(mapping, form, request, response);
        }
        if (param.equals("upCondition")) {
            return this.upCondition(mapping, form, request, response);
        }
        if (param.equals("downCondition")) {
            return this.downCondition(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward showConditions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        TaskListForm existForm = (TaskListForm)((Object)sessionMap.get((Object)"taskListForm"));
        TaskListForm taskListForm = (TaskListForm)form;
        try {
            PropertyUtils.copyProperties((Object)((Object)taskListForm), (Object)((Object)existForm));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        ToolAccessMode mode = this.getAccessMode(request);
        if (mode.isAuthor()) {
            return mapping.findForward("success");
        }
        return mapping.findForward("definelater");
    }

    private ActionForward newConditionInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        ((TaskListConditionForm)form).setSessionMapID(sessionMapID);
        this.populateFormWithPossibleItems(form, request);
        return mapping.findForward("addcondition");
    }

    private ActionForward editCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SortedSet<TaskListCondition> conditionList;
        ArrayList<TaskListCondition> rList;
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int sequenceId = NumberUtils.stringToInt((String)request.getParameter("sequenceId"), (int)-1);
        TaskListCondition item = null;
        if (sequenceId != -1 && (item = (TaskListCondition)(rList = new ArrayList<TaskListCondition>(conditionList = this.getTaskListConditionList(sessionMap))).get(sequenceId)) != null) {
            this.populateConditionToForm(sequenceId, item, (TaskListConditionForm)form, request);
        }
        this.populateFormWithPossibleItems(form, request);
        return item == null ? null : mapping.findForward("addcondition");
    }

    private ActionForward saveOrUpdateCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TaskListConditionForm conditionForm;
        block3: {
            conditionForm = (TaskListConditionForm)form;
            ActionErrors errors = this.validateTaskListCondition(conditionForm, request);
            if (!errors.isEmpty()) {
                this.populateFormWithPossibleItems(form, request);
                this.addErrors(request, (ActionMessages)errors);
                return mapping.findForward("addcondition");
            }
            try {
                this.extractFormToTaskListCondition(request, conditionForm);
            }
            catch (Exception e) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.upload.failed", (Object)e.getMessage()));
                if (errors.isEmpty()) break block3;
                this.populateFormWithPossibleItems(form, request);
                this.addErrors(request, (ActionMessages)errors);
                return mapping.findForward("addcondition");
            }
        }
        request.setAttribute("sessionMapID", (Object)conditionForm.getSessionMapID());
        return mapping.findForward("success");
    }

    private ActionForward removeCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int sequenceId = NumberUtils.stringToInt((String)request.getParameter("sequenceId"), (int)-1);
        if (sequenceId != -1) {
            SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
            ArrayList<TaskListCondition> rList = new ArrayList<TaskListCondition>(conditionList);
            TaskListCondition condition = (TaskListCondition)rList.remove(sequenceId);
            conditionList.clear();
            conditionList.addAll(rList);
            List delList = this.getDeletedTaskListConditionList(sessionMap);
            delList.add(condition);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward upCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.switchItem(mapping, request, true);
    }

    private ActionForward downCondition(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.switchItem(mapping, request, false);
    }

    private ActionForward switchItem(ActionMapping mapping, HttpServletRequest request, boolean up) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int sequenceId = NumberUtils.stringToInt((String)request.getParameter("sequenceId"), (int)-1);
        if (sequenceId != -1) {
            SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
            ArrayList<TaskListCondition> rList = new ArrayList<TaskListCondition>(conditionList);
            TaskListCondition condition = (TaskListCondition)rList.get(sequenceId);
            TaskListCondition repCondition = up ? (TaskListCondition)rList.get(--sequenceId) : (TaskListCondition)rList.get(++sequenceId);
            int upSeqId = repCondition.getSequenceId();
            repCondition.setSequenceId(condition.getSequenceId());
            condition.setSequenceId(upSeqId);
            conditionList.clear();
            conditionList.addAll(rList);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ITaskListService getTaskListService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ITaskListService)wac.getBean("lataskTaskListService");
    }

    private SortedSet<TaskListCondition> getTaskListConditionList(SessionMap sessionMap) {
        TreeSet<TaskListCondition> list = (TreeSet<TaskListCondition>)sessionMap.get((Object)"conditionList");
        if (list == null) {
            list = new TreeSet<TaskListCondition>(new TaskListConditionComparator());
            sessionMap.put((Object)"conditionList", list);
        }
        return list;
    }

    private SortedSet<TaskListItem> getTaskListItemList(SessionMap sessionMap) {
        TreeSet<TaskListItem> list = (TreeSet<TaskListItem>)sessionMap.get((Object)"taskListList");
        if (list == null) {
            list = new TreeSet<TaskListItem>(new TaskListItemComparator());
            sessionMap.put((Object)"taskListList", list);
        }
        return list;
    }

    private List getDeletedTaskListConditionList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deleteConditionList");
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private void populateConditionToForm(int sequenceId, TaskListCondition condition, TaskListConditionForm form, HttpServletRequest request) {
        if (sequenceId >= 0) {
            form.setSequenceId(new Integer(sequenceId).toString());
        }
        form.setName(condition.getName());
        Set itemList = condition.getTaskListItems();
        String[] selectedItems = new String[itemList.size()];
        int i = 0;
        for (TaskListItem item : itemList) {
            selectedItems[i++] = new Integer(item.getSequenceId()).toString();
        }
        form.setSelectedItems(selectedItems);
    }

    private void populateFormWithPossibleItems(ActionForm form, HttpServletRequest request) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        SortedSet<TaskListItem> itemList = this.getTaskListItemList(sessionMap);
        LabelValueBean[] lvBeans = new LabelValueBean[itemList.size()];
        int i = 0;
        for (TaskListItem item : itemList) {
            lvBeans[i++] = new LabelValueBean(item.getTitle(), new Integer(item.getSequenceId()).toString());
        }
        ((TaskListConditionForm)form).setPossibleItems(lvBeans);
    }

    private void extractFormToTaskListCondition(HttpServletRequest request, TaskListConditionForm form) throws Exception {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(form.getSessionMapID());
        SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
        int sequenceId = NumberUtils.stringToInt((String)form.getSequenceId(), (int)-1);
        TaskListCondition condition = null;
        if (sequenceId == -1) {
            condition = new TaskListCondition();
            int maxSeq = 1;
            if (conditionList != null && conditionList.size() > 0) {
                TaskListCondition last = conditionList.last();
                maxSeq = last.getSequenceId() + 1;
            }
            condition.setSequenceId(maxSeq);
            conditionList.add(condition);
        } else {
            ArrayList<TaskListCondition> rList = new ArrayList<TaskListCondition>(conditionList);
            condition = (TaskListCondition)rList.get(sequenceId);
        }
        condition.setName(form.getName());
        String[] selectedItems = form.getSelectedItems();
        SortedSet<TaskListItem> itemList = this.getTaskListItemList(sessionMap);
        TreeSet<TaskListItem> conditionItemList = new TreeSet<TaskListItem>(new TaskListItemComparator());
        for (String selectedItem : selectedItems) {
            for (TaskListItem item : itemList) {
                if (!selectedItem.equals(new Integer(item.getSequenceId()).toString())) continue;
                conditionItemList.add(item);
            }
        }
        condition.setTaskListItems(conditionItemList);
    }

    private ActionErrors validateTaskListCondition(TaskListConditionForm conditionForm, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        String formConditionName = conditionForm.getName();
        if (StringUtils.isBlank((String)formConditionName)) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.condition.name.blank"));
        } else if (StringUtils.contains((String)formConditionName, (char)'#')) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.condition.name.contains.wrong.symbol"));
        } else {
            String formConditionSequenceId = conditionForm.getSequenceId();
            String sessionMapID = conditionForm.getSessionMapID();
            SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
            SortedSet<TaskListCondition> conditionList = this.getTaskListConditionList(sessionMap);
            for (TaskListCondition condition : conditionList) {
                if (!formConditionName.equals(condition.getName()) || formConditionSequenceId.equals(new Integer(condition.getSequenceId() - 1).toString())) continue;
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.condition.duplicated.name"));
                break;
            }
        }
        String[] selectedItems = conditionForm.getSelectedItems();
        if (selectedItems == null || selectedItems.length == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.condition.no.tasklistitems.selected"));
        }
        return errors;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private ActionMessages validate(TaskListForm taskListForm, ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        String modeStr = request.getParameter("mode");
        if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
            return errors;
        }
        return errors;
    }
}

