/*
 * Decompiled with CFR 0.152.
 */
package org.imsglobal.lti;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLMap {
    private static boolean DF = false;
    private static final String simpleText = "<a><b x=\"X\">B</b><c><d>D</d></c></a>";
    private static final String sitesText = "<sites> <site> <id>sue</id> </site> <site> <id>fred</id> <title>Title</title> <tools> <tool> <toolid>sakai.web.content</toolid> <properties> <property> <key>p1key</key> <val>p1val</val> </property> <property> <key>p2key</key> <val>p2val</val> </property> </properties> </tool> <tool> <toolid>sakai-wiki</toolid> <properties> <property> <key>wikikey</key> </property> </properties> </tool> <tool> <toolid>sakai-blog</toolid> </tool> </tools> </site> </sites>";
    private static final String rssText = "<rss version=\"2.0\"><channel><title>Dr-Chuck's Media</title><description>Television Shows and other media</description><link>http://www.dr-chuck.com/media.php</link><item><title>Track Days with John Merlin Williams</title><description>This film is about racing street Motorcyles.</description><link>http://www.dr-chuck.com</link></item><item><title>Motocross Racing</title><description>Dr. Chuck comes in second to last and is covered with mud.</description><link>http://www.dr-chuck.com/</link></item></channel></rss>";

    public static Map<String, String> getMap(String str) {
        if (str == null) {
            return null;
        }
        Document doc = XMLMap.documentFromString(str);
        if (doc == null) {
            return null;
        }
        return XMLMap.getMap(doc);
    }

    public static Map<String, String> getMap(Node doc) {
        Map<String, Object> tm = XMLMap.getObjectMap(doc, false);
        if (tm == null) {
            return null;
        }
        return XMLMap.flattenMap(tm);
    }

    public static Map<String, String> flattenMap(Map<String, Object> theMap) {
        if (theMap == null) {
            return null;
        }
        TreeMap<String, String> retval = new TreeMap<String, String>();
        for (String key : theMap.keySet()) {
            Object value = theMap.get(key);
            if (!(value instanceof String)) continue;
            String svalue = (String)value;
            if (value == null) continue;
            retval.put(key, svalue);
        }
        return retval;
    }

    public static Map<String, Object> getFullMap(Node doc) {
        return XMLMap.getObjectMap(doc, true);
    }

    public static Map<String, Object> getFullMap(String str) {
        if (str == null) {
            return null;
        }
        Document doc = XMLMap.documentFromString(str);
        if (doc == null) {
            return null;
        }
        return XMLMap.getObjectMap(doc, true);
    }

    private static Map<String, Object> getObjectMap(Node doc, boolean doFull) {
        if (doc == null) {
            return null;
        }
        TreeMap<String, Object> tm = new TreeMap<String, Object>();
        XMLMap.recurse(tm, "", doc, doFull, 0);
        return tm;
    }

    public static Document documentFromString(String input) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new ByteArrayInputStream(input.getBytes()));
            return document;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String addSlash(String path) {
        if (path == null) {
            return "/";
        }
        if (path.trim().equals("/")) {
            return "/";
        }
        return path + "/";
    }

    private static void recurse(Map<String, Object> tm, String path, Node parentNode, boolean doFull, int d) {
        ArrayList newList;
        Node node;
        Node node2;
        int i;
        if (DF) {
            XMLMap.doDebug(d, "> recurse path=" + path + " parentNode=" + XMLMap.nodeToString(parentNode));
        }
        ++d;
        NodeList nl = parentNode.getChildNodes();
        NamedNodeMap nm = parentNode.getAttributes();
        boolean nodeCount = false;
        String value = null;
        if (nl != null) {
            for (i = 0; i < nl.getLength(); ++i) {
                node2 = nl.item(i);
                if (node2.getNodeType() != 3) continue;
                value = node2.getNodeValue();
                if (value == null || value.trim().length() < 1) break;
                tm.put(path, node2.getNodeValue());
                break;
            }
        }
        if (nm != null) {
            for (i = 0; i < nm.getLength(); ++i) {
                node2 = nm.item(i);
                if (node2.getNodeType() != 2) continue;
                String name = node2.getNodeName();
                value = node2.getNodeValue();
                if (name == null || name.trim().length() < 1 || value == null || value.trim().length() < 1) continue;
                String newPath = path + "!" + name;
                tm.put(newPath, value);
            }
        }
        if (!doFull) {
            HashSet<String> done = new HashSet<String>();
            if (nl != null) {
                for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                    node = nl.item(i2);
                    if (node.getNodeType() != 1 || done.contains(node.getNodeName())) continue;
                    if (DF) {
                        XMLMap.doDebug(d, "Going down the rabbit hole path=" + path + " node=" + node.getNodeName());
                    }
                    XMLMap.recurse(tm, XMLMap.addSlash(path) + node.getNodeName(), node, doFull, d);
                    if (DF) {
                        XMLMap.doDebug(d, "Back from the rabbit hole path=" + path + " node=" + node.getNodeName());
                    }
                    done.add(node.getNodeName());
                }
            }
            --d;
            if (DF) {
                XMLMap.doDebug(d, "< recurse path=" + path + " parentNode=" + XMLMap.nodeToString(parentNode));
            }
            return;
        }
        TreeMap<String, Integer> childMap = new TreeMap<String, Integer>();
        if (nl != null) {
            for (int i3 = 0; i3 < nl.getLength(); ++i3) {
                node = nl.item(i3);
                if (node.getNodeType() != 1) continue;
                Integer count = (Integer)childMap.get(node.getNodeName());
                if (count == null) {
                    count = new Integer(0);
                }
                count = count + 1;
                childMap.put(node.getNodeName(), count);
            }
        }
        if (childMap.size() < 1) {
            return;
        }
        Iterator iter = childMap.keySet().iterator();
        TreeMap nodeMap = new TreeMap();
        while (iter.hasNext()) {
            Integer count;
            String nextChild = (String)iter.next();
            if (nextChild == null || (count = (Integer)childMap.get(nextChild)) == null || count < 2) continue;
            if (DF) {
                XMLMap.doDebug(d, "Making a List for " + nextChild);
            }
            newList = new ArrayList();
            nodeMap.put(nextChild, newList);
        }
        if (nl != null) {
            for (int i4 = 0; i4 < nl.getLength(); ++i4) {
                String childName;
                Node node3 = nl.item(i4);
                if (node3.getNodeType() != 1 || (childName = node3.getNodeName()) == null) continue;
                List mapList = (List)nodeMap.get(childName);
                if (mapList == null) {
                    if (DF) {
                        XMLMap.doDebug(d, "Going down the single rabbit hole path=" + path + " node=" + node3.getNodeName());
                    }
                    XMLMap.recurse(tm, XMLMap.addSlash(path) + node3.getNodeName(), node3, doFull, d);
                    if (!DF) continue;
                    XMLMap.doDebug(d, "Back from the single rabbit hole path=" + path + " node=" + node3.getNodeName());
                    continue;
                }
                if (DF) {
                    XMLMap.doDebug(d, "Going down the multi rabbit hole path=" + path + " node=" + node3.getNodeName());
                }
                TreeMap<String, Object> newMap = new TreeMap<String, Object>();
                XMLMap.recurse(newMap, "/", node3, doFull, d);
                if (DF) {
                    XMLMap.doDebug(d, "Back from the multi rabbit hole path=" + path + " node=" + node3.getNodeName() + " map=" + newMap);
                }
                if (newMap.size() <= 0) continue;
                mapList.add(newMap);
            }
        }
        for (String nextChild : nodeMap.keySet()) {
            if (nextChild == null || (newList = (ArrayList)nodeMap.get(nextChild)) == null || newList.size() < 1) continue;
            if (DF) {
                XMLMap.doDebug(d, "Adding sub-map name=" + nextChild + " list=" + newList);
            }
            tm.put(path + "/" + nextChild, newList);
        }
        --d;
        if (DF) {
            XMLMap.doDebug(d, "< recurse path=" + path + " parentNode=" + XMLMap.nodeToString(parentNode));
        }
    }

    public static String getXML(Map<?, ?> tm) {
        Document document = XMLMap.getXMLDom(tm);
        if (document == null) {
            return null;
        }
        return XMLMap.documentToString(document, false);
    }

    public static String getXMLFragment(Map<?, ?> tm, boolean pretty) {
        int pos;
        String retval = XMLMap.getXML(tm, pretty);
        if (retval.startsWith("<?xml") && (pos = retval.indexOf("<", 1)) > 0) {
            retval = retval.substring(pos);
        }
        return retval;
    }

    public static String getXML(Map<?, ?> tm, boolean pretty) {
        Document document = XMLMap.getXMLDom(tm);
        if (document == null) {
            return null;
        }
        String retval = XMLMap.documentToString(document, pretty);
        if (pretty) {
            retval = XMLMap.prettyPostProcess(retval);
        }
        return retval;
    }

    public static String prettyPrint(String input) {
        Map<String, Object> theMap = XMLMap.getFullMap(input);
        return XMLMap.getXML(theMap, true);
    }

    private static String prettyPostProcess(String inString) {
        StringBuffer sb = new StringBuffer();
        int depth = 0;
        boolean newLine = false;
        for (int i = 0; i < inString.length(); ++i) {
            char ch = inString.charAt(i);
            int nc = 32;
            if (i + 1 < inString.length()) {
                nc = inString.charAt(i + 1);
            }
            if (ch == '\n') {
                sb.append('\n');
                newLine = true;
                continue;
            }
            if (newLine && (ch == ' ' || ch == '\t')) continue;
            if (ch == '<' && nc == 47) {
                --depth;
            }
            if (newLine) {
                for (int j = 0; j < depth && j < 15; ++j) {
                    sb.append("  ");
                }
                newLine = false;
            }
            if (ch == '<' && nc != 47 && nc != 63) {
                ++depth;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Document getXMLDom(Map<?, ?> tm) {
        if (tm == null) {
            return null;
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.newDocument();
        }
        catch (Exception e) {
            return null;
        }
        XMLMap.iterateMap(document, document.getDocumentElement(), tm, 0);
        return document;
    }

    private static void iterateMap(Document document, Node parentNode, Map<?, ?> tm, int d) {
        if (DF) {
            XMLMap.doDebug(d, "> IterateMap parentNode= " + XMLMap.nodeToString(parentNode));
        }
        ++d;
        for (String key : tm.keySet()) {
            Object obj;
            if (key == null || !key.startsWith("/") || (obj = tm.get(key)) == null) continue;
            if (obj instanceof String) {
                XMLMap.storeInDom(document, parentNode, key, (String)obj, 0, d);
                continue;
            }
            if (obj instanceof String[]) {
                String[] strArray = (String[])obj;
                if (DF) {
                    XMLMap.doDebug(d, "Looping through an array of length " + strArray.length);
                }
                for (int i = 0; i < strArray.length; ++i) {
                    XMLMap.storeInDom(document, parentNode, key, strArray[i], i, d);
                }
                continue;
            }
            if (obj instanceof Map) {
                Map subMap = (Map)obj;
                Node startNode = XMLMap.getNodeAtPath(document, parentNode, key, 0, d);
                if (DF) {
                    XMLMap.doDebug(d, "descending into Map path=" + key + " startNode=" + XMLMap.nodeToString(startNode));
                }
                XMLMap.iterateMap(document, startNode, subMap, d);
                if (!DF) continue;
                XMLMap.doDebug(d, "back from descent Map path=" + key + " startNode=" + XMLMap.nodeToString(startNode));
                continue;
            }
            if (obj instanceof List) {
                List lst = (List)obj;
                if (DF) {
                    XMLMap.doDebug(d, "Have a list that is this long " + lst.size());
                }
                Iterator listIter = lst.iterator();
                int newPos = 0;
                while (listIter.hasNext()) {
                    Object listObj = listIter.next();
                    if (DF) {
                        XMLMap.doDebug(d, "Processing List element@" + newPos + " " + listObj.getClass().getName());
                    }
                    if (listObj instanceof String) {
                        XMLMap.storeInDom(document, parentNode, key, (String)listObj, newPos, d);
                        ++newPos;
                    }
                    if (listObj instanceof Map) {
                        Map subMap = (Map)listObj;
                        if (DF) {
                            XMLMap.doDebug(d, "Retrieving key from  List-Map path=" + key + "@" + newPos);
                        }
                        Node startNode = XMLMap.getNodeAtPath(document, parentNode, key, newPos, d);
                        if (DF) {
                            XMLMap.doDebug(d, "descending into List-Map path=" + key + "@" + newPos + " startNode=" + XMLMap.nodeToString(startNode));
                        }
                        XMLMap.iterateMap(document, startNode, subMap, d);
                        if (DF) {
                            XMLMap.doDebug(d, "back from descent List-Map path=" + key + "@" + newPos + " startNode=" + XMLMap.nodeToString(startNode));
                        }
                        ++newPos;
                        continue;
                    }
                    System.out.println("XMLMap Encountered an object of type " + obj.getClass().getName() + " in a List which should contain only Map objects");
                }
                continue;
            }
            if (!DF) continue;
            XMLMap.doDebug(d, "Found a " + obj.getClass().getName() + " do not know how to iterate.");
        }
        --d;
        if (DF) {
            XMLMap.doDebug(d, "< IterateMap parentNode = " + XMLMap.nodeToString(parentNode));
        }
    }

    private static void storeInDom(Document document, Node parentNode, String key, String value, int nodePos, int d) {
        if (DF) {
            XMLMap.doDebug(d, "> storeInDom" + key + "@" + nodePos + " = " + value + " parent=" + XMLMap.nodeToString(parentNode));
        }
        ++d;
        if (document == null || key == null || value == null) {
            return;
        }
        if (parentNode == null) {
            parentNode = document;
        }
        if (DF) {
            XMLMap.doDebug(d, "parentNode I=" + XMLMap.nodeToString(parentNode));
        }
        String[] newPath = key.split("/");
        if (DF) {
            XMLMap.doDebug(d, "newPath = " + XMLMap.outStringArray(newPath));
        }
        String nodeAttr = null;
        for (int i = 1; i < newPath.length; ++i) {
            String nodeName = newPath[i];
            if (i == newPath.length - 1) {
                String[] nodeSplit = nodeName.split("!");
                if (nodeSplit.length > 1) {
                    nodeName = nodeSplit[0];
                    nodeAttr = nodeSplit[1];
                }
                parentNode = XMLMap.getOrAddChildNode(document, parentNode, nodeName, nodePos, d);
                continue;
            }
            parentNode = XMLMap.getOrAddChildNode(document, parentNode, nodeName, 0, d);
        }
        if (nodeAttr != null) {
            if (value != null && parentNode instanceof Element) {
                Element element = (Element)parentNode;
                element.setAttribute(nodeAttr, value);
            }
        } else if (value != null) {
            Text newNode = document.createTextNode(value);
            parentNode.appendChild(newNode);
        }
        --d;
    }

    private static Node getNodeAtPath(Document document, Node parentNode, String path, int nodePos, int d) {
        if (parentNode == null) {
            parentNode = document;
        }
        if (DF) {
            XMLMap.doDebug(d, "> getNodeAtPath path@" + nodePos + "=" + path + " parentNode=" + XMLMap.nodeToString(parentNode));
        }
        ++d;
        String[] newPath = path.split("/");
        for (int i = 1; i < newPath.length; ++i) {
            String nodeName = newPath[i];
            if (i == newPath.length - 1) {
                String[] nodeSplit = nodeName.split("!");
                if (nodeSplit.length > 1) {
                    nodeName = nodeSplit[0];
                }
                parentNode = XMLMap.getOrAddChildNode(document, parentNode, nodeName, nodePos, d);
                continue;
            }
            parentNode = XMLMap.getOrAddChildNode(document, parentNode, nodeName, 0, d);
        }
        --d;
        if (DF) {
            XMLMap.doDebug(d, "< getNodeAtPath returning=" + XMLMap.nodeToString(parentNode));
        }
        return parentNode;
    }

    private static Node getOrAddChildNode(Document doc, Node parentNode, String nodeName, int whichNode, int d) {
        if (DF) {
            XMLMap.doDebug(d, "> getOrAddChildNode name=" + nodeName + "@" + whichNode + " parentNode=" + XMLMap.nodeToString(parentNode));
        }
        ++d;
        if (nodeName == null || parentNode == null) {
            return null;
        }
        int begpos = nodeName.indexOf(91);
        int endpos = nodeName.indexOf(93);
        if (begpos > 0 && endpos > begpos && endpos < nodeName.length()) {
            String indStr = nodeName.substring(begpos + 1, endpos);
            if (DF) {
                XMLMap.doDebug(d, "Index String = " + indStr);
            }
            nodeName = nodeName.substring(0, begpos);
            if (DF) {
                XMLMap.doDebug(d, "New Nodename=" + nodeName);
            }
            Integer iVal = new Integer(indStr);
            if (DF) {
                XMLMap.doDebug(d, "Integer = " + iVal);
            }
            whichNode = iVal;
        }
        NodeList nl = parentNode.getChildNodes();
        int foundNodes = -1;
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1 || !nodeName.equals(node.getNodeName())) continue;
                ++foundNodes;
                --d;
                if (DF) {
                    XMLMap.doDebug(d, "< getOrAddChildNode found name=" + XMLMap.nodeToString(node));
                }
                if (DF) {
                    XMLMap.doDebug(d, "foundNodes = " + foundNodes + " looking for node=" + whichNode);
                }
                if (foundNodes < whichNode) continue;
                return node;
            }
        }
        Element newNode = null;
        while (foundNodes < whichNode) {
            ++foundNodes;
            if (DF) {
                XMLMap.doDebug(d, "Adding node at position " + foundNodes + " moving toward " + whichNode);
            }
            if (nodeName == null) continue;
            newNode = doc.createElement(nodeName);
            if (DF) {
                XMLMap.doDebug(d, "Adding " + nodeName + " at " + XMLMap.nodeToString(parentNode) + " in " + doc);
            }
            parentNode.appendChild(newNode);
            if (DF) {
                XMLMap.doDebug(d, "xml=" + XMLMap.documentToString(doc, false));
            }
            if (!DF) continue;
            XMLMap.doDebug(d, "getOrAddChildNode added newnode=" + XMLMap.nodeToString(newNode));
        }
        --d;
        if (DF) {
            XMLMap.doDebug(d, "< getOrAddChildNode added newnode=" + XMLMap.nodeToString(newNode));
        }
        return newNode;
    }

    public static String outStringArray(String[] arr) {
        if (arr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append("[" + i + "]=");
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String nodeToString(Node node) {
        if (node == null) {
            return null;
        }
        String retval = node.getNodeName();
        while ((node = node.getParentNode()) != null) {
            retval = node.getNodeName() + "/" + retval;
        }
        return "/" + retval;
    }

    public static String documentToString(Document document, boolean pretty) {
        return XMLMap.nodeToString(document, pretty);
    }

    public static String nodeToString(Node node, boolean pretty) {
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            if (pretty) {
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            ByteArrayOutputStream baStream = new ByteArrayOutputStream();
            tf.transform(new DOMSource(node), new StreamResult(baStream));
            return baStream.toString();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public static Map<String, String> selectSubMap(Map<String, String> sm, String selection) {
        if (sm == null) {
            return null;
        }
        if (XMLMap.badSelection(selection = selection.trim())) {
            return null;
        }
        TreeMap<String, String> retval = new TreeMap<String, String>();
        XMLMap.selectSubMap(sm, retval, null, null, selection);
        return retval;
    }

    public static Map<String, Object> selectFullSubMap(Map<String, Object> om, String selection) {
        if (om == null) {
            return null;
        }
        if (XMLMap.badSelection(selection = selection.trim())) {
            return null;
        }
        TreeMap<String, Object> retval = new TreeMap<String, Object>();
        XMLMap.selectSubMap(null, null, om, retval, selection);
        return retval;
    }

    private static boolean badSelection(String selection) {
        if (selection == null) {
            return true;
        }
        if (selection.equals("/")) {
            return true;
        }
        if (selection.length() < 2) {
            return true;
        }
        return !selection.startsWith("/");
    }

    private static void selectSubMap(Map<String, String> sm, Map<String, String> sret, Map<String, Object> om, Map<String, Object> oret, String selection) {
        Iterator<String> iter = null;
        iter = sm != null ? sm.keySet().iterator() : om.keySet().iterator();
        while (iter.hasNext()) {
            Object value;
            String key = iter.next();
            boolean match = false;
            String newKey = null;
            if (key.equals(selection)) {
                match = true;
                newKey = "/";
            } else if (selection.endsWith("/") && key.startsWith(selection)) {
                match = true;
                newKey = key.substring(selection.length() - 1);
            } else if (key.startsWith(selection + "/")) {
                match = true;
                newKey = key.substring(selection.length());
            } else if (key.startsWith(selection + "!")) {
                match = true;
                newKey = "/" + key.substring(selection.length());
            }
            if (!match) continue;
            if (sm != null) {
                value = sm.get(key);
                if (value == null) continue;
                sret.put(newKey, (String)value);
                continue;
            }
            value = om.get(key);
            if (value == null) continue;
            oret.put(newKey, value);
        }
    }

    public static void removeSubMap(Map<?, ?> tm, String selection) {
        if (tm == null) {
            return;
        }
        if (XMLMap.badSelection(selection = selection.trim())) {
            return;
        }
        String childSel = selection = selection.trim();
        String attrSel = selection;
        if (!selection.endsWith("/")) {
            childSel = selection + "/";
            attrSel = selection + "!";
        }
        HashSet<String> delSet = new HashSet<String>();
        for (Object key : tm.keySet()) {
            String strKey;
            if (!(key instanceof String) || !(strKey = (String)key).equals(selection) && !strKey.startsWith(childSel) && !strKey.startsWith(attrSel)) continue;
            delSet.add(strKey);
        }
        for (String key : delSet) {
            tm.remove(key);
        }
    }

    private static void doDebug(int d, String str) {
        if (!DF) {
            return;
        }
        for (int i = 0; i < d; ++i) {
            System.out.print(" ");
        }
        System.out.println(str);
    }

    public static String getString(Map<String, Object> theMap, String key) {
        if (theMap == null) {
            return null;
        }
        Object obj = theMap.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public static List<Map<String, Object>> getList(Map<String, Object> theMap, String key) {
        ArrayList<Map<String, Object>> al = new ArrayList<Map<String, Object>>();
        if (theMap == null || key == null) {
            return al;
        }
        Object obj = theMap.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        Map<String, Object> oneMap = XMLMap.selectFullSubMap(theMap, key);
        if (oneMap == null) {
            return al;
        }
        if (oneMap.isEmpty()) {
            return al;
        }
        al.add(oneMap);
        return al;
    }

    public static List<Map<String, Object>> getList(String xmlInput, String key) {
        Map<String, Object> tmpMap = XMLMap.getFullMap(xmlInput);
        return XMLMap.getList(tmpMap, key);
    }

    public static boolean unitTest(String xmlString, boolean doDebug) {
        String pretty2;
        String pretty13;
        if (xmlString == null) {
            return false;
        }
        DF = doDebug;
        if (doDebug) {
            String pretty22;
            DF = true;
            String pretty12 = XMLMap.prettyPrint(xmlString);
            if (pretty12.equals(pretty22 = XMLMap.prettyPrint(pretty12))) {
                return true;
            }
            System.out.println("XMLMap - unit test failed");
            return false;
        }
        DF = false;
        try {
            pretty13 = XMLMap.prettyPrint(xmlString);
            pretty2 = XMLMap.prettyPrint(pretty13);
            if (pretty13.equals(pretty2)) {
                return true;
            }
        }
        catch (Throwable pretty13) {
            // empty catch block
        }
        System.out.println("XMLMap - unit test failed");
        System.out.println(xmlString);
        DF = true;
        pretty13 = XMLMap.prettyPrint(xmlString);
        System.out.println("Pretty Print Version pass 1\n" + pretty13);
        pretty2 = XMLMap.prettyPrint(pretty13);
        System.out.println("Pretty Print Version pass 2\n" + pretty2);
        DF = false;
        return false;
    }

    public static boolean allUnitTests() {
        if (!XMLMap.unitTest(simpleText, false)) {
            return false;
        }
        if (!XMLMap.unitTest(sitesText, false)) {
            return false;
        }
        return XMLMap.unitTest(rssText, false);
    }

    public static void main(String[] args) {
        System.out.println("Running XMLMap (www.mdom.org) unit tests..");
        if (!XMLMap.allUnitTests()) {
            return;
        }
        System.out.println("Unit tests passed...");
        XMLMap.runSamples();
    }

    public static void runSamples() {
        System.out.println("Running XMLMap (www.mdom.org) Samples...");
        DF = false;
        Map<String, String> tm = XMLMap.getMap(simpleText);
        TreeMap<String, String> simpleMap = new TreeMap<String, String>();
        simpleMap.put("/a/b!x", "X");
        simpleMap.put("/a/b", "B");
        simpleMap.put("/a/c/d", "D");
        System.out.println("simpleMap\n" + simpleMap);
        String simpleXml = XMLMap.getXML(simpleMap, true);
        System.out.println("simpleXml\n" + simpleXml);
        XMLMap.unitTest(simpleXml, false);
        Map<String, String> subMap = XMLMap.selectSubMap(tm, "/a/c");
        TreeMap<String, Object> joinedMap = new TreeMap<String, Object>();
        System.out.println("subMap=" + subMap);
        joinedMap.put("/top/id", "1234");
        joinedMap.put("/top/fun", subMap);
        System.out.println("joinedMap\n" + joinedMap);
        String joinedXml = XMLMap.getXML(joinedMap, true);
        System.out.println("joinedXML\n" + joinedXml);
        XMLMap.unitTest(joinedXml, false);
        TreeMap<String, String[]> arrayMap = new TreeMap<String, String[]>();
        String[] arrayStr = new String[]{"first", "second", "third"};
        arrayMap.put("/root/stuff", arrayStr);
        System.out.println("arrayMap\n" + arrayMap);
        String arrayXml = XMLMap.getXML(arrayMap, true);
        System.out.println("arrayXml\n" + arrayXml);
        XMLMap.unitTest(arrayXml, false);
        TreeMap<String, Object> newMap = new TreeMap<String, Object>();
        newMap.put("/Root/milton", "Root-milton");
        newMap.put("/Root/joe", "Root-joe");
        TreeMap<String, String> m2 = new TreeMap<String, String>();
        m2.put("/fred/a", "fred-a");
        m2.put("/fred/b", "fred-b");
        newMap.put("/Root/freds", m2);
        ArrayList lm = new ArrayList();
        TreeMap<String, String> m3 = null;
        m3 = new TreeMap<String, String>();
        m3.put("/key", "key-0");
        m3.put("/val", "val-0");
        lm.add(m3);
        m3 = new TreeMap();
        m3.put("/key", "key-1");
        m3.put("/val", "val-1");
        lm.add(m3);
        newMap.put("/Root/maps/map", lm);
        String[] strar = new String[]{"first", "second", "third"};
        newMap.put("/Root/array", strar);
        ArrayList l1 = new ArrayList();
        TreeMap<String, String> m4 = new TreeMap<String, String>();
        m4.put("/", "item-1");
        l1.add(m4);
        TreeMap<String, String> m5 = new TreeMap<String, String>();
        m5.put("/", "item-2");
        l1.add(m5);
        newMap.put("/Root/item", l1);
        newMap.put("/Root/anns/ann[0]", "Root-ann[0]");
        newMap.put("/Root/anns/ann[1]", "Root-ann[1]");
        newMap.put("/Root/bobs/bob[0]/key", "Root-bobs-bob[0]-key");
        newMap.put("/Root/bobs/bob[0]/val", "Root-bobs-bob[0]-val");
        newMap.put("/Root/bobs/bob[1]/key", "Root-bobs-bob[1]-key");
        newMap.put("/Root/bobs/bob[1]/val", "Root-bobs-bob[1]-val");
        String complexXml = null;
        boolean success = false;
        DF = false;
        try {
            complexXml = XMLMap.getXML(newMap, true);
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        if (success) {
            XMLMap.unitTest(complexXml, false);
        } else {
            DF = true;
            System.out.println("\n MISMATCH AND/OR SOME ERROR HAS OCCURED - REDO in VERBODE MODE");
            System.out.println("Starting out newMap=" + newMap);
            complexXml = XMLMap.getXML(newMap, true);
            XMLMap.unitTest(complexXml, false);
            DF = false;
        }
        System.out.println("\nParsing Sites Structure");
        for (Map<String, Object> siteMap : XMLMap.getList(sitesText, "/sites/site")) {
            System.out.println("Site=" + siteMap);
            System.out.println("Id=" + XMLMap.getString(siteMap, "/id"));
            for (Map<String, Object> toolMap : XMLMap.getList(siteMap, "/tools/tool")) {
                System.out.println("Tool=" + toolMap);
                System.out.println("ToolId=" + XMLMap.getString(toolMap, "/toolid"));
                for (Map<String, Object> property : XMLMap.getList(toolMap, "/properties/property")) {
                    System.out.println("key=" + XMLMap.getString(property, "/key"));
                    System.out.println("val=" + XMLMap.getString(property, "/val"));
                }
            }
        }
        DF = false;
        System.out.println("\nParsing RSS Feed");
        Map<String, Object> rssFullMap = XMLMap.getFullMap(rssText);
        System.out.println("RSS Full Map\n" + rssFullMap);
        System.out.println("Rss Version=" + XMLMap.getString(rssFullMap, "/rss!version"));
        System.out.println("Chan-desc=" + XMLMap.getString(rssFullMap, "/rss/channel/description"));
        System.out.println("Chan-title=" + XMLMap.getString(rssFullMap, "/rss/channel/title"));
        Map<String, String> rssStringMap = XMLMap.flattenMap(rssFullMap);
        System.out.println("RSS Flat String Only Map\n" + rssStringMap);
        System.out.println("Rss Version=" + rssStringMap.get("/rss!version"));
        System.out.println("Chan-desc=" + rssStringMap.get("/rss/channel/description"));
        System.out.println("Chan-title=" + rssStringMap.get("/rss/channel/title"));
        for (Map<String, Object> rssItem : XMLMap.getList(rssFullMap, "/rss/channel/item")) {
            System.out.println("=== Item ===");
            System.out.println(" Item-title=" + XMLMap.getString(rssItem, "/title"));
            System.out.println(" Item-description=" + XMLMap.getString(rssItem, "/description"));
            System.out.println(" Item-link=" + XMLMap.getString(rssItem, "/link"));
        }
    }
}

