/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.AbstractSVGLightingElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.renderable.DiffuseLightingRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeDiffuseLightingElementBridge
extends AbstractSVGLightingElementBridge {
    public String getLocalName() {
        return "feDiffuseLighting";
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        float surfaceScale = AbstractSVGFilterPrimitiveElementBridge.convertNumber(filterElement, "surfaceScale", 1.0f, ctx);
        float diffuseConstant = AbstractSVGFilterPrimitiveElementBridge.convertNumber(filterElement, "diffuseConstant", 1.0f, ctx);
        Light light = AbstractSVGLightingElementBridge.extractLight(filterElement, ctx);
        double[] kernelUnitLength = AbstractSVGLightingElementBridge.convertKernelUnitLength(filterElement, ctx);
        Filter in = AbstractSVGFilterPrimitiveElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        DiffuseLightingRable8Bit filter = new DiffuseLightingRable8Bit(in, primitiveRegion, light, diffuseConstant, surfaceScale, kernelUnitLength);
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters(filter, filterElement);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(filterElement, filter, filterMap);
        return filter;
    }
}

